/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.preferences;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TestCaseSettingPage
extends PreferencePageWithHelp {
    private Composite container;
    private Combo cbbFailureHanlings;
    private String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
    private TestCaseSettingStore settingStore = new TestCaseSettingStore(this.projectDir);
    private boolean modified;

    public TestCaseSettingPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)layout);
        Label label = new Label(this.container, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText(StringConstants.DEFAULT_FAILURE_HANDLING);
        this.cbbFailureHanlings = new Combo(this.container, 8);
        this.cbbFailureHanlings.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.initValue();
        this.registerControlModifyListeners();
        return this.container;
    }

    private void registerControlModifyListeners() {
        this.cbbFailureHanlings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseSettingPage.this.modified = true;
            }
        });
    }

    private void initValue() {
        this.cbbFailureHanlings.setItems(FailureHandling.valueStrings());
        FailureHandling defaultFailureHandling = this.settingStore.getDefaultFailureHandling();
        this.cbbFailureHanlings.select(defaultFailureHandling.ordinal());
        this.modified = false;
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        if (this.modified) {
            this.settingStore.saveDefaultFailureHandling(FailureHandling.valueStrings()[this.cbbFailureHanlings.getSelectionIndex()]);
            EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/FAILURE_HANDLING_UPDATED", null);
        }
        return super.performOk();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTING_TEST_CASE;
    }
}

