/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.preferences;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.preferences.RecentObjectStorage;
import com.kms.katalon.composer.testcase.preferences.StoredKeyword;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;

public class TestCasePreferenceDefaultValueInitializer
extends AbstractPreferenceInitializer {
    private static final String CALL_TEST_CASE = "callTestCase";
    private static final int MAXIMUM_RECENT_KEYWORDS_NUM = 10;

    private static ScopedPreferenceStore getStore() {
        return PreferenceStoreManager.getPreferenceStore(TestCasePreferenceDefaultValueInitializer.class);
    }

    public void initializeDefaultPreferences() {
        ScopedPreferenceStore store = TestCasePreferenceDefaultValueInitializer.getStore();
        store.setDefault("default.variableType", InputValueType.String.name());
        store.setDefault("auto.generateDefaultVariableType", true);
        store.setDefault("auto.exportVariable", false);
        store.setDefault("default.keywordType", ((KeywordClass)KeywordController.getInstance().getBuiltInKeywordClasses().get(0)).getName());
        HashMap<String, String> defaultKeywords = new HashMap<String, String>();
        for (KeywordClass keywordClass : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            defaultKeywords.put(keywordClass.getName(), ((KeywordMethod)KeywordController.getInstance().getBuiltInKeywords(keywordClass.getSimpleName(), true).get(0)).getName());
        }
        store.setDefault("default.keywords", TestCasePreferenceDefaultValueInitializer.convertKeywordMapToJsonArray(defaultKeywords).toString());
        store.setDefault("default.failureHandling", FailureHandling.STOP_ON_FAILURE.name());
        store.setDefault("default.startView", TestCaseCompositePart.MANUAL_TAB_TITLE);
        Type listType = new TypeToken<List<String>>(){}.getType();
        store.setDefault("recent.keywords", JsonUtil.toJson(Collections.emptyList(), (Type)listType, (boolean)false));
        Type mapType = new TypeToken<Map<String, RecentObjectStorage>>(){}.getType();
        store.setDefault("recent.testObjects", JsonUtil.toJson(Collections.emptyMap(), (Type)mapType, (boolean)false));
    }

    public static boolean isSetGenerateVariableDefaultValue() {
        return TestCasePreferenceDefaultValueInitializer.getStore().getBoolean("auto.generateDefaultVariableType");
    }

    public static boolean isSetAutoExportVariables() {
        return TestCasePreferenceDefaultValueInitializer.getStore().getBoolean("auto.exportVariable");
    }

    protected static String callTestCaseMethodName() {
        return CALL_TEST_CASE;
    }

    public static Map<String, String> getDefaultKeywords() {
        String defaultKeywordJsonString = TestCasePreferenceDefaultValueInitializer.getStore().getString("default.keywords");
        HashMap<String, String> defaultKeywords = new HashMap<String, String>();
        if (!StringUtils.isBlank((String)defaultKeywordJsonString)) {
            JsonArray parser = (JsonArray)new JsonParser().parse(defaultKeywordJsonString);
            int i = 0;
            while (i < parser.size()) {
                JsonObject jsonObject = (JsonObject)parser.get(i);
                defaultKeywords.put(jsonObject.get("keywordType").getAsString(), jsonObject.get("keywordName").getAsString());
                ++i;
            }
        }
        return defaultKeywords;
    }

    public static KeywordClass getDefaultKeywordType() {
        String keywordType = TestCasePreferenceDefaultValueInitializer.getStore().getString("default.keywordType");
        KeywordClass contributor = KeywordController.getInstance().getBuiltInKeywordClassByName(keywordType);
        if (contributor == null) {
            contributor = (KeywordClass)KeywordController.getInstance().getBuiltInKeywordClasses().get(0);
        }
        return contributor;
    }

    public static String getDefaultMethodName(IKeywordContributor contributor) {
        Map<String, String> defaultKeywords = TestCasePreferenceDefaultValueInitializer.getDefaultKeywords();
        String contributingClassName = contributor.getKeywordClass().getName();
        String defaultMethodName = defaultKeywords.get(contributingClassName);
        return defaultMethodName;
    }

    public static void storeDefaultKeywords(Map<String, String> defaultKeywords) {
        JsonArray keywordArray = TestCasePreferenceDefaultValueInitializer.convertKeywordMapToJsonArray(defaultKeywords);
        TestCasePreferenceDefaultValueInitializer.getStore().setValue("default.keywords", keywordArray.toString());
    }

    private static JsonArray convertKeywordMapToJsonArray(Map<String, String> defaultKeywords) {
        JsonArray keywordArray = new JsonArray();
        for (Map.Entry<String, String> entry : defaultKeywords.entrySet()) {
            JsonObject keywordJsonObject = new JsonObject();
            keywordJsonObject.add("keywordType", (JsonElement)new JsonPrimitive(entry.getKey()));
            keywordJsonObject.add("keywordName", (JsonElement)new JsonPrimitive(entry.getValue()));
            keywordArray.add((JsonElement)keywordJsonObject);
        }
        return keywordArray;
    }

    public static FailureHandling getDefaultFailureHandling() {
        String failureHandlingName = TestCasePreferenceDefaultValueInitializer.getStore().getString("default.failureHandling");
        return FailureHandling.valueOf((String)failureHandlingName);
    }

    public static String getTestCasePartStartView() {
        return TestCasePreferenceDefaultValueInitializer.getStore().getString("default.startView");
    }

    public static List<StoredKeyword> getRecentKeywords() {
        String recentKeywordsAsJSONString = TestCasePreferenceDefaultValueInitializer.getStore().getString("recent.keywords");
        Type listType = new TypeToken<List<StoredKeyword>>(){}.getType();
        return (List)JsonUtil.fromJson((String)recentKeywordsAsJSONString, (Type)listType);
    }

    public static void addNewRecentKeywords(StoredKeyword recent) {
        LinkedList<StoredKeyword> recentKeywords = new LinkedList<StoredKeyword>(TestCasePreferenceDefaultValueInitializer.getRecentKeywords());
        if (recentKeywords.contains(recent)) {
            recentKeywords.remove(recent);
        }
        recentKeywords.add(0, recent);
        String recentKeywordsAsJSONString = JsonUtil.toJson(recentKeywords.subList(0, Math.min(10, recentKeywords.size())), (boolean)false);
        TestCasePreferenceDefaultValueInitializer.getStore().setValue("recent.keywords", recentKeywordsAsJSONString);
    }

    public static void saveStore() throws IOException {
        if (TestCasePreferenceDefaultValueInitializer.getStore().needsSaving()) {
            TestCasePreferenceDefaultValueInitializer.getStore().save();
        }
    }

    public static RecentObjectStorage getRecentObjectStorage(ProjectEntity project) {
        RecentObjectStorage recentObjectStorage = TestCasePreferenceDefaultValueInitializer.getRecentObjectStorages().get(project.getId());
        if (recentObjectStorage == null) {
            recentObjectStorage = new RecentObjectStorage();
        }
        return recentObjectStorage;
    }

    private static Map<String, RecentObjectStorage> getRecentObjectStorages() {
        String recentObjectStoragesAsJSONString = TestCasePreferenceDefaultValueInitializer.getStore().getString("recent.testObjects");
        Type mapType = new TypeToken<Map<String, RecentObjectStorage>>(){}.getType();
        return (Map)JsonUtil.fromJson((String)recentObjectStoragesAsJSONString, (Type)mapType);
    }

    public static void addRecentObject(ProjectEntity project, WebElementEntity testObject) {
        RecentObjectStorage recentObjectStorage = TestCasePreferenceDefaultValueInitializer.getRecentObjectStorage(project);
        recentObjectStorage.addRecentTestObject(testObject);
        Map<String, RecentObjectStorage> map = TestCasePreferenceDefaultValueInitializer.getRecentObjectStorages();
        map.put(project.getId(), recentObjectStorage);
        Type mapType = new TypeToken<Map<String, RecentObjectStorage>>(){}.getType();
        TestCasePreferenceDefaultValueInitializer.getStore().setValue("recent.testObjects", JsonUtil.toJson(map, (Type)mapType));
    }
}

