/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.preferences;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.preferences.ManualPreferenceValueInitializer;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ManualPreferencePage
extends PreferencePage {
    private Composite container;
    private Text txtMaximumLineWidth;
    private Button btnAllowLineWrapping;
    private Composite cpsWrappingLineWidth;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        Group grpLineWrappingSettings = new Group(this.container, 0);
        grpLineWrappingSettings.setText(StringConstants.PREF_MANUAL_GRP_LINE_WRAPPING);
        grpLineWrappingSettings.setLayout((Layout)new GridLayout(1, false));
        grpLineWrappingSettings.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAllowLineWrapping = new Button((Composite)grpLineWrappingSettings, 32);
        this.btnAllowLineWrapping.setText(StringConstants.PREF_MANUAL_BTN_ENABLE_LINE_WRAPPING);
        this.cpsWrappingLineWidth = new Composite((Composite)grpLineWrappingSettings, 0);
        GridData gdCpsWrappingLineWidth = new GridData(4, 4, true, false, 1, 1);
        gdCpsWrappingLineWidth.horizontalIndent = 10;
        this.cpsWrappingLineWidth.setLayoutData((Object)gdCpsWrappingLineWidth);
        GridLayout glCpsWrappingLineWidth = new GridLayout(2, false);
        glCpsWrappingLineWidth.marginHeight = 0;
        glCpsWrappingLineWidth.marginWidth = 0;
        this.cpsWrappingLineWidth.setLayout((Layout)glCpsWrappingLineWidth);
        Label lblNewLabel = new Label(this.cpsWrappingLineWidth, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNewLabel.setText(StringConstants.PREF_MANUAL_LBL_LINE_WIDTH);
        this.txtMaximumLineWidth = new Text(this.cpsWrappingLineWidth, 2048);
        GridData gdTxtMaximumLineWidth = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdTxtMaximumLineWidth.widthHint = 50;
        this.txtMaximumLineWidth.setLayoutData((Object)gdTxtMaximumLineWidth);
        this.registerControlModifyListeners();
        this.updateInput();
        return this.container;
    }

    private void registerControlModifyListeners() {
        this.btnAllowLineWrapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManualPreferencePage.this.enableWrappingLineComposite(ManualPreferencePage.this.btnAllowLineWrapping.getSelection());
            }
        });
        this.txtMaximumLineWidth.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldS = ManualPreferencePage.this.txtMaximumLineWidth.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (StringUtils.isEmpty((String)newS)) {
                    return;
                }
                e.doit = this.isPositive(newS);
            }

            private boolean isPositive(String s) {
                try {
                    return Integer.parseInt(s) >= 1;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
        this.txtMaximumLineWidth.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String lineWidth = ManualPreferencePage.this.txtMaximumLineWidth.getText();
                if (StringUtils.isEmpty((String)lineWidth)) {
                    ManualPreferencePage.this.txtMaximumLineWidth.setText(Integer.toString(ManualPreferenceValueInitializer.getMaximumLineWidth()));
                }
            }
        });
    }

    private void enableWrappingLineComposite(boolean enabled) {
        ControlUtils.recursiveSetEnabled((Control)this.cpsWrappingLineWidth, (boolean)enabled);
    }

    private void checkButtonAndNotifyToListener(Button btn, boolean selected) {
        btn.setSelection(selected);
        btn.notifyListeners(13, new Event());
    }

    private void updateInput() {
        this.checkButtonAndNotifyToListener(this.btnAllowLineWrapping, ManualPreferenceValueInitializer.isLineWrappingEnabled());
        this.txtMaximumLineWidth.setText(Integer.toString(ManualPreferenceValueInitializer.getMaximumLineWidth()));
    }

    protected void performDefaults() {
        if (this.isNotAbleToUpdate()) {
            return;
        }
        ManualPreferenceValueInitializer.defaultStore();
        this.updateInput();
    }

    public boolean performOk() {
        block3: {
            try {
                if (!this.isNotAbleToUpdate()) break block3;
                return true;
            }
            catch (IOException e) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PREF_MANUAL_MSG_UNABLE_TO_UPDATE, (String)e.getMessage());
                LoggerSingleton.logError((Throwable)e);
                return false;
            }
        }
        ManualPreferenceValueInitializer.enableLineWrapping(this.btnAllowLineWrapping.getSelection());
        ManualPreferenceValueInitializer.setMaximumLineWidth(Integer.valueOf(this.txtMaximumLineWidth.getText()));
        ManualPreferenceValueInitializer.updateStore();
        return true;
    }

    private boolean isNotAbleToUpdate() {
        return this.container == null || this.container.isDisposed();
    }
}

