/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.variable.VariableEntityWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TestCaseVariableEditorPart
extends CPart
implements SavableCompositePart {
    MirrorEditor mirrorEditor;
    Composite composite;
    private TestCaseCompositePart parentTestCaseCompositePart;
    String contentScript = "";
    boolean contentChanged = false;
    private List<VariableEntity> variables;
    @Inject
    private EPartService partService;
    MPart mpart;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        this.variables = new ArrayList<VariableEntity>();
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof TestCaseCompositePart) {
            this.parentTestCaseCompositePart = (TestCaseCompositePart)compositePart.getObject();
        }
        this.initialize(mpart, this.partService);
        this.createComposite(parent);
    }

    private void createComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.mirrorEditor = new MirrorEditor(this.composite, 0);
        this.mirrorEditor.setEditable(true);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                TestCaseVariableEditorPart.this.mirrorEditor.changeMode(TextContentType.XML.getText());
            }
        });
        this.mirrorEditor.addListener(24, event -> {
            if (!this.contentChanged) {
                this.contentChanged = true;
            } else {
                this.setDirty(true);
            }
        });
    }

    public void setDirty(boolean isDirty) {
        this.mpart.setDirty(true);
        this.parentTestCaseCompositePart.getChildTestCasePart().getTreeTableInput().reloadTestCaseVariables(this.getVariables());
        this.parentTestCaseCompositePart.updateDirty();
    }

    public VariableEntity[] getVariables() {
        if (this.variables == null) {
            return new VariableEntity[0];
        }
        return this.variables.toArray(new VariableEntity[this.variables.size()]);
    }

    public void setScriptContentFrom(VariableEntityWrapper entityWrapper) throws Exception {
        String incomingContentScript = this.getScriptContentFromVariableEntityWrapper(entityWrapper);
        if (!this.contentScript.equals(incomingContentScript)) {
            this.mirrorEditor.setText(incomingContentScript);
            if (!this.contentScript.equals("")) {
                this.contentChanged = true;
            }
            this.contentScript = incomingContentScript;
        }
    }

    public String getScriptContentFromVariableEntityWrapper(VariableEntityWrapper entityWrapper) throws Exception {
        String content = "";
        if (entityWrapper != null && entityWrapper.getVariables() != null && entityWrapper.getVariables().size() != 0) {
            List incomingVariablesList = entityWrapper.getVariables();
            VariableEntityWrapper variableEntityWrapper = new VariableEntityWrapper();
            variableEntityWrapper.setVariables(incomingVariablesList);
            content = GlobalVariableController.toXmlString((Object)variableEntityWrapper);
        }
        return content;
    }

    public String getScriptContent() {
        return this.mirrorEditor.getText();
    }

    public MPart getMPart() {
        return this.mpart;
    }

    @Persist
    public void save() {
    }

    @PreDestroy
    public void dispose() {
        super.dispose();
        this.partService.hidePart(this.mpart);
    }

    public MirrorEditor getEditor() {
        return this.mirrorEditor;
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> res = new ArrayList<MPart>();
        res.add(this.getMPart());
        return res;
    }

    public boolean isDirty() {
        return this.parentTestCaseCompositePart.isDirty();
    }
}

