/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.testcase.integration.TestCaseIntegrationFactory;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.integration.AbstractTestCaseIntegrationView;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TestCaseIntegrationPart {
    private ToolBar toolBar;
    private Composite container;
    private MPart mpart;
    private TestCaseCompositePart parentTestCaseCompositePart;
    private String documentationUrl;
    private Map<String, AbstractTestCaseIntegrationView> integrationCompositeMap;
    private Map<String, IntegratedEntity> editingIntegratedEntities = new HashMap<String, IntegratedEntity>();

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof TestCaseCompositePart) {
            this.parentTestCaseCompositePart = (TestCaseCompositePart)compositePart.getObject();
        }
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gl_mainComposite = new GridLayout(2, false);
        gl_mainComposite.horizontalSpacing = 20;
        mainComposite.setLayout((Layout)gl_mainComposite);
        Composite toolBarComposite = new Composite(mainComposite, 0);
        toolBarComposite.setLayout((Layout)new GridLayout(1, false));
        toolBarComposite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.toolBar = new ToolBar(toolBarComposite, 0x800200);
        this.toolBar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.container = new Composite(mainComposite, 0);
        this.container.setLayout((Layout)new FillLayout(256));
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public MPart getMPart() {
        return this.mpart;
    }

    public void setDirty(boolean dirty) {
        this.mpart.setDirty(true);
        this.parentTestCaseCompositePart.updateDirty();
    }

    public void reloadInput() {
    }

    public void loadInput() {
        this.clearToolbar();
        this.integrationCompositeMap = new HashMap<String, AbstractTestCaseIntegrationView>();
        TestCaseIntegrationFactory.getInstance().getSortedViewBuilders().forEach(builderEntry -> {
            ToolItem item = new ToolItem(this.toolBar, 32);
            item.setText(builderEntry.getName());
            this.integrationCompositeMap.put(builderEntry.getName(), builderEntry.getIntegrationView(this.parentTestCaseCompositePart.getTestCase(), this.mpart, this.parentTestCaseCompositePart));
        });
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem toolItem = (ToolItem)e.getSource();
                    if (toolItem.getSelection()) {
                        TestCaseIntegrationPart.this.changeContainer(toolItem.getText());
                    } else {
                        TestCaseIntegrationPart.this.clearContainer();
                    }
                }
            });
            ++n2;
        }
        if (this.toolBar.getItems().length > 0) {
            this.toolBar.getItems()[0].setSelection(true);
            this.changeContainer(this.toolBar.getItems()[0].getText());
        }
    }

    private void clearContainer() {
        while (this.container.getChildren().length > 0) {
            this.container.getChildren()[0].dispose();
        }
    }

    private void clearToolbar() {
        while (this.toolBar.getItems().length > 0) {
            this.toolBar.getItems()[0].dispose();
        }
    }

    private void changeContainer(String key) {
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (!key.equals(item.getText())) {
                item.setSelection(false);
            }
            ++n2;
        }
        this.clearContainer();
        this.integrationCompositeMap.get(key).createContainer(this.container);
        AbstractTestCaseIntegrationView integrationView = this.integrationCompositeMap.get(key);
        this.documentationUrl = integrationView.hasDocumentation() ? integrationView.getDocumentationUrl() : "";
        this.container.layout(true, true);
    }

    public boolean isParentDirty() {
        return this.parentTestCaseCompositePart.getDirty().isDirty();
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public Map<String, IntegratedEntity> getEditingIntegrated() {
        this.integrationCompositeMap.entrySet().stream().forEach(entry -> {
            if (((AbstractTestCaseIntegrationView)entry.getValue()).needsSaving()) {
                this.editingIntegratedEntities.put((String)entry.getKey(), ((AbstractTestCaseIntegrationView)entry.getValue()).getEditingIntegrated());
            }
        });
        return this.editingIntegratedEntities;
    }

    public void onSaveSuccess(TestCaseEntity testCase) {
        this.integrationCompositeMap.entrySet().stream().forEach(entry -> ((AbstractTestCaseIntegrationView)entry.getValue()).onSaveSuccess(testCase));
    }

    public void onSaveFailure(Exception e) {
        this.integrationCompositeMap.entrySet().stream().forEach(entry -> ((AbstractTestCaseIntegrationView)entry.getValue()).onSaveFailure(e));
    }
}

