/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testcase.components.KeywordTreeViewerToolTipSupport;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.constants.TreeTableMenuItemConstants;
import com.kms.katalon.composer.testcase.keywords.BuiltinKeywordFolderBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.CustomKeywordFolderBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserControlTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserFolderTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntityTransfer;
import com.kms.katalon.composer.testcase.providers.KeywordBrowserEntityViewerFilter;
import com.kms.katalon.composer.testcase.providers.KeywordTreeContentProvider;
import com.kms.katalon.composer.testcase.providers.KeywordTreeLabelProvider;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.custom.keyword.KeywordClass;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class KeywordBrowserPart
implements EventHandler {
    private static final String SEARCH_TEXT_DEFAULT_VALUE = "Enter text to search...";
    private TreeViewer treeViewer;
    private Text txtSearchInput;
    private KeywordTreeLabelProvider labelProvider;
    private KeywordBrowserEntityViewerFilter viewerFilter;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        this.createControls(parent);
        this.registerListerners();
        this.hookDoubleClickEvent();
        this.hookDragEvent();
        this.loadTreeData();
    }

    private void registerListerners() {
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("KEYWORD_BROWSER/REFRESH", (EventHandler)this);
    }

    private void hookDoubleClickEvent() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() == null) {
                    return;
                }
                Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement == null || !(selectedElement instanceof KeywordBrowserFolderTreeEntity)) {
                    return;
                }
                KeywordTreeContentProvider contentProvider = (KeywordTreeContentProvider)KeywordBrowserPart.this.treeViewer.getContentProvider();
                if (contentProvider.hasChildren(selectedElement)) {
                    KeywordBrowserPart.this.treeViewer.setExpandedState(selectedElement, !KeywordBrowserPart.this.treeViewer.getExpandedState(selectedElement));
                }
            }
        });
    }

    private void hookDragEvent() {
        int operations = 7;
        DragSource dragSource = new DragSource((Control)this.treeViewer.getTree(), operations);
        dragSource.setTransfer(new Transfer[]{new KeywordBrowserTreeEntityTransfer()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                List treeEntities = KeywordBrowserPart.this.getKeywordTreeEntityFromTree();
                event.doit = treeEntities.size() > 0;
            }

            public void dragSetData(DragSourceEvent event) {
                List treeEntities = KeywordBrowserPart.this.getKeywordTreeEntityFromTree();
                if (treeEntities.size() > 0) {
                    event.data = treeEntities.toArray(new IKeywordBrowserTreeEntity[treeEntities.size()]);
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private List<IKeywordBrowserTreeEntity> getKeywordTreeEntityFromTree() {
        TreeItem[] selection = this.treeViewer.getTree().getSelection();
        ArrayList<IKeywordBrowserTreeEntity> treeEntities = new ArrayList<IKeywordBrowserTreeEntity>();
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof KeywordBrowserTreeEntity) {
                treeEntities.add((KeywordBrowserTreeEntity)item.getData());
            } else if (item.getData() instanceof KeywordBrowserControlTreeEntity) {
                treeEntities.add((KeywordBrowserControlTreeEntity)item.getData());
            }
            ++n2;
        }
        return treeEntities;
    }

    private void createControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite(parent, 2048);
        searchComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glSearchComposite = new GridLayout(1, false);
        glSearchComposite.verticalSpacing = 0;
        glSearchComposite.horizontalSpacing = 0;
        glSearchComposite.marginWidth = 0;
        glSearchComposite.marginHeight = 0;
        searchComposite.setLayout((Layout)glSearchComposite);
        GridData grSearchComposite = new GridData(768);
        grSearchComposite.heightHint = 24;
        searchComposite.setLayoutData((Object)grSearchComposite);
        this.txtSearchInput = new Text(searchComposite, 0);
        this.txtSearchInput.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.txtSearchInput.setMessage(SEARCH_TEXT_DEFAULT_VALUE);
        GridData gdTxtInput = new GridData(768);
        gdTxtInput.grabExcessVerticalSpace = true;
        gdTxtInput.verticalAlignment = 0x1000000;
        this.txtSearchInput.setLayoutData((Object)gdTxtInput);
        this.txtSearchInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeywordBrowserPart.this.filterKeywordTreeEntitiesBySearchedText();
            }
        });
        this.txtSearchInput.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    KeywordBrowserPart.this.filterKeywordTreeEntitiesBySearchedText();
                }
            }
        });
        this.treeViewer = new TreeViewer(parent, 2048);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new KeywordTreeContentProvider());
        this.labelProvider = new KeywordTreeLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewerFilter = new KeywordBrowserEntityViewerFilter();
        this.treeViewer.addFilter((ViewerFilter)this.viewerFilter);
        KeywordTreeViewerToolTipSupport.enableFor(this.treeViewer);
    }

    protected void filterKeywordTreeEntitiesBySearchedText() {
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        final String searchString = this.txtSearchInput.getText();
        while (this.treeViewer.isBusy()) {
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getTree().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        try {
                            if (!searchString.equals(KeywordBrowserPart.this.txtSearchInput.getText()) || KeywordBrowserPart.this.treeViewer.getInput() == null) break block6;
                            KeywordBrowserPart.this.treeViewer.getTree().setRedraw(false);
                            KeywordBrowserPart.this.labelProvider.setSearchString(searchString);
                            KeywordBrowserPart.this.viewerFilter.setSearchString(searchString);
                            KeywordBrowserPart.this.treeViewer.refresh(true);
                            if (searchString != null && !searchString.isEmpty()) {
                                KeywordBrowserPart.this.treeViewer.expandAll();
                                break block6;
                            }
                            KeywordBrowserPart.this.treeViewer.collapseAll();
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                            KeywordBrowserPart.this.treeViewer.getTree().setRedraw(true);
                        }
                    }
                    finally {
                        KeywordBrowserPart.this.treeViewer.getTree().setRedraw(true);
                    }
                }
            }
        });
    }

    protected void loadTreeData() {
        KeywordBrowserFolderTreeEntity builtinKeywordRootFolder = KeywordBrowserPart.loadBuiltinKeywordFolderTreeEntity();
        CustomKeywordFolderBrowserTreeEntity customKeywordRootFolder = new CustomKeywordFolderBrowserTreeEntity(null);
        ArrayList<KeywordBrowserFolderTreeEntity> keywordTreeEntities = new ArrayList<KeywordBrowserFolderTreeEntity>();
        keywordTreeEntities.add(builtinKeywordRootFolder);
        keywordTreeEntities.add(customKeywordRootFolder);
        keywordTreeEntities.add(KeywordBrowserPart.loadControlKeywordFolderTreeEntity());
        this.treeViewer.setInput(keywordTreeEntities);
        this.treeViewer.refresh();
    }

    private static KeywordBrowserFolderTreeEntity loadBuiltinKeywordFolderTreeEntity() {
        ArrayList<IKeywordBrowserTreeEntity> keywordTreeEntities = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity builtinKeywordRootFolder = new KeywordBrowserFolderTreeEntity(StringConstants.KEYWORD_BROWSER_BUILTIN_KEYWORD_ROOT_TREE_ITEM_LABEL, null, keywordTreeEntities);
        for (KeywordClass builtInKeywordContributor : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            keywordTreeEntities.add(new BuiltinKeywordFolderBrowserTreeEntity(builtInKeywordContributor.getName(), builtInKeywordContributor.getSimpleName(), builtInKeywordContributor.getLabelName(), builtinKeywordRootFolder));
        }
        return builtinKeywordRootFolder;
    }

    private static KeywordBrowserFolderTreeEntity loadControlKeywordFolderTreeEntity() {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(StringConstants.KEYWORD_BROWSER_CONTROL_KEYWORD_ROOT_TREE_ITEM_LABEL, null, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(70, TreeTableMenuItemConstants.CALL_TEST_CASE_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadDecisionMakingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadLoopingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadBranchingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(KeywordBrowserPart.loadExceptionHandlingControlKeywordFolderTreeEntity(controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(6, TreeTableMenuItemConstants.BINARY_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(7, TreeTableMenuItemConstants.ASSERT_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(8, TreeTableMenuItemConstants.CALL_METHOD_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(72, TreeTableMenuItemConstants.METHOD_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadDecisionMakingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(TreeTableMenuItemConstants.DECISION_MAKING_STATEMENT_MENU_ITEM_LABEL, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(1, TreeTableMenuItemConstants.IF_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(2, TreeTableMenuItemConstants.ELSE_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(3, TreeTableMenuItemConstants.ELSE_IF_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(12, TreeTableMenuItemConstants.SWITCH_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(13, TreeTableMenuItemConstants.CASE_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(14, TreeTableMenuItemConstants.DEFAULT_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadLoopingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(TreeTableMenuItemConstants.LOOPING_STATEMENT_MENU_ITEM_LABEL, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(5, TreeTableMenuItemConstants.FOR_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(4, TreeTableMenuItemConstants.WHILE_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadBranchingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(TreeTableMenuItemConstants.BRANCHING_STATEMENT_MENU_ITEM_LABEL, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(9, TreeTableMenuItemConstants.BREAK_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(10, TreeTableMenuItemConstants.CONTINUE_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(11, TreeTableMenuItemConstants.RETURN_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    private static KeywordBrowserFolderTreeEntity loadExceptionHandlingControlKeywordFolderTreeEntity(KeywordBrowserFolderTreeEntity parentFolderTreeEntity) {
        ArrayList<IKeywordBrowserTreeEntity> controlKeywordFolders = new ArrayList<IKeywordBrowserTreeEntity>();
        KeywordBrowserFolderTreeEntity controlKeywordFolderTreeEntity = new KeywordBrowserFolderTreeEntity(TreeTableMenuItemConstants.EXCEPTION_HANDLING_STATEMENT_MENU_ITEM_LABEL, parentFolderTreeEntity, controlKeywordFolders);
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(15, TreeTableMenuItemConstants.TRY_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(16, TreeTableMenuItemConstants.CATCH_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(17, TreeTableMenuItemConstants.FINALLY_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        controlKeywordFolders.add(new KeywordBrowserControlTreeEntity(18, TreeTableMenuItemConstants.THROW_STATEMENT_MENU_ITEM_LABEL, controlKeywordFolderTreeEntity));
        return controlKeywordFolderTreeEntity;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("PROJECT/OPENED") || event.getTopic().equals("KEYWORD_BROWSER/REFRESH")) {
            this.loadTreeData();
        }
    }
}

