/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.model;

import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class InputParameterClass {
    private String fullName;
    private String simpleName;
    private boolean isArray;
    private boolean isEnum;
    private Object[] enumConstants;
    private InputParameterClass componentType;
    private List<InputParameterClass> actualTypeArguments;
    private int modifiers;

    public InputParameterClass(String fullName, String simpleName) {
        this.fullName = fullName;
        this.simpleName = simpleName;
    }

    public InputParameterClass(Type type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        }
        this.setFullName(clazz.getName());
        this.setSimpleName(clazz.getSimpleName());
        this.setModifiers(clazz.getModifiers());
        if (clazz.isArray() && clazz.getComponentType() != null) {
            this.setArray(true);
            Class<?> componentType = clazz.getComponentType();
            this.setComponentType(new InputParameterClass(componentType.getName(), componentType.getSimpleName()));
        }
        if (clazz.isEnum()) {
            this.setEnum(true);
            this.setEnumConstants(clazz.getEnumConstants());
        }
        ArrayList<InputParameterClass> typeList = new ArrayList<InputParameterClass>();
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type actualTypeArgument = typeArray[n2];
                if (actualTypeArgument instanceof Class) {
                    typeList.add(new InputParameterClass(actualTypeArgument));
                }
                ++n2;
            }
        } else {
            typeList.add(new InputParameterClass(Object.class.getName(), Object.class.getSimpleName()));
        }
        this.setActualTypeArguments(typeList);
    }

    public InputParameterClass(ClassNodeWrapper classNode) {
        this(classNode.getName(), classNode.getNameWithoutPackage());
        this.setModifiers(classNode.getModifiers());
        if (classNode.isArray()) {
            this.setArray(true);
            this.setComponentType(new InputParameterClass(classNode.getComponentType().getName(), classNode.getComponentType().getNameWithoutPackage()));
        }
        if (classNode.isEnum()) {
            this.setEnum(true);
            this.setEnumConstants(classNode.getTypeClass().getEnumConstants());
        }
        ArrayList<InputParameterClass> typeList = new ArrayList<InputParameterClass>();
        typeList.add(new InputParameterClass(Object.class.getName(), Object.class.getSimpleName()));
        typeList.add(new InputParameterClass(Object.class.getName(), Object.class.getSimpleName()));
        this.setActualTypeArguments(typeList);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Object[] getEnumConstants() {
        return this.enumConstants;
    }

    public void setEnumConstants(Object[] enumConstants) {
        this.enumConstants = enumConstants;
    }

    public InputParameterClass getComponentType() {
        return this.componentType;
    }

    public void setComponentType(InputParameterClass componentType) {
        this.componentType = componentType;
    }

    public List<InputParameterClass> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    public void setActualTypeArguments(List<InputParameterClass> actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getDisplayText() {
        if (!this.isArray()) {
            return this.getSimpleName();
        }
        if (this.getComponentType() != null) {
            return String.valueOf(this.getComponentType().getSimpleName()) + "[]";
        }
        return String.valueOf(Object.class.getSimpleName()) + "[]";
    }

    public Class<?> convertToClass() {
        return AstKeywordsInputUtil.loadType(this.fullName, null);
    }

    public boolean isFailureHandlingTypeClass() {
        return this.getFullName().equals(FailureHandling.class.getName()) || this.getSimpleName().equals(FailureHandling.class.getSimpleName());
    }

    public boolean isTestObjectTypeClass() {
        return AstEntityInputUtil.isClassChildOf(TestObject.class.getName(), this.getFullName());
    }
}

