/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.model;

import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArrayExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.CastExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputParameterClass;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.core.testcase.TestCase;
import com.kms.katalon.custom.keyword.KeywordParameter;
import java.util.ArrayList;
import org.codehaus.groovy.ast.ClassNode;

public class InputParameter {
    private Object value;
    private String paramName;
    private InputParameterClass paramType;

    public InputParameter(String paramName, InputParameterClass paramType) {
        this(paramName, paramType, null);
    }

    public InputParameter(String paramName, InputParameterClass paramType, Object value) {
        this.paramName = paramName;
        this.paramType = paramType;
        this.initValue(value);
    }

    public void initValue(Object valueObject) {
        if (valueObject instanceof CastExpressionWrapper) {
            this.value = ((CastExpressionWrapper)valueObject).getExpression();
        }
        if (valueObject instanceof ArrayExpressionWrapper) {
            this.value = new ArrayList<ExpressionWrapper>(((ArrayExpressionWrapper)valueObject).getExpressions());
        }
        this.value = valueObject;
    }

    public InputParameter(KeywordParameter keywordParam, Object value) {
        this.paramName = keywordParam.getName();
        this.paramType = new InputParameterClass(keywordParam.getType());
        this.initValue(value);
    }

    public InputParameter(Class<?> inputParamType, Object value) {
        this.paramName = inputParamType.getSimpleName();
        this.paramType = new InputParameterClass(inputParamType);
        this.initValue(value);
    }

    public InputParameter(ParameterWrapper parameter, Object value) {
        this.paramName = parameter.getName();
        this.paramType = new InputParameterClass(parameter.getType());
        this.initValue(value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public InputParameterClass getParamType() {
        return this.paramType;
    }

    public void setParamType(InputParameterClass paramType) {
        this.paramType = paramType;
    }

    public ExpressionWrapper getValueAsExpression() {
        InputParameterClass paramClass = this.getParamType();
        Object inputValue = this.getValue();
        if (inputValue instanceof ListExpressionWrapper && paramClass.isArray()) {
            return InputParameter.getValueAsCastExpression(paramClass, inputValue);
        }
        if (inputValue instanceof ExpressionWrapper) {
            return (ExpressionWrapper)inputValue;
        }
        return new ConstantExpressionWrapper();
    }

    private static ExpressionWrapper getValueAsCastExpression(InputParameterClass paramClass, Object inputValue) {
        ListExpressionWrapper listExpression = (ListExpressionWrapper)inputValue;
        ClassNode convertedTypeClass = new ClassNode(new ClassNode(paramClass.getComponentType().getFullName(), paramClass.getModifiers(), new ClassNode(Object.class)));
        return new CastExpressionWrapper(convertedTypeClass, listExpression, listExpression.getParent());
    }

    public boolean isEditable() {
        return this.getParamType() != null && this.getParamType().getFullName() != null && !AstEntityInputUtil.isClassChildOf(TestCase.class.getName(), this.getParamType().getFullName());
    }

    public boolean isTestObjectInputParameter() {
        return this.getParamType().isTestObjectTypeClass();
    }

    public boolean isFailureHandlingInputParameter() {
        return this.getParamType().isFailureHandlingTypeClass() && this.getValue() instanceof ExpressionWrapper && AstKeywordsInputUtil.isFailureHandlingExpression((ExpressionWrapper)this.getValue());
    }
}

