/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.keywords;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.keywords.IKeywordBrowserTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserFolderTreeEntity;
import com.kms.katalon.composer.testcase.keywords.KeywordBrowserTreeEntity;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.custom.parser.CustomKeywordParser;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;

public class CustomKeywordFolderBrowserTreeEntity
extends KeywordBrowserFolderTreeEntity {
    private static final String KEYWORD_OBJECT_ANNOTATION_METHOD = "keywordObject";
    private static final long serialVersionUID = 1L;
    private static final String TREE_ITEM_LABEL = StringConstants.KEYWORD_BROWSER_CUSTOM_KEYWORD_ROOT_TREE_ITEM_LABEL;
    private static final String CUSTOM_KEYWORD_CLASS_NAME = "CustomKeywords";

    public CustomKeywordFolderBrowserTreeEntity(IKeywordBrowserTreeEntity parent) {
        super(TREE_ITEM_LABEL, parent);
    }

    @Override
    public boolean hasChildren() {
        try {
            if (ProjectController.getInstance().getCurrentProject() != null && KeywordController.getInstance().getCustomKeywords(ProjectController.getInstance().getCurrentProject()).size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public Object[] getChildren() {
        try {
            return this.getKeywordByKeywordObject().toArray();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private List<IKeywordBrowserTreeEntity> getKeywordByKeywordObject() throws Exception {
        ArrayList<IKeywordBrowserTreeEntity> childTreeEntityList = new ArrayList<IKeywordBrowserTreeEntity>();
        if (ProjectController.getInstance().getCurrentProject() != null) {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            URLClassLoader classLoader = GroovyGuiUtil.getProjectClasLoader((ProjectEntity)projectEntity);
            IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)projectEntity);
            IFolder pluginFolder = GroovyUtil.getPluginsFolder((ProjectEntity)projectEntity);
            List allKeywordMethod = CustomKeywordParser.getInstance().parseAllCustomKeywordsIntoAst(classLoader, srcFolder);
            allKeywordMethod.addAll(CustomKeywordParser.getInstance().parsePluginKeywordsIntoAst(classLoader, pluginFolder));
            for (File customKeywordPlugin : ProjectController.getInstance().getCustomKeywordPlugins(projectEntity)) {
                allKeywordMethod.addAll(CustomKeywordParser.getInstance().parsePluginKeywordJarIntoAst(classLoader, customKeywordPlugin));
            }
            HashMap<String, ArrayList<Method>> methodActionMap = new HashMap<String, ArrayList<Method>>();
            for (Method method : allKeywordMethod) {
                String keywordObjectParameter = this.getKeywordObject(method);
                if (keywordObjectParameter == null) continue;
                ArrayList<Method> methodList = (ArrayList<Method>)methodActionMap.get(keywordObjectParameter);
                if (methodList == null) {
                    methodList = new ArrayList<Method>();
                    methodActionMap.put(keywordObjectParameter, methodList);
                }
                methodList.add(method);
            }
            for (Map.Entry pair : methodActionMap.entrySet()) {
                KeywordBrowserFolderTreeEntity keywordFolder = new KeywordBrowserFolderTreeEntity((String)pair.getKey(), this);
                for (Method method : (List)pair.getValue()) {
                    keywordFolder.children.add(new KeywordBrowserTreeEntity(CUSTOM_KEYWORD_CLASS_NAME, CUSTOM_KEYWORD_CLASS_NAME, "'" + method.getDeclaringClass().getName() + "." + method.getName() + "'", true, keywordFolder));
                }
                Collections.sort(keywordFolder.children, new Comparator<IKeywordBrowserTreeEntity>(){

                    @Override
                    public int compare(IKeywordBrowserTreeEntity keywordA, IKeywordBrowserTreeEntity keywordB) {
                        return keywordA.getName().compareToIgnoreCase(keywordB.getName());
                    }
                });
                childTreeEntityList.add(keywordFolder);
            }
        }
        return childTreeEntityList;
    }

    private String getKeywordObject(Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().getName().equals(Keyword.class.getName())) {
                return (String)annotation.annotationType().getMethod(KEYWORD_OBJECT_ANNOTATION_METHOD, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            ++n2;
        }
        return null;
    }
}

