/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestCaseHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestCaseTreeEntity) {
                    RenameTestCaseHandler.this.execute((TestCaseTreeEntity)object);
                }
            }
        });
    }

    private void execute(TestCaseTreeEntity testCaseTreeEntity) {
        block5: {
            try {
                if (!(testCaseTreeEntity.getObject() instanceof TestCaseEntity)) break block5;
                TestCaseEntity testCase = testCaseTreeEntity.getObject();
                List existingNames = FolderController.getInstance().getChildrenNames(testCase.getParentFolder());
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)testCaseTreeEntity, existingNames);
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                int code = wizardDialog.open();
                if (code != 0) break block5;
                String oldName = testCase.getName();
                String pk = testCase.getId();
                String oldIdForDisplay = testCase.getIdForDisplay();
                try {
                    if (renameWizard.getNewNameValue() != null && !renameWizard.getNewNameValue().isEmpty() && !renameWizard.getNewNameValue().equals(oldName)) {
                        GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)testCase);
                        testCase.setName(renameWizard.getNewNameValue());
                        TestCaseController.getInstance().updateTestCase(testCase);
                        String newIdForDisplay = testCase.getIdForDisplay();
                        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testCaseTreeEntity.getParent());
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, newIdForDisplay});
                        this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testCaseTreeEntity);
                        this.eventBroker.post("TESTCASE/UPDATED", (Object)new Object[]{pk, testCase});
                        this.partService.saveAll(false);
                    }
                }
                catch (Exception ex) {
                    testCase.setName(oldName);
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_CASE);
                    return;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

