/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.dialogs.NewTestCaseDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewTestCaseHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    @Inject
    private ESelectionService selectionService;
    private FolderTreeEntity testCaseTreeRoot;
    private static final String DEFAULT_NEW_TEST_CASE_NAME = StringConstants.HAND_NEW_TEST_CASE;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity parentTreeEntity = NewTestCaseHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                parentTreeEntity = this.testCaseTreeRoot;
            }
            NewTestCaseHandler.doCreateNewTestCase(parentTreeEntity, this.eventBroker);
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_CASE);
        }
    }

    public static TestCaseEntity doCreateNewTestCase(ITreeEntity parentTreeEntity, IEventBroker eventBroker) throws Exception {
        if (parentTreeEntity == null) {
            return null;
        }
        FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
        TestCaseController tcController = TestCaseController.getInstance();
        String suggestedName = tcController.getAvailableTestCaseName(parentFolderEntity, DEFAULT_NEW_TEST_CASE_NAME);
        Shell activeShell = Display.getCurrent().getActiveShell();
        NewTestCaseDialog dialog = new NewTestCaseDialog(activeShell, parentFolderEntity, suggestedName);
        if (dialog.open() != 0) {
            return null;
        }
        TestCaseEntity testCaseEntity = tcController.saveNewTestCase((TestCaseEntity)dialog.getEntity());
        if (testCaseEntity == null) {
            MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_CASE);
            return null;
        }
        Trackings.trackCreatingObject((String)"testCase");
        eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)new TestCaseTreeEntity(testCaseEntity, parentTreeEntity));
        eventBroker.send("TESTCASE/OPEN", (Object)testCaseEntity);
        return testCaseEntity;
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.TESTCASE) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof TestCaseEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Inject
    @Optional
    private void catchTestCaseTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            this.testCaseTreeRoot = NewTestCaseHandler.findTestCaseTreeRoot(treeEntities);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private static FolderTreeEntity findTestCaseTreeRoot(List<Object> treeEntities) throws Exception {
        for (Object o : treeEntities) {
            Object entityObject = ((ITreeEntity)o).getObject();
            if (!(entityObject instanceof FolderEntity)) {
                return null;
            }
            FolderEntity folder = (FolderEntity)entityObject;
            if (folder.getFolderType() != FolderEntity.FolderType.TESTCASE) continue;
            return (FolderTreeEntity)o;
        }
        return null;
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TESTCASE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }
}

