/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.CommentWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexLastStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ReturnStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class BlockStatementWrapper
extends StatementWrapper {
    protected List<StatementWrapper> statements = new ArrayList<StatementWrapper>();
    protected List<CommentWrapper> insideComments = new ArrayList<CommentWrapper>();

    public BlockStatementWrapper() {
        this(null);
    }

    public BlockStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
    }

    public BlockStatementWrapper(BlockStatementWrapper blockStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(blockStatementWrapper, parentNodeWrapper);
        for (StatementWrapper statement : blockStatementWrapper.getStatements()) {
            this.statements.add(statement.copy(this));
        }
        for (CommentWrapper insideComment : blockStatementWrapper.getInsideComments()) {
            this.insideComments.add(new CommentWrapper(insideComment, (ASTNodeWrapper)this));
        }
    }

    public BlockStatementWrapper(BlockStatement blockStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)blockStatement, parentNodeWrapper);
        this.statements.addAll(BlockStatementWrapper.getStatementNodeWrappersFromBlockStatement(blockStatement, this));
        if (this.statements.size() == 1 && this.statements.get(0) instanceof ReturnStatementWrapper && ((ReturnStatementWrapper)this.statements.get(0)).getExpression().getText().equals("null")) {
            this.statements.clear();
        }
    }

    public BlockStatementWrapper(List<StatementWrapper> statements, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.addStatements(statements);
    }

    public List<StatementWrapper> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public void addStatement(StatementWrapper statement) {
        if (statement == null) {
            return;
        }
        statement.setParent(this);
        this.statements.add(statement);
    }

    public void clearStaments() {
        this.statements = new ArrayList<StatementWrapper>();
    }

    public boolean addStatement(StatementWrapper statement, int index) {
        if (statement == null || index < 0 || index > this.statements.size()) {
            return false;
        }
        statement.setParent(this);
        this.statements.add(index, statement);
        return true;
    }

    public void addStatements(List<StatementWrapper> listOfStatements) {
        if (listOfStatements == null) {
            return;
        }
        for (StatementWrapper statement : listOfStatements) {
            if (statement == null) continue;
            statement.setParent(this);
            this.statements.add(statement);
        }
    }

    public boolean removeStatement(StatementWrapper statement) {
        return this.statements.remove(statement);
    }

    public boolean removeChild(int index) {
        if (index < 0 || index >= this.statements.size()) {
            return false;
        }
        this.statements.remove(index);
        return true;
    }

    public int indexOf(StatementWrapper childStatement) {
        if (childStatement == null) {
            return -1;
        }
        return this.statements.indexOf(childStatement);
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<StatementWrapper> astNodeWrappers = new ArrayList<StatementWrapper>();
        astNodeWrappers.addAll(this.statements);
        return astNodeWrappers;
    }

    public List<CommentWrapper> getInsideComments() {
        return this.insideComments;
    }

    @Override
    public void setInsideComments(List<CommentWrapper> commentWrapperList) {
        if (!this.statements.isEmpty()) {
            super.setInsideComments(commentWrapperList);
            return;
        }
        if (commentWrapperList == null || commentWrapperList.isEmpty()) {
            return;
        }
        this.insideComments.addAll(commentWrapperList);
    }

    @Override
    public BlockStatementWrapper clone() {
        return new BlockStatementWrapper(this, this.getParent());
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return astNode instanceof StatementWrapper && !(astNode instanceof ComplexChildStatementWrapper) && !(astNode instanceof ComplexLastStatementWrapper);
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        if (childObject instanceof StatementWrapper) {
            this.addStatement((StatementWrapper)childObject);
            return true;
        }
        return false;
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        if (childObject instanceof StatementWrapper) {
            return this.addStatement((StatementWrapper)childObject, index);
        }
        return false;
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        if (childObject instanceof StatementWrapper) {
            return this.removeStatement((StatementWrapper)childObject);
        }
        return false;
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        if (childObject instanceof StatementWrapper) {
            return this.indexOf((StatementWrapper)childObject);
        }
        return -1;
    }

    private static boolean isDescriptionStatement(Statement statement) {
        return statement instanceof ExpressionStatement && ((ExpressionStatement)statement).getExpression() instanceof ConstantExpression && ((ConstantExpression)((ExpressionStatement)statement).getExpression()).getValue() instanceof String;
    }

    private static String getDecriptionStatementValue(Statement statement) {
        String descriptionValue = (String)((ConstantExpression)((ExpressionStatement)statement).getExpression()).getValue();
        return GroovyWrapperParser.unescapeJavaString(descriptionValue);
    }

    public static List<StatementWrapper> getStatementNodeWrappersFromBlockStatement(BlockStatement blockStatement, ASTNodeWrapper parentNode) {
        ArrayList<StatementWrapper> statements = new ArrayList<StatementWrapper>();
        Statement pendingDescriptionStatement = null;
        List statementList = blockStatement.getStatements();
        int statementsNumber = statementList.size();
        int index = 0;
        while (index < statementsNumber) {
            Statement statement = (Statement)statementList.get(index);
            if (index < statementsNumber && BlockStatementWrapper.isDescriptionStatement(statement)) {
                if (pendingDescriptionStatement != null) {
                    statements.add(ASTNodeWrapHelper.getStatementNodeWrapperFromStatement(pendingDescriptionStatement, parentNode));
                }
                pendingDescriptionStatement = statement;
            } else {
                StatementWrapper statementWrapper = ASTNodeWrapHelper.getStatementNodeWrapperFromStatement(statement, parentNode);
                if (statementWrapper != null) {
                    if (pendingDescriptionStatement != null) {
                        statementWrapper.setDescription(BlockStatementWrapper.getDecriptionStatementValue(pendingDescriptionStatement));
                        if (StringUtils.equals((String)"not_run", (String)pendingDescriptionStatement.getStatementLabel())) {
                            statementWrapper.disable();
                        }
                        pendingDescriptionStatement = null;
                    }
                    statements.add(statementWrapper);
                }
            }
            ++index;
        }
        if (pendingDescriptionStatement != null) {
            statements.add(ASTNodeWrapHelper.getStatementNodeWrapperFromStatement(pendingDescriptionStatement, parentNode));
        }
        return statements;
    }

    @Override
    public boolean canHaveLabel() {
        return false;
    }
}

