/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.parser;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnotationNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.CommentWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.GenericsTypeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeCollection;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.TokenWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArrayExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BitwiseNegationExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.CastExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClassExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.DeclarationExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.EmptyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.FieldExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.GStringExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapEntryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodPointerExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PostfixExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PrefixExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.SpreadExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.SpreadMapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.StaticMethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.TernaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.TupleExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.UnaryMinusExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.UnaryPlusExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.AssertStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BreakStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CaseStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ContinueStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.DoWhileStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseIfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ForStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.IfStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ReturnStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SwitchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.SynchronizedStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.TryCatchStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.WhileStatementWrapper;
import com.kms.katalon.composer.testcase.preferences.ManualPreferenceValueInitializer;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;

public class GroovyWrapperParser {
    private static final String DEFAULT_INDENT_INCREASEMENT = "    ";
    public static final String[] GROOVY_IMPORTED_PACKAGES = new String[]{"java.io", "java.lang", "java.net", "java.util", "groovy.lang", "groovy.util"};
    public static final String[] GROOVY_IMPORTED_CLASSES = new String[]{"java.math.BigDecimal", "java.math.BigInteger"};
    private Stack<String> classNameStack = new Stack();
    private String currentIndent = "";
    private boolean readyToIndent = false;
    private StringBuilder stringBuilder;
    private boolean needLineBreak = false;

    public GroovyWrapperParser(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    public String getValue() {
        if (this.stringBuilder != null) {
            return this.stringBuilder.toString();
        }
        return "";
    }

    public void parse(Object object) {
        if (object instanceof ExpressionWrapper) {
            this.parseExpression((ExpressionWrapper)object);
        } else if (object instanceof StatementWrapper) {
            this.parseStatement((StatementWrapper)object);
        } else if (object instanceof ParameterWrapper) {
            this.parseParameter((ParameterWrapper)object);
        }
    }

    private void parseExpressionList(List<? extends ExpressionWrapper> expressions) {
        boolean first = true;
        for (ExpressionWrapper expressionWrapper : expressions) {
            this.checkWrapLongLine();
            ExpressionWrapper expression = expressionWrapper;
            if (!first) {
                this.print(", ");
            }
            first = false;
            this.parseExpression(expression);
        }
    }

    private void parseArgumentList(ArgumentListExpressionWrapper argumentListExpressionWrapper, boolean showTypes) {
        this.preParseASTNode(argumentListExpressionWrapper);
        int count = argumentListExpressionWrapper.getExpressions().size();
        for (ExpressionWrapper expression : argumentListExpressionWrapper.getExpressions()) {
            this.checkWrapLongLine();
            if (showTypes) {
                this.parseType(expression.getType());
                this.print(" ");
            }
            if (expression instanceof VariableExpressionWrapper) {
                this.parseVariable((VariableExpressionWrapper)expression, false);
            } else if (expression instanceof ConstantExpressionWrapper) {
                this.parseConstant((ConstantExpressionWrapper)expression, false);
            } else {
                this.parseExpression(expression);
            }
            if (--count <= 0) continue;
            this.print(", ");
        }
        this.postParseASTNode(argumentListExpressionWrapper);
    }

    private void parseArray(ArrayExpressionWrapper arrayExpressionWrapper) {
        this.preParseASTNode(arrayExpressionWrapper);
        this.print("new ");
        this.parseType(arrayExpressionWrapper.getElementType());
        this.print("[");
        String lastIndent = this.increaseIndent();
        this.parseExpressionList(arrayExpressionWrapper.getExpressions());
        this.resetIndent(lastIndent);
        this.print("]");
        this.postParseASTNode(arrayExpressionWrapper);
    }

    private void parseBoolean(BooleanExpressionWrapper booleanExpressionWrapper) {
        this.preParseASTNode(booleanExpressionWrapper);
        if (booleanExpressionWrapper.isReverse()) {
            this.print("!(");
            this.parseExpression(booleanExpressionWrapper.getExpression());
            this.print(")");
        } else {
            this.parseExpression(booleanExpressionWrapper.getExpression());
        }
        this.postParseASTNode(booleanExpressionWrapper);
    }

    private void parseBinary(BinaryExpressionWrapper binaryExpressionWrapper) {
        ExpressionWrapper rightExpression;
        this.preParseASTNode(binaryExpressionWrapper);
        binaryExpressionWrapper.getOperation().getToken().getType();
        ExpressionWrapper leftExpression = binaryExpressionWrapper.getLeftExpression();
        if (leftExpression instanceof BinaryExpressionWrapper) {
            this.print("(");
        }
        this.parseExpression(leftExpression);
        if (leftExpression instanceof BinaryExpressionWrapper) {
            this.print(")");
        }
        if ((rightExpression = binaryExpressionWrapper.getRightExpression()) != null) {
            TokenWrapper token = binaryExpressionWrapper.getOperation();
            this.preParseASTNode(token);
            if (token.getText().equals("[")) {
                this.print(token.getText());
            } else {
                this.print(" " + token.getText() + " ");
            }
            this.postParseASTNode(token);
            this.checkWrapLongLine();
            if (rightExpression instanceof BinaryExpressionWrapper) {
                this.print("(");
            }
            this.parseExpression(rightExpression);
            if (rightExpression instanceof BinaryExpressionWrapper) {
                this.print(")");
            }
            if (binaryExpressionWrapper.getOperation().getText().equals("[")) {
                this.print("]");
            }
        }
        this.postParseASTNode(binaryExpressionWrapper);
    }

    private void parseBitwise(BitwiseNegationExpressionWrapper bitwiseNegationExpressionWrapper) {
        this.preParseASTNode(bitwiseNegationExpressionWrapper);
        this.print("~(");
        this.parseExpression(bitwiseNegationExpressionWrapper.getExpression());
        this.print(") ");
        this.postParseASTNode(bitwiseNegationExpressionWrapper);
    }

    private void parseCast(CastExpressionWrapper castExpressionWrapper) {
        this.preParseASTNode(castExpressionWrapper);
        String lastIndent = this.increaseIndent();
        this.print("((");
        this.parseExpression(castExpressionWrapper.getExpression());
        this.print(") as ");
        this.parseType(castExpressionWrapper.getType());
        this.print(")");
        this.resetIndent(lastIndent);
        this.postParseASTNode(castExpressionWrapper);
    }

    private void parseClass(ClassExpressionWrapper classExpressionWrapper) {
        this.preParseASTNode(classExpressionWrapper);
        this.parseType(classExpressionWrapper.getType());
        this.postParseASTNode(classExpressionWrapper);
    }

    private void parseClosure(ClosureExpressionWrapper closureExpressionWrapper) {
        this.preParseASTNode(closureExpressionWrapper);
        this.print("{ ");
        if (closureExpressionWrapper.getParameters() != null && closureExpressionWrapper.getParameters().length > 0) {
            this.parseParameters(closureExpressionWrapper.getParameters());
            this.print(" ->");
        }
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(closureExpressionWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.postParseASTNode(closureExpressionWrapper);
    }

    private void parseConstant(ConstantExpressionWrapper constantExpressionWrapper, boolean unwrapQuotes) {
        this.preParseASTNode(constantExpressionWrapper);
        if (constantExpressionWrapper.getValue() instanceof String && !unwrapQuotes) {
            this.printString((String)constantExpressionWrapper.getValue());
        } else if (constantExpressionWrapper.getValue() instanceof Character) {
            this.print("'" + constantExpressionWrapper.getValue() + "'");
        } else {
            this.print(constantExpressionWrapper.getText());
        }
        this.postParseASTNode(constantExpressionWrapper);
    }

    private void printString(String string) {
        this.print("'" + GroovyWrapperParser.escapeJavaString(string) + "'");
    }

    public static String escapeJavaString(String string) {
        return string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("'", "\\'");
    }

    public static String unescapeJavaString(String string) {
        return string;
    }

    private void parseConstructorCall(ConstructorCallExpressionWrapper constructorCallExpressionWrapper) {
        this.preParseASTNode(constructorCallExpressionWrapper);
        if (constructorCallExpressionWrapper.isSuperCall()) {
            this.print("super");
        } else if (constructorCallExpressionWrapper.isThisCall()) {
            this.print("this ");
        } else {
            this.print("new ");
            this.parseType(constructorCallExpressionWrapper.getType());
        }
        this.print("(");
        this.parseExpression(constructorCallExpressionWrapper.getArguments());
        this.print(")");
        this.postParseASTNode(constructorCallExpressionWrapper);
    }

    private void parseClosureList(ClosureListExpressionWrapper closureListExpressionWrapper) {
        this.preParseASTNode(closureListExpressionWrapper);
        boolean first = true;
        for (ExpressionWrapper expression : closureListExpressionWrapper.getExpressions()) {
            if (!first) {
                this.print("; ");
            }
            first = false;
            this.parseExpression(expression);
        }
        this.postParseASTNode(closureListExpressionWrapper);
    }

    private void parseDeclaration(DeclarationExpressionWrapper declarationExpressionWrapper) {
        this.preParseASTNode(declarationExpressionWrapper);
        if (declarationExpressionWrapper.getRightExpression() instanceof EmptyExpressionWrapper) {
            declarationExpressionWrapper.setRightExpression(new ConstantExpressionWrapper(new ConstantExpression(null), (ASTNodeWrapper)declarationExpressionWrapper));
        }
        if (declarationExpressionWrapper.getLeftExpression() instanceof ArgumentListExpressionWrapper) {
            this.print("def ");
            this.parseArgumentList((ArgumentListExpressionWrapper)declarationExpressionWrapper.getLeftExpression(), true);
            this.print(declarationExpressionWrapper.getOperation().getText());
            this.parseExpression(declarationExpressionWrapper.getRightExpression());
            if (declarationExpressionWrapper.getOperation().getText().equals("[")) {
                this.print("]");
            }
        } else {
            if (declarationExpressionWrapper.getLeftExpression() instanceof VariableExpressionWrapper) {
                VariableExpressionWrapper variableExpressionWrapper = (VariableExpressionWrapper)declarationExpressionWrapper.getLeftExpression();
                this.parseType(variableExpressionWrapper.getOriginType());
                this.print(" " + variableExpressionWrapper.getName());
            } else {
                this.parseExpression(declarationExpressionWrapper.getLeftExpression());
            }
            if (declarationExpressionWrapper.getRightExpression() != null) {
                TokenWrapper token = declarationExpressionWrapper.getOperation();
                this.preParseASTNode(token);
                this.print(" " + token.getText() + " ");
                this.postParseASTNode(token);
                this.parseExpression(declarationExpressionWrapper.getRightExpression());
                if (declarationExpressionWrapper.getOperation().getText().equals("[")) {
                    this.print("]");
                }
            }
        }
        this.postParseASTNode(declarationExpressionWrapper);
    }

    private void parseFieldExpression(FieldExpressionWrapper fieldExpressionWrapper) {
        this.preParseASTNode(fieldExpressionWrapper);
        if (fieldExpressionWrapper.getField() != null) {
            this.print(fieldExpressionWrapper.getField().getName());
        }
        this.postParseASTNode(fieldExpressionWrapper);
    }

    private void parseGString(GStringExpressionWrapper gStringExpressionWrapper) {
        this.preParseASTNode(gStringExpressionWrapper);
        this.print(String.valueOf('\"') + gStringExpressionWrapper.getText() + '\"');
        this.postParseASTNode(gStringExpressionWrapper);
    }

    private void parseMap(MapExpressionWrapper mapExpressionWrapper) {
        this.preParseASTNode(mapExpressionWrapper);
        this.print("[");
        String lastIndent = this.increaseIndent();
        if (mapExpressionWrapper.getMapEntryExpressions().size() == 0) {
            this.print(":");
        } else {
            this.parseExpressionList(mapExpressionWrapper.getMapEntryExpressions());
        }
        this.resetIndent(lastIndent);
        this.print("]");
        this.postParseASTNode(mapExpressionWrapper);
    }

    private void parseMapEntry(MapEntryExpressionWrapper mapEntryExpressionWrapper) {
        this.preParseASTNode(mapEntryExpressionWrapper);
        if (mapEntryExpressionWrapper.getKeyExpression() instanceof SpreadMapExpressionWrapper) {
            this.print("*");
        } else {
            this.print("(");
            this.parseExpression(mapEntryExpressionWrapper.getKeyExpression());
            this.print(")");
        }
        this.print(" : ");
        this.parseExpression(mapEntryExpressionWrapper.getValueExpression());
        this.postParseASTNode(mapEntryExpressionWrapper);
    }

    private void parseMethodCall(MethodCallExpressionWrapper methodCallExpressionWrapper) {
        ExpressionWrapper method;
        this.preParseASTNode(methodCallExpressionWrapper);
        ExpressionWrapper objectExp = methodCallExpressionWrapper.getObjectExpression();
        boolean isCustomKeywordMethod = false;
        if (objectExp instanceof VariableExpressionWrapper) {
            String methodName;
            if (((VariableExpressionWrapper)objectExp).getName().equals("CustomKeywords") && methodCallExpressionWrapper.getMethod() instanceof ConstantExpressionWrapper && !(methodName = methodCallExpressionWrapper.getMethodAsString()).startsWith("'")) {
                isCustomKeywordMethod = true;
            }
            if (!((VariableExpressionWrapper)objectExp).getName().equals("this")) {
                this.parseVariable((VariableExpressionWrapper)objectExp, false);
            }
        } else {
            this.parseExpression(objectExp);
        }
        if (methodCallExpressionWrapper.isSpreadSafe()) {
            this.print("*");
        }
        if (methodCallExpressionWrapper.isSafe()) {
            this.print("?");
        }
        if (!(objectExp instanceof VariableExpressionWrapper) || !((VariableExpressionWrapper)objectExp).getName().equals("this")) {
            this.print(".");
        }
        if ((method = methodCallExpressionWrapper.getMethod()) instanceof ConstantExpressionWrapper) {
            this.preParseASTNode(method);
            if (isCustomKeywordMethod) {
                this.print("'");
            }
            this.print(String.valueOf(((ConstantExpressionWrapper)method).getValue()));
            if (isCustomKeywordMethod) {
                this.print("'");
            }
            this.print("(");
            String innerLastIndent = this.increaseIndent();
            this.postParseASTNode(method);
            this.parseExpression(methodCallExpressionWrapper.getArguments());
            this.print(")");
            this.postParseASTNode(methodCallExpressionWrapper);
            this.resetIndent(innerLastIndent);
        } else {
            this.parseExpression(method);
            this.print("(");
            String innerLastIndent = this.increaseIndent();
            this.parseExpression(methodCallExpressionWrapper.getArguments());
            this.print(")");
            this.postParseASTNode(methodCallExpressionWrapper);
            this.resetIndent(innerLastIndent);
        }
    }

    private void parseMethodPointer(MethodPointerExpressionWrapper methodPointerExpressionWrapper) {
        this.preParseASTNode(methodPointerExpressionWrapper);
        this.parseExpression(methodPointerExpressionWrapper.getExpression());
        this.print(".&");
        this.parseExpression(methodPointerExpressionWrapper.getMethodName());
        this.postParseASTNode(methodPointerExpressionWrapper);
    }

    private void parsePostfix(PostfixExpressionWrapper postfixExpressionWrapper) {
        this.preParseASTNode(postfixExpressionWrapper);
        TokenWrapper token = postfixExpressionWrapper.getOperation();
        if (postfixExpressionWrapper.getExpression() instanceof VariableExpressionWrapper) {
            this.parseExpression(postfixExpressionWrapper.getExpression());
        } else {
            this.print("(");
            this.parseExpression(postfixExpressionWrapper.getExpression());
            this.print(")");
        }
        this.print(token.getText());
        this.postParseASTNode(token);
        this.postParseASTNode(postfixExpressionWrapper);
    }

    private void parsePrefix(PrefixExpressionWrapper prefixExpressionWrapper) {
        this.preParseASTNode(prefixExpressionWrapper);
        TokenWrapper token = prefixExpressionWrapper.getOperation();
        this.preParseASTNode(token);
        this.print(token.getText());
        this.postParseASTNode(token);
        if (prefixExpressionWrapper.getExpression() instanceof VariableExpressionWrapper) {
            this.parseExpression(prefixExpressionWrapper.getExpression());
        } else {
            this.print("(");
            this.parseExpression(prefixExpressionWrapper.getExpression());
            this.print(")");
        }
        this.postParseASTNode(prefixExpressionWrapper);
    }

    private void parseProperty(PropertyExpressionWrapper propertyExpressionWrapper) {
        this.preParseASTNode(propertyExpressionWrapper);
        this.parseExpression(propertyExpressionWrapper.getObjectExpression());
        if (propertyExpressionWrapper.isSpreadSafe()) {
            this.print("*");
        }
        if (propertyExpressionWrapper.isSpreadSafe()) {
            this.print("*");
        } else if (propertyExpressionWrapper.isSafe()) {
            this.print("?");
        }
        this.print(".");
        if (propertyExpressionWrapper.getProperty() instanceof ConstantExpressionWrapper) {
            this.preParseASTNode(propertyExpressionWrapper.getProperty());
            this.print(propertyExpressionWrapper.getPropertyAsString());
            this.postParseASTNode(propertyExpressionWrapper.getProperty());
        } else {
            this.parseExpression(propertyExpressionWrapper.getProperty());
        }
        this.postParseASTNode(propertyExpressionWrapper);
    }

    private void parseRange(RangeExpressionWrapper rangeExpressionWrapper) {
        this.preParseASTNode(rangeExpressionWrapper);
        this.print("(");
        this.parseExpression(rangeExpressionWrapper.getFrom());
        this.print("..");
        this.parseExpression(rangeExpressionWrapper.getTo());
        this.print(")");
        this.postParseASTNode(rangeExpressionWrapper);
    }

    private void parseList(ListExpressionWrapper listExpressionWrapper) {
        this.preParseASTNode(listExpressionWrapper);
        this.print("[");
        String lastIndent = this.increaseIndent();
        this.parseExpressionList(listExpressionWrapper.getExpressions());
        this.resetIndent(lastIndent);
        this.print("]");
        this.postParseASTNode(listExpressionWrapper);
    }

    private void parseSpread(SpreadExpressionWrapper spreadExpressionWrapper) {
        this.preParseASTNode(spreadExpressionWrapper);
        this.print("*");
        this.parseExpression(spreadExpressionWrapper.getExpression());
        this.postParseASTNode(spreadExpressionWrapper);
    }

    private void parseSpreadMap(SpreadMapExpressionWrapper spreadMapExpressionWrapper) {
        this.preParseASTNode(spreadMapExpressionWrapper);
        this.print("*:");
        this.parseExpression(spreadMapExpressionWrapper.getExpression());
        this.postParseASTNode(spreadMapExpressionWrapper);
    }

    private void parseStaticMethodCall(StaticMethodCallExpressionWrapper staticMethodCallExpressionWrapper) {
        this.preParseASTNode(staticMethodCallExpressionWrapper);
        this.print(String.valueOf(staticMethodCallExpressionWrapper.getOwnerType().getName()) + "." + staticMethodCallExpressionWrapper.getMethod());
        this.print("(");
        this.parseExpression(staticMethodCallExpressionWrapper.getArguments());
        this.print(")");
        this.postParseASTNode(staticMethodCallExpressionWrapper);
    }

    private void parseTenary(TernaryExpressionWrapper ternaryExpressionWrapper) {
        this.preParseASTNode(ternaryExpressionWrapper);
        this.parseBoolean(ternaryExpressionWrapper.getBooleanExpression());
        this.print(" ? ");
        this.parseExpression(ternaryExpressionWrapper.getTrueExpression());
        this.print(" : ");
        this.parseExpression(ternaryExpressionWrapper.getFalseExpression());
        this.postParseASTNode(ternaryExpressionWrapper);
    }

    private void parseTuple(TupleExpressionWrapper tupleExpressionWrapper) {
        this.preParseASTNode(tupleExpressionWrapper);
        this.print("(");
        String lastIndent = this.increaseIndent();
        this.parseExpressionList(tupleExpressionWrapper.getExpressions());
        this.print(")");
        this.resetIndent(lastIndent);
        this.postParseASTNode(tupleExpressionWrapper);
    }

    private void parseUnaryMinus(UnaryMinusExpressionWrapper unaryMinusExpressionWrapper) {
        this.preParseASTNode(unaryMinusExpressionWrapper);
        this.print("-(");
        this.parseExpression(unaryMinusExpressionWrapper.getExpression());
        this.print(")");
        this.postParseASTNode(unaryMinusExpressionWrapper);
    }

    private void parseUnaryPlus(UnaryPlusExpressionWrapper unaryPlusExpressionWrapper) {
        this.preParseASTNode(unaryPlusExpressionWrapper);
        this.print("+(");
        this.parseExpression(unaryPlusExpressionWrapper.getExpression());
        this.print(")");
        this.postParseASTNode(unaryPlusExpressionWrapper);
    }

    private void parseVariable(VariableExpressionWrapper variableExpressionWrapper, boolean spacePad) {
        this.preParseASTNode(variableExpressionWrapper);
        if (spacePad) {
            this.print(String.valueOf(' ') + variableExpressionWrapper.getName() + ' ');
        } else {
            this.print(variableExpressionWrapper.getName());
        }
        this.postParseASTNode(variableExpressionWrapper);
    }

    private void parseExpression(ExpressionWrapper expression) {
        if (expression instanceof ArgumentListExpressionWrapper) {
            this.parseArgumentList((ArgumentListExpressionWrapper)expression, false);
        } else if (expression instanceof ArrayExpressionWrapper) {
            this.parseArray((ArrayExpressionWrapper)expression);
        } else if (expression instanceof BooleanExpressionWrapper) {
            this.parseBoolean((BooleanExpressionWrapper)expression);
        } else if (expression instanceof BitwiseNegationExpressionWrapper) {
            this.parseBitwise((BitwiseNegationExpressionWrapper)expression);
        } else if (expression instanceof CastExpressionWrapper) {
            this.parseCast((CastExpressionWrapper)expression);
        } else if (expression instanceof ClosureExpressionWrapper) {
            this.parseClosure((ClosureExpressionWrapper)expression);
        } else if (expression instanceof ConstructorCallExpressionWrapper) {
            this.parseConstructorCall((ConstructorCallExpressionWrapper)expression);
        } else if (expression instanceof DeclarationExpressionWrapper) {
            this.parseDeclaration((DeclarationExpressionWrapper)expression);
        } else if (expression instanceof BinaryExpressionWrapper) {
            this.parseBinary((BinaryExpressionWrapper)expression);
        } else if (expression instanceof FieldExpressionWrapper) {
            this.parseFieldExpression((FieldExpressionWrapper)expression);
        } else if (expression instanceof VariableExpressionWrapper) {
            this.parseVariable((VariableExpressionWrapper)expression, false);
        } else if (expression instanceof GStringExpressionWrapper) {
            this.parseGString((GStringExpressionWrapper)expression);
        } else if (expression instanceof MapExpressionWrapper) {
            this.parseMap((MapExpressionWrapper)expression);
        } else if (expression instanceof MapEntryExpressionWrapper) {
            this.parseMapEntry((MapEntryExpressionWrapper)expression);
        } else if (expression instanceof MethodCallExpressionWrapper) {
            this.parseMethodCall((MethodCallExpressionWrapper)expression);
        } else if (expression instanceof MethodPointerExpressionWrapper) {
            this.parseMethodPointer((MethodPointerExpressionWrapper)expression);
        } else if (expression instanceof ConstantExpressionWrapper) {
            this.parseConstant((ConstantExpressionWrapper)expression, false);
        } else if (expression instanceof PostfixExpressionWrapper) {
            this.parsePostfix((PostfixExpressionWrapper)expression);
        } else if (expression instanceof PrefixExpressionWrapper) {
            this.parsePrefix((PrefixExpressionWrapper)expression);
        } else if (expression instanceof RangeExpressionWrapper) {
            this.parseRange((RangeExpressionWrapper)expression);
        } else if (expression instanceof PropertyExpressionWrapper) {
            this.parseProperty((PropertyExpressionWrapper)expression);
        } else if (expression instanceof ClassExpressionWrapper) {
            this.parseClass((ClassExpressionWrapper)expression);
        } else if (expression instanceof ClosureListExpressionWrapper) {
            this.parseClosureList((ClosureListExpressionWrapper)expression);
        } else if (expression instanceof ListExpressionWrapper) {
            this.parseList((ListExpressionWrapper)expression);
        } else if (expression instanceof SpreadExpressionWrapper) {
            this.parseSpread((SpreadExpressionWrapper)expression);
        } else if (expression instanceof SpreadMapExpressionWrapper) {
            this.parseSpreadMap((SpreadMapExpressionWrapper)expression);
        } else if (expression instanceof StaticMethodCallExpressionWrapper) {
            this.parseStaticMethodCall((StaticMethodCallExpressionWrapper)expression);
        } else if (expression instanceof TernaryExpressionWrapper) {
            this.parseTenary((TernaryExpressionWrapper)expression);
        } else if (expression instanceof TupleExpressionWrapper) {
            this.parseTuple((TupleExpressionWrapper)expression);
        } else if (expression instanceof UnaryMinusExpressionWrapper) {
            this.parseUnaryMinus((UnaryMinusExpressionWrapper)expression);
        } else if (expression instanceof UnaryPlusExpressionWrapper) {
            this.parseUnaryPlus((UnaryPlusExpressionWrapper)expression);
        } else if (expression instanceof EmptyExpressionWrapper) {
            this.parseExpression((EmptyExpressionWrapper)expression);
        }
    }

    private void parseStatement(StatementWrapper statement) {
        if (statement instanceof ExpressionStatementWrapper) {
            this.parseExpressionStatement((ExpressionStatementWrapper)statement);
        } else if (statement instanceof ReturnStatementWrapper) {
            this.parseReturn((ReturnStatementWrapper)statement);
        } else if (statement instanceof AssertStatementWrapper) {
            this.parseAssert((AssertStatementWrapper)statement);
        } else if (statement instanceof BreakStatementWrapper) {
            this.parseBreak((BreakStatementWrapper)statement);
        } else if (statement instanceof SwitchStatementWrapper) {
            this.parseSwitch((SwitchStatementWrapper)statement);
        } else if (statement instanceof ThrowStatementWrapper) {
            this.parseThrow((ThrowStatementWrapper)statement);
        } else if (statement instanceof TryCatchStatementWrapper) {
            this.parseTryCatch((TryCatchStatementWrapper)statement);
        } else if (statement instanceof IfStatementWrapper) {
            this.parseIf((IfStatementWrapper)statement);
        } else if (statement instanceof ForStatementWrapper) {
            this.parseFor((ForStatementWrapper)statement);
        } else if (statement instanceof WhileStatementWrapper) {
            this.parseWhile((WhileStatementWrapper)statement);
        } else if (statement instanceof DoWhileStatementWrapper) {
            this.parseDoWhile((DoWhileStatementWrapper)statement);
        } else if (statement instanceof SynchronizedStatementWrapper) {
            this.parseSynchronized((SynchronizedStatementWrapper)statement);
        } else if (statement instanceof ContinueStatementWrapper) {
            this.parseContinue((ContinueStatementWrapper)statement);
        } else if (!(statement instanceof CaseStatementWrapper) && !(statement instanceof CatchStatementWrapper) && statement instanceof BlockStatementWrapper) {
            this.parseBlock((BlockStatementWrapper)statement);
        }
    }

    private void parseDescription(StatementWrapper statementWrapper) {
        if (statementWrapper.hasDescription()) {
            this.printString(statementWrapper.getDescription());
            this.printLineBreak();
        }
    }

    private void parseStatements(List<? extends StatementWrapper> statements) {
        int count = 0;
        for (StatementWrapper statementWrapper : statements) {
            this.parseStatement(statementWrapper);
            if (++count >= statements.size()) continue;
            this.printDoubleLineBreak();
        }
    }

    private void parseASTHasBlock(ASTHasBlock astHasBlock) {
        this.parseBlock(astHasBlock.getBlock());
    }

    private void parseBlock(BlockStatementWrapper blockStatementWrapper) {
        this.preParseASTNode(blockStatementWrapper);
        if (blockStatementWrapper.getStatements().isEmpty() && !blockStatementWrapper.getInsideComments().isEmpty()) {
            this.parseComments(blockStatementWrapper.getInsideComments());
        } else {
            this.parseStatements(blockStatementWrapper.getStatements());
        }
        this.postParseASTNode(blockStatementWrapper);
    }

    private void parseExpressionStatement(ExpressionStatementWrapper expressionStatementWrapper) {
        this.preParseASTNode(expressionStatementWrapper);
        this.parseExpression(expressionStatementWrapper.getExpression());
        this.postParseASTNode(expressionStatementWrapper);
    }

    private void parseReturn(ReturnStatementWrapper returnStatementWrapper) {
        this.preParseASTNode(returnStatementWrapper);
        this.print("return ");
        this.parseExpression(returnStatementWrapper.getExpression());
        this.postParseASTNode(returnStatementWrapper);
        this.printLineBreak();
    }

    private void parseAssert(AssertStatementWrapper assertStatementWrapper) {
        this.preParseASTNode(assertStatementWrapper);
        this.print("assert ");
        this.parseBoolean(assertStatementWrapper.getBooleanExpression());
        if (assertStatementWrapper.getMessageExpression() instanceof ConstantExpressionWrapper && ((ConstantExpressionWrapper)assertStatementWrapper.getMessageExpression()).getValue() != null) {
            this.print(" : ");
            this.parseExpression(assertStatementWrapper.getMessageExpression());
        }
        this.postParseASTNode(assertStatementWrapper);
    }

    private void parseBreak(BreakStatementWrapper breakStatementWrapper) {
        this.preParseASTNode(breakStatementWrapper);
        this.print("break");
        this.postParseASTNode(breakStatementWrapper);
        this.printLineBreak();
    }

    private void parseContinue(ContinueStatementWrapper continueStatementWrapper) {
        this.preParseASTNode(continueStatementWrapper);
        this.print("continue");
        this.postParseASTNode(continueStatementWrapper);
        this.printLineBreak();
    }

    private void parseSwitch(SwitchStatementWrapper switchStatementWrapper) {
        this.preParseASTNode(switchStatementWrapper);
        this.print("switch (");
        this.parseExpression(switchStatementWrapper.getExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        for (CaseStatementWrapper caseStatementWrapper : switchStatementWrapper.getComplexChildStatements()) {
            this.parseCase(caseStatementWrapper);
            this.printLineBreak();
        }
        if (switchStatementWrapper.hasLastStatement()) {
            this.preParseASTNode((ASTNodeWrapper)switchStatementWrapper.getLastStatement());
            this.print("default:");
            this.printLineBreak();
            String lastInnerIndent = this.increaseIndent();
            this.parseASTHasBlock((ASTHasBlock)switchStatementWrapper.getLastStatement());
            this.postParseASTNode((ASTNodeWrapper)switchStatementWrapper.getLastStatement());
            this.resetIndent(lastInnerIndent);
        }
        this.resetIndent(lastIndent);
        this.print("}");
        this.postParseASTNode(switchStatementWrapper);
        this.printLineBreak();
    }

    private void parseCase(CaseStatementWrapper caseStatementWrapper) {
        this.preParseASTNode(caseStatementWrapper);
        this.print("case ");
        this.parseExpression(caseStatementWrapper.getExpression());
        this.print(":");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(caseStatementWrapper);
        this.postParseASTNode(caseStatementWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
    }

    private void parseThrow(ThrowStatementWrapper throwStatementWrapper) {
        this.preParseASTNode(throwStatementWrapper);
        this.print("throw ");
        this.parseExpression(throwStatementWrapper.getExpression());
        this.postParseASTNode(throwStatementWrapper);
        this.printLineBreak();
    }

    private void parseTryCatch(TryCatchStatementWrapper tryCatchStatementWrapper) {
        this.preParseASTNode(tryCatchStatementWrapper);
        this.print("try {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(tryCatchStatementWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.printLineBreak();
        for (CatchStatementWrapper catchStatementWrapper : tryCatchStatementWrapper.getComplexChildStatements()) {
            this.parseCatch(catchStatementWrapper);
        }
        if (tryCatchStatementWrapper.hasLastStatement()) {
            this.preParseASTNode((ASTNodeWrapper)tryCatchStatementWrapper.getLastStatement());
            this.print("finally { ");
            this.printLineBreak();
            lastIndent = this.increaseIndent();
            this.parseASTHasBlock((ASTHasBlock)tryCatchStatementWrapper.getLastStatement());
            this.resetIndent(lastIndent);
            this.printLineBreak();
            this.print("}");
            this.postParseASTNode((ASTNodeWrapper)tryCatchStatementWrapper.getLastStatement());
            this.printLineBreak();
        }
        this.postParseASTNode(tryCatchStatementWrapper);
        this.printLineBreak();
    }

    private void parseCatch(CatchStatementWrapper catchStatementWrapper) {
        this.preParseASTNode(catchStatementWrapper);
        this.print("catch (");
        this.parseParameters(new ParameterWrapper[]{catchStatementWrapper.getVariable()});
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(catchStatementWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("} ");
        this.postParseASTNode(catchStatementWrapper);
        this.printLineBreak();
    }

    private void parseBooleanForStatement(BooleanExpressionWrapper booleanExpressionWrapper) {
        this.preParseASTNode(booleanExpressionWrapper);
        this.printBlankSpace();
        this.print("(");
        if (booleanExpressionWrapper.isReverse()) {
            this.print("!(");
            this.parseExpression(booleanExpressionWrapper.getExpression());
            this.print(")");
        } else {
            this.parseExpression(booleanExpressionWrapper.getExpression());
        }
        this.print(")");
        this.postParseASTNode(booleanExpressionWrapper);
    }

    private void parseIf(IfStatementWrapper ifStatementWrapper) {
        this.preParseASTNode(ifStatementWrapper);
        this.print("if");
        this.parseBooleanForStatement(ifStatementWrapper.getBooleanExpression());
        this.printBlankSpace();
        this.print("{");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(ifStatementWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.postParseASTNode(ifStatementWrapper);
        for (ElseIfStatementWrapper elseIfStatement : ifStatementWrapper.getComplexChildStatements()) {
            this.preParseASTNode(elseIfStatement);
            this.printBlankSpace();
            this.print("else if");
            this.parseBooleanForStatement(elseIfStatement.getBooleanExpression());
            this.printBlankSpace();
            this.print("{");
            this.printLineBreak();
            lastIndent = this.increaseIndent();
            this.parseASTHasBlock(elseIfStatement);
            this.resetIndent(lastIndent);
            this.printLineBreak();
            this.print("}");
            this.postParseASTNode(elseIfStatement);
        }
        if (ifStatementWrapper.hasLastStatement()) {
            this.preParseASTNode((ASTNodeWrapper)ifStatementWrapper.getLastStatement());
            this.printBlankSpace();
            this.print("else {");
            this.printLineBreak();
            lastIndent = this.increaseIndent();
            this.parseASTHasBlock((ASTHasBlock)ifStatementWrapper.getLastStatement());
            this.resetIndent(lastIndent);
            this.printLineBreak();
            this.print("}");
            this.postParseASTNode((ASTNodeWrapper)ifStatementWrapper.getLastStatement());
        }
        this.printLineBreak();
    }

    private void parseFor(ForStatementWrapper forStatementWrapper) {
        this.preParseASTNode(forStatementWrapper);
        this.print("for (");
        if (!(forStatementWrapper.getCollectionExpression() instanceof ClosureListExpressionWrapper) && !ForStatementWrapper.isForLoopDummy(forStatementWrapper.getVariable())) {
            this.parseParameters(new ParameterWrapper[]{forStatementWrapper.getVariable()});
            this.print(" : ");
        }
        this.parseExpression(forStatementWrapper.getCollectionExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(forStatementWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.postParseASTNode(forStatementWrapper);
        this.printLineBreak();
    }

    private void parseWhile(WhileStatementWrapper whileStatementWrapper) {
        this.preParseASTNode(whileStatementWrapper);
        this.print("while");
        this.parseBooleanForStatement(whileStatementWrapper.getBooleanExpression());
        this.printBlankSpace();
        this.print("{");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(whileStatementWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.postParseASTNode(whileStatementWrapper);
        this.printLineBreak();
    }

    private void parseDoWhile(DoWhileStatementWrapper doWhileStatementWrapper) {
        this.preParseASTNode(doWhileStatementWrapper);
        this.print("do {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(doWhileStatementWrapper);
        this.resetIndent(lastIndent);
        this.print("} while");
        this.parseBooleanForStatement(doWhileStatementWrapper.getBooleanExpression());
        this.postParseASTNode(doWhileStatementWrapper);
        this.printLineBreak();
    }

    private void parseSynchronized(SynchronizedStatementWrapper synchronizedStatementWrapper) {
        this.preParseASTNode(synchronizedStatementWrapper);
        this.print("synchronized (");
        this.parseExpression(synchronizedStatementWrapper.getExpression());
        this.print(") {");
        this.printLineBreak();
        String lastIndent = this.increaseIndent();
        this.parseExpression(synchronizedStatementWrapper.getExpression());
        this.resetIndent(lastIndent);
        this.print("}");
        this.postParseASTNode(synchronizedStatementWrapper);
        this.printLineBreak();
    }

    private void parseParameter(ParameterWrapper parameter) {
        this.preParseASTNode(parameter);
        for (AnnotationNodeWrapper annotation : parameter.getAnnotations()) {
            this.parseAnnotationNode(annotation);
            this.print(" ");
        }
        this.parseModifiers(parameter.getModifiers());
        this.parseType(parameter.getType());
        this.print(" " + parameter.getName());
        if (parameter.getInitialExpression() != null && !(parameter.getInitialExpression() instanceof EmptyExpressionWrapper)) {
            this.print(" = ");
            this.parseExpression(parameter.getInitialExpression());
        }
        this.postParseASTNode(parameter);
    }

    private void parseParameters(ParameterWrapper[] parameters) {
        boolean first = true;
        ParameterWrapper[] parameterWrapperArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterWrapper parameter = parameterWrapperArray[n2];
            if (!first) {
                this.print(", ");
            }
            first = false;
            this.parseParameter(parameter);
            ++n2;
        }
    }

    private void parseModifiers(int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            this.print("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            this.print("final ");
        }
        if (Modifier.isInterface(modifiers)) {
            this.print("interface ");
        }
        if (Modifier.isNative(modifiers)) {
            this.print("native ");
        }
        if (Modifier.isPrivate(modifiers)) {
            this.print("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            this.print("protected ");
        }
        Modifier.isPublic(modifiers);
        if (Modifier.isStatic(modifiers)) {
            this.print("static ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            this.print("synchronized ");
        }
        if (Modifier.isTransient(modifiers)) {
            this.print("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            this.print("volatile ");
        }
    }

    private void parseAnnotationNode(AnnotationNodeWrapper annotationNodeWrapper) {
        this.preParseASTNode(annotationNodeWrapper);
        this.print(String.valueOf('@') + annotationNodeWrapper.getClassNode().getName());
        if (annotationNodeWrapper.getMembers() != null && !annotationNodeWrapper.getMembers().isEmpty()) {
            this.print("(");
            boolean first = true;
            for (Map.Entry<String, ExpressionWrapper> pairs : annotationNodeWrapper.getMembers().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    this.print(", ");
                }
                this.print(String.valueOf(pairs.getKey()) + " = ");
                this.parseExpression(pairs.getValue());
            }
            this.print(")");
        }
        this.postParseASTNode(annotationNodeWrapper);
    }

    private void parseType(ClassNodeWrapper classNode) {
        String name = classNode.getName();
        if (name.startsWith("[")) {
            int numDimensions = 0;
            while (name.charAt(numDimensions) == '[') {
                ++numDimensions;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(classNode.getComponentType() == null ? Object.class.getSimpleName() : classNode.getComponentType().getNameWithoutPackage());
            int i = 0;
            while (i < numDimensions) {
                stringBuilder.append("[]");
                ++i;
            }
            this.print(stringBuilder.toString());
        } else if (classNode.getName().equals(Object.class.getName())) {
            this.print("def");
        } else {
            ImportNodeCollection importNodeCollection = classNode.getScriptClass().getImportNodeCollection();
            if (importNodeCollection != null && importNodeCollection.hasAlias(name)) {
                this.print(importNodeCollection.getBestMatchForAliasName(name));
            } else {
                boolean isImported = false;
                String[] stringArray = GROOVY_IMPORTED_CLASSES;
                int n = GROOVY_IMPORTED_CLASSES.length;
                int n2 = 0;
                while (n2 < n) {
                    String groovyImportedClass = stringArray[n2];
                    if (name.equals(groovyImportedClass)) {
                        isImported = true;
                        break;
                    }
                    ++n2;
                }
                stringArray = GROOVY_IMPORTED_PACKAGES;
                n = GROOVY_IMPORTED_PACKAGES.length;
                n2 = 0;
                while (n2 < n) {
                    String groovyImportedPackage = stringArray[n2];
                    if (name.startsWith(groovyImportedPackage)) {
                        isImported = true;
                        break;
                    }
                    ++n2;
                }
                if (isImported) {
                    this.print(classNode.getNameWithoutPackage());
                } else {
                    this.print(name);
                }
            }
        }
        this.parseGenericTypes(classNode.getGenericsTypes());
    }

    private void parseGenericTypes(GenericsTypeWrapper[] generics) {
        if (generics != null && generics.length > 0) {
            this.print("<");
            boolean first = true;
            GenericsTypeWrapper[] genericsTypeWrapperArray = generics;
            int n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsTypeWrapper generic = genericsTypeWrapperArray[n2];
                if (!first) {
                    this.print(", ");
                }
                first = false;
                this.print(generic.getName());
                if (generic.getUpperBounds() != null && generic.getUpperBounds().length > 0) {
                    this.print(" extends ");
                    boolean innerFirst = true;
                    ClassNodeWrapper[] classNodeWrapperArray = generic.getUpperBounds();
                    int n3 = classNodeWrapperArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNodeWrapper upperBound = classNodeWrapperArray[n4];
                        if (!innerFirst) {
                            this.print(" & ");
                        }
                        innerFirst = false;
                        this.parseType(upperBound);
                        ++n4;
                    }
                }
                if (generic.getLowerBound() != null) {
                    this.print(" super ");
                    this.parseType(generic.getLowerBound());
                }
                ++n2;
            }
            this.print(">");
        }
    }

    private void parseMethod(MethodNodeWrapper methodNodeWrapper) {
        this.preParseASTNode(methodNodeWrapper);
        for (AnnotationNodeWrapper annotationNodeWrapper : methodNodeWrapper.getAnnotations()) {
            this.parseAnnotationNode(annotationNodeWrapper);
            this.printLineBreak();
        }
        this.parseModifiers(methodNodeWrapper.getModifiers());
        if (methodNodeWrapper.getName().equals("<init>")) {
            this.print(String.valueOf(this.classNameStack.peek()) + "(");
            this.parseParameters(methodNodeWrapper.getParameters());
            this.print(") {");
            this.printLineBreak();
        } else if (methodNodeWrapper.getName().equals("<clinit>")) {
            this.print("{ ");
            this.printLineBreak();
        } else {
            this.parseType(methodNodeWrapper.getReturnType());
            this.print(" " + methodNodeWrapper.getName() + "(");
            this.parseParameters(methodNodeWrapper.getParameters());
            this.print(")");
            if (methodNodeWrapper.getExceptions() != null && methodNodeWrapper.getExceptions().length > 0) {
                boolean first = true;
                this.print(" throws ");
                ClassNodeWrapper[] classNodeWrapperArray = methodNodeWrapper.getExceptions();
                int n = classNodeWrapperArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNodeWrapper exceptionClassNode = classNodeWrapperArray[n2];
                    if (!first) {
                        this.print(", ");
                    }
                    first = false;
                    this.parseType(exceptionClassNode);
                    ++n2;
                }
            }
            this.print(" {");
            this.printLineBreak();
        }
        String lastIndent = this.increaseIndent();
        this.parseASTHasBlock(methodNodeWrapper);
        this.resetIndent(lastIndent);
        this.printLineBreak();
        this.print("}");
        this.printDoubleLineBreak();
        this.postParseASTNode(methodNodeWrapper);
    }

    private String increaseIndent() {
        String lastIndent = this.currentIndent;
        this.currentIndent = String.valueOf(this.currentIndent) + DEFAULT_INDENT_INCREASEMENT;
        return lastIndent;
    }

    private void resetIndent(String lastIndent) {
        this.currentIndent = lastIndent;
    }

    private void parseImport(ImportNodeWrapper importNodeWrapper) {
        if (importNodeWrapper == null) {
            return;
        }
        this.preParseASTNode(importNodeWrapper);
        for (AnnotationNodeWrapper annotationNodeWrapper : importNodeWrapper.getAnnotations()) {
            this.parseAnnotationNode(annotationNodeWrapper);
            this.printLineBreak();
        }
        this.print(importNodeWrapper.getText());
        this.postParseASTNode(importNodeWrapper);
        this.printLineBreak();
    }

    private void parseComments(List<CommentWrapper> comments) {
        for (CommentWrapper comment : comments) {
            this.printBlankSpace();
            this.print(comment.getComment());
            if (!comment.isMultiLine() || comment.getParent() instanceof StatementWrapper) {
                this.needLineBreak = true;
            }
            this.printBlankSpace();
        }
    }

    private void preParseASTNode(ASTNodeWrapper node) {
        if (!node.getPreceddingComments().isEmpty()) {
            this.parseComments(node.getPreceddingComments());
        }
        if (node instanceof StatementWrapper) {
            StatementWrapper statement = (StatementWrapper)node;
            this.parseDescription(statement);
            if (statement.canHaveLabel() && !StringUtils.isEmpty((String)statement.getLabel())) {
                this.print(String.valueOf(statement.getLabel()) + ": ");
            }
        }
    }

    private void postParseASTNode(ASTNodeWrapper node) {
        if (!node.getFollowingComments().isEmpty()) {
            this.parseComments(node.getFollowingComments());
        }
    }

    public static ScriptNodeWrapper parseGroovyScriptIntoNodeWrapper(String scriptContent) throws GroovyParsingException {
        if (scriptContent == null) {
            return null;
        }
        if ((scriptContent = scriptContent.trim()).isEmpty()) {
            return null;
        }
        try {
            List resultNodes = new AstBuilder().buildFromString(CompilePhase.CONVERSION, false, scriptContent);
            for (ASTNode resultNode : resultNodes) {
                if (!(resultNode instanceof ClassNode) || !((ClassNode)resultNode).isScript()) continue;
                return new ScriptNodeWrapper((ClassNode)resultNode);
            }
        }
        catch (CompilationFailedException e) {
            throw new GroovyParsingException(e);
        }
        return null;
    }

    public static StatementWrapper parseGroovyScriptAndGetFirstStatement(String scriptContent) {
        ScriptNodeWrapper script;
        try {
            script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(scriptContent);
        }
        catch (GroovyParsingException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
        if (script == null) {
            return null;
        }
        if (script.getBlock().getStatements().size() > 0) {
            return script.getBlock().getStatements().get(0);
        }
        return null;
    }

    public static ExpressionWrapper parseGroovyScriptAndGetFirstExpression(String scriptContent) {
        ScriptNodeWrapper script;
        try {
            script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(scriptContent);
        }
        catch (GroovyParsingException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
        if (script == null) {
            return null;
        }
        script.addDefaultImports();
        List<StatementWrapper> statementList = script.getBlock().getStatements();
        if (statementList.size() > 0 && statementList.get(0) instanceof ExpressionStatementWrapper) {
            return ((ExpressionStatementWrapper)statementList.get(0)).getExpression();
        }
        return null;
    }

    private void print(String string) {
        if (this.needLineBreak) {
            this.printLineBreak();
        }
        if (this.readyToIndent) {
            this.stringBuilder.append(this.currentIndent);
            this.readyToIndent = false;
            this.stringBuilder.trimToSize();
        }
        this.stringBuilder.append(string);
    }

    private void printLineBreak() {
        this.needLineBreak = false;
        if (!this.isEndWithNewLine()) {
            this.print("\n");
        }
        this.readyToIndent = true;
    }

    private void printBlankSpace() {
        if (!(this.stringBuilder.toString().endsWith(" ") || this.needLineBreak || this.isEndWithNewLine())) {
            this.print(" ");
        }
    }

    private boolean isEndWithNewLine() {
        return this.stringBuilder.toString().endsWith("\n");
    }

    private void printDoubleLineBreak() {
        this.needLineBreak = false;
        String output = this.stringBuilder.toString();
        if (!output.endsWith("\n\n")) {
            if (output.endsWith("\n")) {
                this.print("\n");
            } else {
                this.print("\n\n");
            }
        }
        this.readyToIndent = true;
    }

    private void checkWrapLongLine() {
        if (ManualPreferenceValueInitializer.isLineWrappingEnabled() && this.getLastLineLength() > ManualPreferenceValueInitializer.getMaximumLineWidth()) {
            this.needLineBreak = true;
        }
    }

    private int getLastLineLength() {
        String output = this.stringBuilder.toString();
        int lastLineBreakIndex = output.lastIndexOf("\n");
        if (lastLineBreakIndex == -1) {
            return 0;
        }
        String lastLine = output.substring(lastLineBreakIndex, output.length());
        return lastLine.length();
    }

    public void parseGroovyAstIntoScript(ScriptNodeWrapper script) {
        for (ImportNodeWrapper importNodeWrapper : script.getImports()) {
            this.parseImport(importNodeWrapper);
        }
        this.printDoubleLineBreak();
        this.parseASTHasBlock(script);
        this.printDoubleLineBreak();
        for (MethodNodeWrapper methodNodeWrapper : script.getMethods()) {
            if (methodNodeWrapper.getName() == "run") continue;
            this.parseMethod(methodNodeWrapper);
        }
    }
}

