/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;

public class PropertyExpressionWrapper
extends ExpressionWrapper {
    private static final String THIS_VARIABLE_NAME = "this";
    private ExpressionWrapper objectExpression;
    private ExpressionWrapper property;
    private boolean spreadSafe = false;
    private boolean safe = false;
    private boolean isStatic = false;

    public PropertyExpressionWrapper(String variableName, String propertyName) {
        this(variableName, propertyName, null);
    }

    public PropertyExpressionWrapper(String variableName, String propertyName, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.objectExpression = new VariableExpressionWrapper(variableName, (ASTNodeWrapper)this);
        this.property = new ConstantExpressionWrapper(propertyName, (ASTNodeWrapper)this);
    }

    public PropertyExpressionWrapper(String variableName, ASTNodeWrapper parentNodeWrapper) {
        this(variableName, null, parentNodeWrapper);
    }

    public PropertyExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        this(THIS_VARIABLE_NAME, null, parentNodeWrapper);
    }

    public PropertyExpressionWrapper() {
        this((ASTNodeWrapper)null);
    }

    public PropertyExpressionWrapper(PropertyExpression propertyExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)propertyExpression, parentNodeWrapper);
        this.objectExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(propertyExpression.getObjectExpression(), this);
        this.property = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(propertyExpression.getProperty(), this);
        this.spreadSafe = propertyExpression.isSpreadSafe();
        this.safe = propertyExpression.isSafe();
        this.isStatic = propertyExpression.isStatic();
    }

    public PropertyExpressionWrapper(PropertyExpressionWrapper propertyExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(propertyExpressionWrapper, parentNodeWrapper);
        this.copyPropertyProperties(propertyExpressionWrapper);
    }

    private void copyPropertyProperties(PropertyExpressionWrapper propertyExpressionWrapper) {
        this.objectExpression = propertyExpressionWrapper.getObjectExpression().copy(this);
        this.property = propertyExpressionWrapper.getProperty().copy(this);
        this.spreadSafe = propertyExpressionWrapper.isSpreadSafe();
        this.safe = propertyExpressionWrapper.isSafe();
        this.isStatic = propertyExpressionWrapper.isStatic();
    }

    public ExpressionWrapper getObjectExpression() {
        return this.objectExpression;
    }

    public String getObjectExpressionAsString() {
        if (!(this.objectExpression instanceof ConstantExpressionWrapper)) {
            return this.objectExpression.getText();
        }
        return String.valueOf(((ConstantExpressionWrapper)this.objectExpression).getValue());
    }

    public void setObjectExpression(ExpressionWrapper objectExpression) {
        if (objectExpression == null) {
            return;
        }
        objectExpression.setParent(this);
        this.objectExpression = objectExpression;
    }

    public boolean isObjectExpressionOfClass(Class<?> clazz) {
        String objectExpressionString = this.getObjectExpressionAsString();
        return objectExpressionString.equals(clazz.getName()) || objectExpressionString.equals(clazz.getSimpleName());
    }

    public ExpressionWrapper getProperty() {
        return this.property;
    }

    public void setProperty(ExpressionWrapper property) {
        if (property == null) {
            return;
        }
        property.setParent(this);
        this.property = property;
    }

    public void setProperty(String propertyString) {
        if (!(this.property instanceof ConstantExpressionWrapper)) {
            return;
        }
        ((ConstantExpressionWrapper)this.property).setValue(propertyString);
    }

    public boolean isSpreadSafe() {
        return this.spreadSafe;
    }

    public void setSpreadSafe(boolean spreadSafe) {
        this.spreadSafe = spreadSafe;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getObjectExpressionAsString());
        if (this.isSpreadSafe()) {
            stringBuilder.append("*");
        }
        if (this.isSpreadSafe()) {
            stringBuilder.append("*");
        } else if (this.isSafe()) {
            stringBuilder.append("?");
        }
        stringBuilder.append(".");
        stringBuilder.append(this.getPropertyAsString());
        return stringBuilder.toString();
    }

    public String getPropertyAsString() {
        if (!(this.property instanceof ConstantExpressionWrapper)) {
            return this.property.getText();
        }
        return String.valueOf(((ConstantExpressionWrapper)this.property).getValue());
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.objectExpression);
        astNodeWrappers.add(this.property);
        return astNodeWrappers;
    }

    @Override
    public PropertyExpressionWrapper clone() {
        return new PropertyExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof PropertyExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyPropertyProperties((PropertyExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getObjectExpression() && newChild instanceof ExpressionWrapper) {
            this.setObjectExpression((ExpressionWrapper)newChild);
            return true;
        }
        if (oldChild == this.getProperty() && newChild instanceof ExpressionWrapper) {
            this.setProperty((ExpressionWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }
}

