/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;

public class ConstructorCallExpressionWrapper
extends ExpressionWrapper {
    private ArgumentListExpressionWrapper arguments;

    public ConstructorCallExpressionWrapper(Class<?> type, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.type = new ClassNodeWrapper(type, (ASTNodeWrapper)this);
        this.arguments = new ArgumentListExpressionWrapper((ASTNodeWrapper)this);
    }

    public ConstructorCallExpressionWrapper(ConstructorCallExpression constructorCallExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)constructorCallExpression, parentNodeWrapper);
        this.type = ClassNodeWrapper.getClassWrapper(constructorCallExpression.getType(), this);
        this.arguments = constructorCallExpression.getArguments() instanceof ArgumentListExpression ? new ArgumentListExpressionWrapper((ArgumentListExpression)constructorCallExpression.getArguments(), (ASTNodeWrapper)this) : new ArgumentListExpressionWrapper((ASTNodeWrapper)this);
    }

    public ConstructorCallExpressionWrapper(ConstructorCallExpressionWrapper constructorCallExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(constructorCallExpressionWrapper, parentNodeWrapper);
        this.type = constructorCallExpressionWrapper.getType();
        this.arguments = new ArgumentListExpressionWrapper(constructorCallExpressionWrapper.getArguments(), (ASTNodeWrapper)this);
    }

    public ArgumentListExpressionWrapper getArguments() {
        return this.arguments;
    }

    @Override
    public String getText() {
        String text = null;
        text = this.isSuperCall() ? "super " : (this.isThisCall() ? "this " : "new " + this.getType().getName());
        return String.valueOf(text) + this.arguments.getText();
    }

    public boolean isSuperCall() {
        return this.getType().isSuper();
    }

    public boolean isSpecialCall() {
        return this.isThisCall() || this.isSuperCall();
    }

    public boolean isThisCall() {
        return this.getType().isThis();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        if (!this.isSpecialCall()) {
            astNodeWrappers.add(this.type);
        }
        astNodeWrappers.add(this.arguments);
        return astNodeWrappers;
    }

    @Override
    public ConstructorCallExpressionWrapper clone() {
        return new ConstructorCallExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getType() && newChild instanceof ClassNodeWrapper) {
            this.setType((ClassNodeWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }
}

