/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.TokenWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.syntax.Token;

public class BinaryExpressionWrapper
extends ExpressionWrapper {
    protected ExpressionWrapper leftExpression;
    protected ExpressionWrapper rightExpression;
    protected TokenWrapper operation;

    public BinaryExpressionWrapper() {
        this((ASTNodeWrapper)null);
    }

    public BinaryExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.leftExpression = new ConstantExpressionWrapper(0, (ASTNodeWrapper)this);
        this.operation = new TokenWrapper(Token.newSymbol((int)123, (int)-1, (int)-1), (ASTNodeWrapper)this);
        this.rightExpression = new ConstantExpressionWrapper(0, (ASTNodeWrapper)this);
    }

    public BinaryExpressionWrapper(String variableName, Token operation, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.leftExpression = new ConstantExpressionWrapper(0, (ASTNodeWrapper)this);
        this.operation = new TokenWrapper(Token.newSymbol((int)123, (int)-1, (int)-1), (ASTNodeWrapper)this);
        this.rightExpression = new ConstantExpressionWrapper(0, (ASTNodeWrapper)this);
    }

    public BinaryExpressionWrapper(BinaryExpressionWrapper binaryExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(binaryExpressionWrapper, parentNodeWrapper);
        this.copyBinaryProperties(binaryExpressionWrapper);
    }

    private void copyBinaryProperties(BinaryExpressionWrapper binaryExpressionWrapper) {
        this.leftExpression = binaryExpressionWrapper.getLeftExpression().copy(this);
        if (binaryExpressionWrapper.getRightExpression() != null) {
            this.rightExpression = binaryExpressionWrapper.getRightExpression().copy(this);
        }
        this.operation = new TokenWrapper(binaryExpressionWrapper.getOperation(), (ASTNodeWrapper)this);
    }

    public BinaryExpressionWrapper(BinaryExpression expression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)expression, parentNodeWrapper);
        this.leftExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getLeftExpression(), this);
        this.rightExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getRightExpression(), this);
        this.operation = new TokenWrapper(expression.getOperation(), (ASTNodeWrapper)this);
    }

    public ExpressionWrapper getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(ExpressionWrapper leftExpression) {
        if (leftExpression == null) {
            return;
        }
        leftExpression.setParent(this);
        this.leftExpression = leftExpression;
    }

    public ExpressionWrapper getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(ExpressionWrapper rightExpression) {
        if (rightExpression == null) {
            return;
        }
        rightExpression.setParent(this);
        this.rightExpression = rightExpression;
    }

    public TokenWrapper getOperation() {
        return this.operation;
    }

    public void setOperation(TokenWrapper operation) {
        if (operation == null) {
            return;
        }
        operation.setParent(this);
        this.operation = operation;
    }

    @Override
    public String getText() {
        if (this.rightExpression == null) {
            return this.leftExpression.getText();
        }
        if (this.operation.getType() == 30) {
            return String.valueOf(this.leftExpression.getText()) + "[" + this.rightExpression.getText() + "]";
        }
        return String.valueOf(this.leftExpression.getText()) + " " + this.operation.getText() + " " + this.rightExpression.getText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.leftExpression);
        astNodeWrappers.add(this.operation);
        astNodeWrappers.add(this.rightExpression);
        return astNodeWrappers;
    }

    @Override
    public BinaryExpressionWrapper clone() {
        return new BinaryExpressionWrapper(this, this.getParent());
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof BinaryExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyBinaryProperties((BinaryExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getLeftExpression() && newChild instanceof ExpressionWrapper) {
            this.setLeftExpression((ExpressionWrapper)newChild);
            return true;
        }
        if (oldChild == this.getRightExpression() && newChild instanceof ExpressionWrapper) {
            this.setRightExpression((ExpressionWrapper)newChild);
            return true;
        }
        if (oldChild == this.getOperation() && newChild instanceof TokenWrapper) {
            this.setOperation((TokenWrapper)newChild);
            return true;
        }
        return false;
    }
}

