/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.Expression;

public class ArrayExpressionWrapper
extends ExpressionWrapper {
    private List<ExpressionWrapper> expressions = new ArrayList<ExpressionWrapper>();
    private List<ExpressionWrapper> sizeExpression = new ArrayList<ExpressionWrapper>();
    private ClassNodeWrapper elementType;

    public ArrayExpressionWrapper(ArrayExpression arrayExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)arrayExpression, parentNodeWrapper);
        for (Expression expression : arrayExpression.getExpressions()) {
            this.expressions.add(ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression, this));
        }
        for (Expression expression : arrayExpression.getSizeExpression()) {
            this.sizeExpression.add(ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression, this));
        }
        this.elementType = ClassNodeWrapper.getClassWrapper(arrayExpression.getElementType(), this);
    }

    public ArrayExpressionWrapper(ArrayExpressionWrapper arrayExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(arrayExpressionWrapper, parentNodeWrapper);
        for (ExpressionWrapper expression : arrayExpressionWrapper.getExpressions()) {
            this.expressions.add(expression.copy(this));
        }
        for (ExpressionWrapper expression : arrayExpressionWrapper.getSizeExpression()) {
            this.sizeExpression.add(expression.copy(this));
        }
        this.elementType = new ClassNodeWrapper(arrayExpressionWrapper.getElementType(), (ASTNodeWrapper)this);
    }

    @Override
    public String getText() {
        StringBuilder value = new StringBuilder();
        value.append("[");
        value.append(StringUtils.join(Iterables.transform(this.expressions, (Function)new Function<ExpressionWrapper, String>(){

            public String apply(ExpressionWrapper expression) {
                return expression.getText();
            }
        }).iterator(), (String)", "));
        value.append("]");
        return value.toString();
    }

    public ClassNodeWrapper getElementType() {
        return this.elementType;
    }

    @Override
    public ClassNodeWrapper getType() {
        return this.getElementType();
    }

    public List<ExpressionWrapper> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public List<ExpressionWrapper> getSizeExpression() {
        return Collections.unmodifiableList(this.sizeExpression);
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ExpressionWrapper> astNodeWrappers = new ArrayList<ExpressionWrapper>();
        astNodeWrappers.addAll(this.expressions);
        astNodeWrappers.addAll(this.sizeExpression);
        return astNodeWrappers;
    }

    @Override
    public ArrayExpressionWrapper clone() {
        return new ArrayExpressionWrapper(this, this.parentNodeWrapper);
    }
}

