/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnonatedNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.Parameter;

public class ParameterWrapper
extends AnnonatedNodeWrapper {
    private int modifiers;
    private ClassNodeWrapper type = ClassNodeWrapper.getClassWrapper(ClassHelper.DYNAMIC_TYPE, this);
    private String name;
    private ExpressionWrapper initialExpression;

    public ParameterWrapper(Class<?> type, String name, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.type = new ClassNodeWrapper(type, (ASTNodeWrapper)this);
        this.name = name;
    }

    public ParameterWrapper(ParameterWrapper parameterWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(parameterWrapper, parentNodeWrapper);
        this.modifiers = parameterWrapper.getModifiers();
        this.type = new ClassNodeWrapper(parameterWrapper.getType(), (ASTNodeWrapper)this);
        this.name = parameterWrapper.getName();
        if (parameterWrapper.getInitialExpression() != null) {
            this.initialExpression = parameterWrapper.getInitialExpression().copy(this);
        }
    }

    public ParameterWrapper(Parameter parameter, ASTNodeWrapper parentNodeWrapper) {
        super((AnnotatedNode)parameter, parentNodeWrapper);
        this.name = parameter.getName();
        this.modifiers = parameter.getModifiers();
        this.type = ClassNodeWrapper.getClassWrapper(parameter.getType(), this);
        this.initialExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(parameter.getInitialExpression(), this);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ClassNodeWrapper getType() {
        return this.type;
    }

    public void setType(ClassNodeWrapper type) {
        if (type == null) {
            return;
        }
        type.setParent(this);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExpressionWrapper getInitialExpression() {
        return this.initialExpression;
    }

    @Override
    public String getText() {
        return this.name;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        if (this.initialExpression == null) {
            return Collections.emptyList();
        }
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.addAll(super.getAstChildren());
        astNodeWrappers.add(this.initialExpression);
        return astNodeWrappers;
    }

    @Override
    public ParameterWrapper clone() {
        return new ParameterWrapper(this, this.getParent());
    }
}

