/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.AnnonatedNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.FieldNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.GenericsTypeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeCollection;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.MethodNodeWrapper;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.checkpoint.Checkpoint;
import com.kms.katalon.core.checkpoint.CheckpointFactory;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCase;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.core.testobject.ObjectRepository;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.custom.keyword.KeywordClass;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;

public class ClassNodeWrapper
extends ASTNodeWrapper {
    public static final String RUN_METHOD_NAME = "run";
    protected Class<?> typeClass;
    protected GenericsTypeWrapper[] genericsTypes;
    protected String name;
    protected String nameWithoutPackage;
    protected boolean isThis;
    protected boolean isSuper;
    protected int modifiers;
    protected ClassNodeWrapper componentType = null;
    protected List<MethodNodeWrapper> methods = new ArrayList<MethodNodeWrapper>();
    protected List<FieldNodeWrapper> fields = new ArrayList<FieldNodeWrapper>();
    protected ImportNodeCollection importNodeCollection = new ImportNodeCollection();
    private static Map<ClassNode, ClassNodeWrapper> classCache = new HashMap<ClassNode, ClassNodeWrapper>();

    public ImportNodeCollection getImportNodeCollection() {
        return this.importNodeCollection;
    }

    public ClassNodeWrapper(Class<?> clazz, ASTNodeWrapper parentNodeWrapper) {
        this(ClassHelper.makeCached(clazz), parentNodeWrapper);
    }

    protected ClassNodeWrapper(ClassNode classNode, ASTNodeWrapper parentNodeWrapper) {
        super((ASTNode)classNode, parentNodeWrapper);
        this.copyProperties(classNode);
    }

    public ClassNodeWrapper(String className, String classNameWithoutPackage, ASTNodeWrapper parentNodeWrapper) {
        this(new ClassNode(className, 1, new ClassNode(Object.class)), parentNodeWrapper);
    }

    public ClassNodeWrapper(ClassNodeWrapper classNodeWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(classNodeWrapper, parentNodeWrapper);
        this.copyClassProperties(classNodeWrapper);
    }

    public static ClassNodeWrapper getClassWrapper(ClassNode classNode, ASTNodeWrapper parentNodeWrapper) {
        ClassNodeWrapper cachedClass = classCache.get(classNode);
        if (cachedClass != null) {
            return cachedClass;
        }
        cachedClass = new ClassNodeWrapper(classNode, parentNodeWrapper);
        classCache.put(classNode, cachedClass);
        return cachedClass;
    }

    protected void copyProperties(ClassNode classNode) {
        this.name = classNode.getName();
        this.nameWithoutPackage = classNode.getNameWithoutPackage();
        this.isSuper = classNode == ClassNode.SUPER;
        this.isThis = classNode == ClassNode.THIS;
        this.typeClass = Script.class;
        if (!classNode.isScript()) {
            this.typeClass = AstKeywordsInputUtil.loadType(classNode.getName(), null);
        }
        this.modifiers = classNode.getModifiers();
        if (classNode.getComponentType() != null) {
            this.componentType = new ClassNodeWrapper(classNode.getComponentType(), (ASTNodeWrapper)this);
        }
        if (classNode.getGenericsTypes() != null) {
            this.genericsTypes = new GenericsTypeWrapper[classNode.getGenericsTypes().length];
            int index = 0;
            while (index < classNode.getGenericsTypes().length) {
                this.genericsTypes[index] = new GenericsTypeWrapper(classNode.getGenericsTypes()[index], (ASTNodeWrapper)this);
                ++index;
            }
        }
        if (classNode.getModule() != null) {
            this.copyImports(classNode);
        }
        this.copyMethods(classNode);
        this.copyFields(classNode);
    }

    private void copyFields(ClassNode classNode) {
        this.fields.clear();
        for (FieldNode fieldNode : classNode.getFields()) {
            if (fieldNode.getLineNumber() < 0) continue;
            this.fields.add(new FieldNodeWrapper(fieldNode, (ASTNodeWrapper)this));
        }
    }

    private void copyMethods(ClassNode classNode) {
        this.methods.clear();
        for (MethodNode method : classNode.getMethods()) {
            if (method.getLineNumber() < 0 && !RUN_METHOD_NAME.equals(method.getName())) continue;
            this.methods.add(new MethodNodeWrapper(method, (ASTNodeWrapper)this));
        }
    }

    private void copyImports(ClassNode classNode) {
        this.importNodeCollection.clear();
        ModuleNode module = classNode.getModule();
        this.addImportNodeWrappers(module.getImports());
        this.addImportNodeWrappers(module.getStaticImports().values());
        this.addImportNodeWrappers(module.getStarImports());
        this.addImportNodeWrappers(module.getStaticStarImports().values());
        Collections.sort(this.getImports(), new Comparator<ImportNodeWrapper>(){

            @Override
            public int compare(ImportNodeWrapper import_1, ImportNodeWrapper import_2) {
                return Integer.compare(import_1.getLineNumber(), import_2.getLineNumber());
            }
        });
    }

    private void addImportNodeWrappers(Collection<ImportNode> importsList) {
        for (ImportNode importNode : importsList) {
            this.importNodeCollection.addImportNode(new ImportNodeWrapper(importNode, (ASTNodeWrapper)this));
        }
    }

    private void copyClassProperties(ClassNodeWrapper classNodeWrapper) {
        this.name = classNodeWrapper.getName();
        this.nameWithoutPackage = classNodeWrapper.getNameWithoutPackage();
        this.isSuper = classNodeWrapper.isSuper();
        this.isThis = classNodeWrapper.isThis();
        this.typeClass = classNodeWrapper.getTypeClass();
        this.modifiers = classNodeWrapper.getModifiers();
        if (classNodeWrapper.getComponentType() != null) {
            this.componentType = new ClassNodeWrapper(classNodeWrapper.getComponentType(), (ASTNodeWrapper)this);
        }
        if (classNodeWrapper.getGenericsTypes() != null) {
            this.genericsTypes = new GenericsTypeWrapper[classNodeWrapper.getGenericsTypes().length];
            int index = 0;
            while (index < classNodeWrapper.getGenericsTypes().length) {
                this.genericsTypes[index] = new GenericsTypeWrapper(classNodeWrapper.getGenericsTypes()[index], (ASTNodeWrapper)this);
                ++index;
            }
        }
        this.importNodeCollection.clear();
        for (ImportNodeWrapper importNode : classNodeWrapper.getImports()) {
            if (importNode.equals(this.parentNodeWrapper)) continue;
            this.importNodeCollection.addImportNode(new ImportNodeWrapper(importNode, (ASTNodeWrapper)this));
        }
        this.methods.clear();
        for (MethodNodeWrapper method : classNodeWrapper.getMethods()) {
            this.methods.add(new MethodNodeWrapper(method, (ASTNodeWrapper)this));
        }
    }

    @Override
    public String getText() {
        return this.getNameWithoutPackage();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<AnnonatedNodeWrapper> astNodeWrappers = new ArrayList<AnnonatedNodeWrapper>();
        astNodeWrappers.addAll(this.getImports());
        astNodeWrappers.addAll(this.fields);
        astNodeWrappers.addAll(this.methods);
        return astNodeWrappers;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutPackage() {
        return this.nameWithoutPackage;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public GenericsTypeWrapper[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public List<MethodNodeWrapper> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public List<String> getMethodNames() {
        ArrayList<String> methodNames = new ArrayList<String>();
        List<MethodNodeWrapper> methods = this.getMethods();
        for (MethodNodeWrapper method : methods) {
            methodNames.add(method.getName());
        }
        return methodNames;
    }

    public void addMethod(MethodNodeWrapper method) {
        if (method == null) {
            return;
        }
        method.setParent(this);
        this.methods.add(method);
    }

    public boolean addMethod(MethodNodeWrapper method, int index) {
        if (method == null || index < 0 || index > this.methods.size()) {
            return false;
        }
        method.setParent(this);
        this.methods.add(index, method);
        return true;
    }

    public boolean removeMethod(MethodNodeWrapper method) {
        return this.methods.remove(method);
    }

    public boolean removeMethod(int index) {
        if (index < 0 || index >= this.methods.size()) {
            return false;
        }
        this.methods.remove(index);
        return true;
    }

    public int indexOfMethod(MethodNodeWrapper methodNode) {
        if (methodNode == null) {
            return -1;
        }
        return this.methods.indexOf(methodNode);
    }

    public boolean setMethod(MethodNodeWrapper method, int index) {
        if (method == null || index < 0 || index > this.methods.size()) {
            return false;
        }
        method.setParent(this);
        this.methods.set(index, method);
        return true;
    }

    public List<FieldNodeWrapper> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void clearFields() {
        this.fields.clear();
    }

    public void addField(FieldNodeWrapper field) {
        if (field == null) {
            return;
        }
        field.setParent(this);
        this.fields.add(field);
    }

    public boolean addField(FieldNodeWrapper field, int index) {
        if (field == null || index < 0 || index > this.fields.size()) {
            return false;
        }
        field.setParent(this);
        this.fields.add(index, field);
        return true;
    }

    public boolean removeField(FieldNodeWrapper field) {
        return this.fields.remove(field);
    }

    public boolean removeField(int index) {
        if (index < 0 || index >= this.fields.size()) {
            return false;
        }
        this.fields.remove(index);
        return true;
    }

    public int indexOfField(FieldNodeWrapper field) {
        if (field == null) {
            return -1;
        }
        return this.fields.indexOf(field);
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ClassNodeWrapper getComponentType() {
        return this.componentType;
    }

    public List<ImportNodeWrapper> getImports() {
        return this.importNodeCollection.getImportNodes();
    }

    public void addImport(Class<?> classNeedImport) {
        this.importNodeCollection.addImportNode(new ImportNodeWrapper(classNeedImport, this, classNeedImport.getSimpleName()));
    }

    public void addImportKeywordClass(KeywordClass keywordClass) {
        ImportNodeWrapper wrapper = new ImportNodeWrapper(keywordClass.getType(), this, keywordClass.getAliasName());
        this.importNodeCollection.addImportNode(wrapper);
    }

    public void addImportStaticMethod(Class<?> classToImport, String methodName) {
        ImportNodeWrapper wrapper = new ImportNodeWrapper(classToImport, methodName, this, true);
        this.importNodeCollection.addImportNode(wrapper);
    }

    public void addDefaultImports() {
        for (KeywordClass keywordClass : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            this.addImportKeywordClass(keywordClass);
        }
        this.addImportStaticMethod(ObjectRepository.class, "findTestObject");
        this.addImportStaticMethod(TestDataFactory.class, "findTestData");
        this.addImportStaticMethod(TestCaseFactory.class, "findTestCase");
        this.addImportStaticMethod(CheckpointFactory.class, "findCheckpoint");
        this.addImport(FailureHandling.class);
        this.addImport(TestCase.class);
        this.addImport(TestData.class);
        this.addImport(TestObject.class);
        this.addImport(Checkpoint.class);
        this.addImport("internal", "GlobalVariable");
    }

    public void addImport(String packageName, String className) {
        this.importNodeCollection.addImportNode(new ImportNodeWrapper(String.valueOf(packageName) + "." + className, className, this));
    }

    public boolean isArray() {
        return this.componentType != null;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return astNode instanceof MethodNodeWrapper || astNode instanceof FieldNodeWrapper;
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject) {
        if (childObject instanceof MethodNodeWrapper) {
            this.addMethod((MethodNodeWrapper)childObject);
            return true;
        }
        if (childObject instanceof FieldNodeWrapper) {
            this.addField((FieldNodeWrapper)childObject);
            return true;
        }
        return false;
    }

    @Override
    public boolean addChild(ASTNodeWrapper childObject, int index) {
        if (childObject instanceof MethodNodeWrapper) {
            return this.addMethod((MethodNodeWrapper)childObject, index);
        }
        if (childObject instanceof FieldNodeWrapper) {
            return this.addField((FieldNodeWrapper)childObject, index);
        }
        return false;
    }

    @Override
    public boolean removeChild(ASTNodeWrapper childObject) {
        if (childObject instanceof MethodNodeWrapper) {
            return this.removeMethod((MethodNodeWrapper)childObject);
        }
        if (childObject instanceof FieldNodeWrapper) {
            return this.removeField((FieldNodeWrapper)childObject);
        }
        return false;
    }

    @Override
    public int indexOf(ASTNodeWrapper childObject) {
        if (childObject instanceof MethodNodeWrapper) {
            return this.indexOfMethod((MethodNodeWrapper)childObject);
        }
        if (childObject instanceof FieldNodeWrapper) {
            return this.indexOfField((FieldNodeWrapper)childObject);
        }
        return -1;
    }

    @Override
    public ClassNodeWrapper clone() {
        return new ClassNodeWrapper(this, this.getParent());
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof ClassNodeWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyClassProperties((ClassNodeWrapper)input);
        return true;
    }
}

