/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.CommentWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;

public abstract class ASTNodeWrapper {
    protected ASTNodeWrapper parentNodeWrapper;
    protected List<CommentWrapper> preceddingComments = new ArrayList<CommentWrapper>();
    protected List<CommentWrapper> followingComments;
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    protected int lastLineNumber = -1;
    protected int lastColumnNumber = -1;
    protected int start = 0;
    protected int end = 0;

    public ASTNodeWrapper(ASTNodeWrapper parentNodeWrapper) {
        this(new ASTNode(), parentNodeWrapper);
    }

    public ASTNodeWrapper(ASTNodeWrapper nodeWrapper, ASTNodeWrapper parentNodeWrapper) {
        this.parentNodeWrapper = parentNodeWrapper;
        this.copyProperties(nodeWrapper);
    }

    public ASTNodeWrapper(ASTNode node, ASTNodeWrapper parentNodeWrapper) {
        this.parentNodeWrapper = parentNodeWrapper;
        this.copyProperties(node);
    }

    public void copyProperties(ASTNodeWrapper nodeWrapper) {
        if (nodeWrapper == null) {
            return;
        }
        this.lineNumber = nodeWrapper.getLineNumber();
        this.columnNumber = nodeWrapper.getColumnNumber();
        this.lastLineNumber = nodeWrapper.getLastLineNumber();
        this.lastColumnNumber = nodeWrapper.getLastColumnNumber();
        this.start = nodeWrapper.getStart();
        this.end = nodeWrapper.getEnd();
        if (nodeWrapper.preceddingComments != null) {
            this.getPreceddingComments().addAll(nodeWrapper.getPreceddingComments());
        }
        if (nodeWrapper.followingComments != null) {
            this.getFollowingComments().addAll(nodeWrapper.getFollowingComments());
        }
    }

    protected void copyProperties(ASTNode node) {
        if (node == null) {
            return;
        }
        this.lineNumber = node.getLineNumber();
        this.columnNumber = node.getColumnNumber();
        this.lastLineNumber = node.getLastLineNumber();
        this.lastColumnNumber = node.getLastColumnNumber();
        this.start = node.getStart();
        this.end = node.getEnd();
    }

    public ASTNodeWrapper getParent() {
        return this.parentNodeWrapper;
    }

    public void setParent(ASTNodeWrapper parentNodeWrapper) {
        this.parentNodeWrapper = parentNodeWrapper;
    }

    public ScriptNodeWrapper getScriptClass() {
        ASTNodeWrapper candidate = this;
        while (candidate != null && candidate.getParent() != null) {
            candidate = candidate.getParent();
        }
        if (candidate instanceof ScriptNodeWrapper) {
            return (ScriptNodeWrapper)candidate;
        }
        return null;
    }

    public List<CommentWrapper> getPreceddingComments() {
        if (this.preceddingComments == null) {
            this.preceddingComments = new ArrayList<CommentWrapper>();
        }
        return this.preceddingComments;
    }

    public void setPreceddingComments(List<CommentWrapper> preceddingComments) {
        for (CommentWrapper commentWrapper : preceddingComments) {
            commentWrapper.setParent(this);
        }
        this.getPreceddingComments().addAll(preceddingComments);
    }

    public List<CommentWrapper> getFollowingComments() {
        if (this.followingComments == null) {
            this.followingComments = new ArrayList<CommentWrapper>();
        }
        return this.followingComments;
    }

    public void setFollowingComments(List<CommentWrapper> followingComments) {
        for (CommentWrapper commentWrapper : followingComments) {
            commentWrapper.setParent(this);
        }
        this.getFollowingComments().addAll(followingComments);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLastLineNumber() {
        return this.lastLineNumber;
    }

    public int getLastColumnNumber() {
        return this.lastColumnNumber;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end >= 0 && this.start >= 0 ? this.end - this.start : -1;
    }

    public void setInsideComments(List<CommentWrapper> commentWrapperList) {
        if (!this.hasAstChildren() || commentWrapperList.isEmpty()) {
            return;
        }
        List<? extends ASTNodeWrapper> childNodes = this.getAstChildren();
        int index = 0;
        while (index < childNodes.size()) {
            ASTNodeWrapper childNode = childNodes.get(index);
            if (commentWrapperList.isEmpty()) break;
            ArrayList<CommentWrapper> insideCommentWrappers = new ArrayList<CommentWrapper>();
            ArrayList<CommentWrapper> preceddingCommentWrappers = new ArrayList<CommentWrapper>();
            ArrayList<CommentWrapper> followingCommentWrappers = new ArrayList<CommentWrapper>();
            int commentCount = 0;
            while (commentCount < commentWrapperList.size()) {
                CommentWrapper commentWrapper = commentWrapperList.get(commentCount);
                if (ASTNodeWrapper.isLeadingComment(childNode, commentWrapper)) {
                    preceddingCommentWrappers.add(commentWrapper);
                    commentWrapperList.remove(commentWrapper);
                    continue;
                }
                if (ASTNodeWrapper.containsComment(childNode, commentWrapper)) {
                    insideCommentWrappers.add(commentWrapper);
                    commentWrapperList.remove(commentWrapper);
                    continue;
                }
                if (ASTNodeWrapper.isInlineTrailingComment(childNode, commentWrapper)) {
                    ASTNodeWrapper nextChildNode;
                    if (index < childNodes.size() - 1 && (ASTNodeWrapper.containsComment(nextChildNode = childNodes.get(index + 1), commentWrapper) || ASTNodeWrapper.isInlineTrailingComment(nextChildNode, commentWrapper))) {
                        ++commentCount;
                        continue;
                    }
                    followingCommentWrappers.add(commentWrapper);
                    commentWrapperList.remove(commentWrapper);
                    continue;
                }
                if (index == childNodes.size() - 1) {
                    followingCommentWrappers.add(commentWrapper);
                    commentWrapperList.remove(commentWrapper);
                    continue;
                }
                ++commentCount;
            }
            childNode.setPreceddingComments(preceddingCommentWrappers);
            childNode.setInsideComments(insideCommentWrappers);
            childNode.setFollowingComments(followingCommentWrappers);
            ++index;
        }
    }

    private static boolean containsComment(ASTNodeWrapper astObject, CommentWrapper comment) {
        return (astObject.getLineNumber() < comment.getLineNumber() || astObject.getLineNumber() == comment.getLineNumber() && astObject.getColumnNumber() < comment.getColumnNumber()) && (astObject.getLastLineNumber() > comment.getLastLineNumber() || astObject.getLastLineNumber() == comment.getLastLineNumber() && astObject.getLastColumnNumber() >= comment.getLastColumnNumber());
    }

    private static boolean isInlineTrailingComment(ASTNodeWrapper astObject, CommentWrapper comment) {
        return astObject.getLastLineNumber() == comment.getLineNumber() && astObject.getLastColumnNumber() <= comment.getColumnNumber();
    }

    private static boolean isLeadingComment(ASTNodeWrapper astObject, CommentWrapper comment) {
        return astObject.getLineNumber() > comment.getLastLineNumber() || astObject.getLineNumber() == comment.getLastLineNumber() && astObject.getColumnNumber() >= comment.getLastColumnNumber();
    }

    public String toString() {
        return this.getText();
    }

    public abstract ASTNodeWrapper clone();

    public ASTNodeWrapper copy(ASTNodeWrapper newParent) {
        ASTNodeWrapper newInstance = this.clone();
        newInstance.setParent(newParent);
        return newInstance;
    }

    public abstract String getText();

    public abstract boolean hasAstChildren();

    public abstract List<? extends ASTNodeWrapper> getAstChildren();

    public boolean isInputEditatble() {
        return false;
    }

    public ASTNodeWrapper getInput() {
        return null;
    }

    public String getInputText() {
        return "";
    }

    public boolean updateInputFrom(ASTNodeWrapper input) {
        return false;
    }

    public boolean isEqualsTo(ASTNodeWrapper anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parse(this);
        String scriptValue = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parse(anotherNode);
        String anotherScriptValue = stringBuilder.toString();
        return scriptValue.equals(anotherScriptValue);
    }

    public boolean isChildAssignble(ASTNodeWrapper astNode) {
        return false;
    }

    public boolean addChild(ASTNodeWrapper childObject) {
        return false;
    }

    public boolean addChild(ASTNodeWrapper childObject, int index) {
        return false;
    }

    public boolean removeChild(ASTNodeWrapper childObject) {
        return false;
    }

    public int indexOf(ASTNodeWrapper childObject) {
        return -1;
    }

    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        return false;
    }
}

