/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors.extensions;

import com.kms.katalon.composer.testcase.editors.extensions.TestObjectsHyperlink;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class TestObjectsHyperlinkDetector
extends AbstractHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String candidate;
        IRegion lineRegion;
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        try {
            lineRegion = document.getLineInformationOfOffset(offset);
            candidate = document.get(lineRegion.getOffset(), lineRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        Pattern findFunctionPattern = Pattern.compile("find([^']+)\\('([^']+)'", 8);
        Matcher findFunctionPatternMatcher = findFunctionPattern.matcher(candidate);
        ArrayList<TestObjectsHyperlink> result = new ArrayList<TestObjectsHyperlink>();
        while (findFunctionPatternMatcher.find()) {
            String findFunctiontMatch = findFunctionPatternMatcher.group();
            Pattern argumentPattern = Pattern.compile("'([^']+)'");
            Matcher argumentPatternMatcher = argumentPattern.matcher(findFunctiontMatch);
            int findFunctionIndex = candidate.indexOf(findFunctiontMatch);
            if (!argumentPatternMatcher.find()) continue;
            String argumentMatch = argumentPatternMatcher.group();
            int argumentIndex = findFunctiontMatch.indexOf(argumentMatch);
            int regionOffset = lineRegion.getOffset() + findFunctionIndex + argumentIndex;
            Region targetRegion = new Region(regionOffset, argumentMatch.length());
            Pattern functionNamePattern = Pattern.compile("find([^\\(]+)");
            Matcher functionNamePatternMatcher = functionNamePattern.matcher(findFunctiontMatch);
            if (!functionNamePatternMatcher.find()) continue;
            String functionNameMatch = functionNamePatternMatcher.group();
            if (targetRegion.getOffset() > offset || targetRegion.getOffset() + targetRegion.getLength() <= offset) continue;
            result.add(new TestObjectsHyperlink((IRegion)targetRegion, functionNameMatch, argumentMatch));
        }
        if (result != null && result.size() > 0) {
            return result.toArray(new IHyperlink[0]);
        }
        return null;
    }
}

