/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.editors.extensions;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.io.File;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class TestObjectsHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final String fArgument;
    private final String fName;
    private static final String WEBELEMENT_FILE_EXTENSION = ".rs";
    private static final String TESTCASE_FILE_EXTENSION = ".tc";
    private static final String DATA_FILE_EXTENSION = ".dat";

    public TestObjectsHyperlink(IRegion urlRegion, String functionName, String functionArgument) {
        this.fRegion = urlRegion;
        this.fName = functionName;
        this.fArgument = functionArgument;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        String location = this.fArgument.replace("'", "");
        String objectID = "";
        try {
            if (this.fName.contains("TestObject")) {
                location = location.startsWith("Object Repository") ? location : "Object Repository/" + location;
                objectID = String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + location + WEBELEMENT_FILE_EXTENSION;
                WebElementEntity webElementEntity = ObjectRepositoryController.getInstance().getWebElement(objectID);
                String event = webElementEntity instanceof WebServiceRequestEntity ? "WSOBJECT/OPEN" : "TESTOBJECT/OPEN";
                EventBrokerSingleton.getInstance().getEventBroker().post(event, (Object)webElementEntity);
            } else if (this.fName.contains("TestCase")) {
                location = location.startsWith("Test Cases") ? location : "Test Cases/" + location;
                objectID = String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + location + TESTCASE_FILE_EXTENSION;
                TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCase(objectID);
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/OPEN", (Object)testCaseEntity);
            } else if (this.fName.contains("TestData")) {
                location = location.startsWith("Data Files") ? location : "Data Files/" + location;
                objectID = String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + location + DATA_FILE_EXTENSION;
                DataFileEntity testDataEntity = TestDataController.getInstance().getTestData(objectID);
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTDATA/OPEN", (Object)testDataEntity);
            }
        }
        catch (Exception e) {
            LoggerSingleton.getInstance();
            LoggerSingleton.logError((String)e.getMessage());
        }
    }
}

