/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.dialogs;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.preferences.TestCaseSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ManageTestCaseTagDialog
extends Dialog {
    public static final int CM_APPEND_TAGS = 1001;
    private TestCaseSettingStore store;
    private TableViewer tagTableViewer;
    private List<TagTableViewerItem> tagItems;
    private Set<String> currentTestCaseTags;
    private Set<String> appendedTags;
    private Text txtSearch;
    private Button btnAppendTags;
    private Button btnCancel;

    public ManageTestCaseTagDialog(Shell parentShell, Set<String> currentTestCaseTags) {
        super(parentShell);
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        this.store = new TestCaseSettingStore(project.getFolderLocation());
        this.currentTestCaseTags = currentTestCaseTags;
        this.initializeTagInput();
    }

    private void initializeTagInput() {
        try {
            Set<String> allTagsInProject = this.store.getTestCaseTags();
            HashSet<String> inputTags = new HashSet<String>();
            inputTags.addAll(allTagsInProject);
            inputTags.addAll(this.currentTestCaseTags);
            this.tagItems = inputTags.stream().map(tag -> {
                TagTableViewerItem item = new TagTableViewerItem();
                item.setTagName((String)tag);
                if (this.currentTestCaseTags.contains(tag)) {
                    item.setSelected(true);
                    item.setEditable(false);
                } else {
                    item.setSelected(false);
                    item.setEditable(true);
                }
                return item;
            }).sorted((item1, item2) -> StringUtils.compareIgnoreCase((String)item1.getTagName(), (String)item2.getTagName())).collect(Collectors.toList());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            this.tagItems = new ArrayList<TagTableViewerItem>();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        GridData gdBody = new GridData(4, 4, true, true);
        gdBody.widthHint = 300;
        gdBody.heightHint = 350;
        body.setLayoutData((Object)gdBody);
        this.txtSearch = new Text(body, 2048);
        this.txtSearch.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtSearch.setMessage(ComposerTestcaseMessageConstants.ManageTestCaseTagDialog_SEARCH_MSG);
        Composite tableComposite = new Composite(body, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tagTableViewer = new TableViewer(tableComposite, 67586);
        this.tagTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table tagTable = this.tagTableViewer.getTable();
        tagTable.setHeaderVisible(true);
        tagTable.setLinesVisible(true);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tagTableViewer);
        TableViewerColumn tableViewerColumnTagName = new TableViewerColumn(this.tagTableViewer, 16384);
        TableColumn tableColumnTagName = tableViewerColumnTagName.getColumn();
        tableColumnTagName.setText(ComposerTestcaseMessageConstants.ManageTestCaseTagDialog_TAG_TABLE_COL_TAG);
        tableViewerColumnTagName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                TagTableViewerItem rowItem = (TagTableViewerItem)cell.getElement();
                if (!rowItem.isEditable()) {
                    cell.setBackground(Display.getDefault().getSystemColor(15));
                }
                cell.setText(rowItem.getTagName());
            }
        });
        TableViewerColumn tableViewerColumnIsSelected = new TableViewerColumn(this.tagTableViewer, 16384);
        TableColumn tableColumnIsSelected = tableViewerColumnIsSelected.getColumn();
        tableColumnIsSelected.setText(ComposerTestcaseMessageConstants.ManageTestCaseTagDialog_TAG_TABLE_COL_SELECTED);
        tableViewerColumnIsSelected.setLabelProvider((CellLabelProvider)new TagSelectionColumnLabelProvider());
        tableViewerColumnIsSelected.setEditingSupport((EditingSupport)new TagSelectionColumnEditingSupport(this.tagTableViewer));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tableColumnTagName, (ColumnLayoutData)new ColumnWeightData(70, 20));
        tableLayout.setColumnData((Widget)tableColumnIsSelected, (ColumnLayoutData)new ColumnWeightData(30, 10));
        tableComposite.setLayout((Layout)tableLayout);
        this.tagTableViewer.setInput(this.tagItems);
        Composite buttonComposite = new Composite(body, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.btnCancel = new Button(buttonComposite, 0);
        this.btnCancel.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.btnCancel.setText(IDialogConstants.CANCEL_LABEL);
        this.btnAppendTags = new Button(buttonComposite, 0);
        this.btnAppendTags.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.btnAppendTags.setText(ComposerTestcaseMessageConstants.ManageTestCaseTagDialog_BTN_APPEND_TAGS);
        this.registerControlEventListeners();
        return body;
    }

    private void registerControlEventListeners() {
        this.txtSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ManageTestCaseTagDialog.this.handleSearchTags();
            }
        });
        this.btnAppendTags.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageTestCaseTagDialog.this.handleAppendTags();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageTestCaseTagDialog.this.cancelPressed();
            }
        });
    }

    private void handleSearchTags() {
        String searchText = this.txtSearch.getText().trim();
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            List matchedItems = this.tagItems.stream().filter(item -> item.getTagName().toLowerCase().contains(searchText.toLowerCase())).collect(Collectors.toList());
            this.tagTableViewer.setInput(matchedItems);
        } else {
            this.tagTableViewer.setInput(this.tagItems);
        }
        this.tagTableViewer.refresh();
    }

    private void handleAppendTags() {
        List tagItems = (List)this.tagTableViewer.getInput();
        this.appendedTags = tagItems.stream().filter(tagItem -> tagItem.isSelected() && !this.currentTestCaseTags.contains(tagItem.getTagName())).map(tagItem -> tagItem.getTagName()).collect(Collectors.toSet());
        this.setReturnCode(1001);
        this.close();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerTestcaseMessageConstants.ManageTestCaseTagDialog_DIA_TITLE);
    }

    public Set<String> getAppendedTags() {
        return this.appendedTags;
    }

    private class TagSelectionColumnEditingSupport
    extends EditingSupport {
        private TableViewer viewer;
        private CheckboxCellEditor editor;

        public TagSelectionColumnEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editor = new CheckboxCellEditor((Composite)this.viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return ((TagTableViewerItem)element).isEditable();
        }

        protected Object getValue(Object element) {
            return ((TagTableViewerItem)element).isSelected();
        }

        protected void setValue(Object element, Object value) {
            ((TagTableViewerItem)element).setSelected((Boolean)value);
            this.viewer.refresh(element);
        }
    }

    private class TagSelectionColumnLabelProvider
    extends StyledCellLabelProvider {
        private TagSelectionColumnLabelProvider() {
        }

        protected void paint(Event event, Object element) {
            GC gc = event.gc;
            TagTableViewerItem tagItem = (TagTableViewerItem)element;
            if (tagItem.isSelected()) {
                gc.drawImage(ImageConstants.IMG_16_CHECKBOX_CHECKED, event.getBounds().x + 5, event.getBounds().y);
            } else {
                gc.drawImage(ImageConstants.IMG_16_CHECKBOX_UNCHECKED, event.getBounds().x + 5, event.getBounds().y);
            }
        }
    }

    private class TagTableViewerItem {
        private String tagName;
        private boolean isSelected;
        private boolean isEditable;

        private TagTableViewerItem() {
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String name) {
            this.tagName = name;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public boolean isEditable() {
            return this.isEditable;
        }

        public void setEditable(boolean isEditable) {
            this.isEditable = isEditable;
        }
    }
}

