/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.components;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public class KeywordNodeTooltip {
    private static final String JAVADOC_SUFFIX = "[JAVADOC_";
    private static final String JAVADOC_HEADER = "[JAVADOC_HEADER]";
    private static final String JAVADOC_SECTION = "[JAVADOC_SECTION]";
    private static final String JAVADOC_SECTION_ITEM = "[JAVADOC_SECTION_ITEM]";
    private static final String JAVADOC_DESCRIPTION = "[JAVADOC_DESCRIPTION]";
    private static final String JAVADOC_SECTION_ITEM_LIST = "[JAVADOC__SECTION_ITEM_LIST]";
    private StyledText javaDocContent;
    private String text = "";
    private int preferedWidth = 600;
    private int preferedHeight = 200;
    private final int TOOLBAR_DEFAULT_HEIGHT = 24;
    private Shell tip;
    private String keywordDescURI = null;
    private Control control;
    private ToolItem openKeywordDescToolItem;
    private ToolBar toolBar;
    private boolean showBelow = true;
    private Shell openKeywordDescTooltip;
    private boolean openedDesc;
    private boolean isOpeningKeywordDescription = false;
    private Point location;
    private static KeywordNodeTooltip currentTooltip = null;

    public KeywordNodeTooltip(Control control) {
        this.control = control;
    }

    public Shell getShell() {
        return this.tip;
    }

    private void initComponents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        parent.setBackgroundMode(2);
        composite.setLayout((Layout)layout);
        composite.setForeground(parent.getDisplay().getSystemColor(28));
        composite.setBackground(parent.getDisplay().getSystemColor(29));
        this.javaDocContent = new StyledText(composite, 584);
        GridData gdJavaDocContent = new GridData(4, 4, true, true);
        this.javaDocContent.setLeftMargin(20);
        this.javaDocContent.setTopMargin(5);
        this.javaDocContent.setLayoutData((Object)gdJavaDocContent);
        Label lbl = new Label(composite, 266);
        GridData gd = new GridData();
        gd.verticalIndent = 0;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000008;
        lbl.setLayoutData((Object)gd);
        this.toolBar = new ToolBar(composite, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.heightHint = 24;
        gd.verticalAlignment = 4;
        this.toolBar.setLayoutData((Object)gd);
        this.toolBar.setBackground(parent.getDisplay().getSystemColor(22));
        new ToolItem(this.toolBar, 2);
        this.openKeywordDescToolItem = new ToolItem(this.toolBar, 0);
        this.openKeywordDescToolItem.setImage(ImageConstants.IMG_KEYWORD_WIKI);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        KeywordNodeTooltip.this.openKeywordDesc();
                        break;
                    }
                    case 7: {
                        if (!KeywordNodeTooltip.this.tip.getBounds().contains(Display.getCurrent().getCursorLocation())) {
                            KeywordNodeTooltip.this.hide();
                        }
                        if (event.widget != KeywordNodeTooltip.this.toolBar) break;
                        KeywordNodeTooltip.this.processOpenKeywordTooltip();
                        break;
                    }
                    case 32: {
                        KeywordNodeTooltip.this.showOpenKeywordTooltip();
                        break;
                    }
                    case 5: {
                        KeywordNodeTooltip.this.processOpenKeywordTooltip();
                    }
                }
            }
        };
        if (this.control instanceof Tree) {
            this.javaDocContent.addListener(7, listener);
            this.toolBar.addListener(7, listener);
        }
        this.toolBar.addListener(32, listener);
        this.toolBar.addListener(5, listener);
        this.openKeywordDescToolItem.addListener(13, listener);
        this.toolBar.pack();
        this.formatJavaDoc();
    }

    private void showOpenKeywordTooltip() {
        if (this.openKeywordDescTooltip != null && !this.openKeywordDescTooltip.isDisposed()) {
            return;
        }
        Point cursorLoc = Display.getCurrent().getCursorLocation();
        if (this.isCursorOnOpenKeywordDescButton(cursorLoc)) {
            this.openKeywordDescTooltip = new Shell(this.tip, 0);
            FillLayout fl = new FillLayout();
            this.openKeywordDescTooltip.setLayout((Layout)fl);
            Point[] cursorSize = Display.getCurrent().getCursorSizes();
            Label lbl = new Label((Composite)this.openKeywordDescTooltip, 0);
            lbl.setBackground(this.toolBar.getBackground());
            lbl.setText(ComposerTestcaseMessageConstants.KEYWORD_TOOLITEM_TIP_TEXT);
            int shift = "win32".equals(Platform.getOS()) ? 10 : 0;
            this.openKeywordDescTooltip.pack();
            this.openKeywordDescTooltip.setLocation(new Point(cursorLoc.x, cursorLoc.y + cursorSize[0].y - shift));
            this.openKeywordDescTooltip.setVisible(true);
        }
    }

    private void processOpenKeywordTooltip() {
        if (this.openKeywordDescTooltip == null || this.openKeywordDescToolItem.isDisposed()) {
            return;
        }
        Point cursorLoc = Display.getCurrent().getCursorLocation();
        if (!this.isCursorOnOpenKeywordDescButton(cursorLoc)) {
            this.openKeywordDescTooltip.dispose();
        } else {
            this.showOpenKeywordTooltip();
        }
    }

    private void createTooltip() {
        this.tip = new Shell(this.control.getShell(), 16404);
        this.tip.setLayout((Layout)new FillLayout());
        this.initComponents((Composite)this.tip);
    }

    public boolean isShowBelowPoint() {
        return this.showBelow;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setPreferedSize(int w, int h) {
        if (w > 0) {
            this.preferedWidth = w;
        }
        if (h > 0) {
            this.preferedHeight = h;
        }
    }

    public void show(Point p) {
        this.hide();
        this.location = p;
        this.createTooltip();
        this.tip.setLocation(p);
        Point tipSize = this.getBestSizeForKeywordDescriptionPopup();
        this.tip.setSize(tipSize);
        if (currentTooltip != null && currentTooltip != this) {
            currentTooltip.hide();
        }
        currentTooltip = this;
        this.openedDesc = false;
        this.tip.setVisible(true);
    }

    private Point getBestSizeForKeywordDescriptionPopup() {
        Monitor currentMonitor = null;
        Monitor[] monitorArray = Display.getCurrent().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            if (monitor.getClientArea().contains(this.location)) {
                currentMonitor = monitor;
                break;
            }
            ++n2;
        }
        Rectangle displayRect = currentMonitor.getClientArea();
        int width = this.preferedWidth;
        if (this.location.x + width > displayRect.x + displayRect.width) {
            width = displayRect.x + displayRect.width - this.location.x;
        }
        return new Point(width, this.preferedHeight);
    }

    private Point getLocation(Point suggestionLoc) {
        Rectangle bounds = Display.getCurrent().getBounds();
        Point tipSize = this.tip.getSize();
        this.showBelow = true;
        if (suggestionLoc.x + tipSize.x < bounds.width && suggestionLoc.y + tipSize.y < bounds.height) {
            return suggestionLoc;
        }
        if (suggestionLoc.x + tipSize.x > bounds.width) {
            suggestionLoc.x -= tipSize.x;
        }
        if (suggestionLoc.y + tipSize.y > bounds.height) {
            this.showBelow = false;
            suggestionLoc.y -= tipSize.y;
        }
        return suggestionLoc;
    }

    public synchronized void hide() {
        if (this.tip != null && !this.tip.isDisposed()) {
            Point cursorLoc = Display.getCurrent().getCursorLocation();
            if (this.isOpenKeywordDescToolItem(cursorLoc) && !this.isOpeningKeywordDescription()) {
                this.openKeywordDesc();
            } else {
                this.tip.dispose();
            }
            currentTooltip = null;
        }
    }

    public boolean isVisible() {
        return this.tip != null && !this.tip.isDisposed() && this.tip.isVisible();
    }

    public void setKeywordURL(String keywordDescURI) {
        this.keywordDescURI = keywordDescURI;
    }

    public boolean isOpenKeywordDescToolItem(Point screenPoint) {
        block3: {
            try {
                if (this.openKeywordDescToolItem != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.isCursorOnOpenKeywordDescButton(screenPoint);
    }

    public boolean isCursorOnOpenKeywordDescButton(Point cursorPoint) {
        Rectangle bounds = this.openKeywordDescToolItem.getBounds();
        Point screenLocation = this.toolBar.toDisplay(bounds.x, bounds.y);
        return new Rectangle(screenLocation.x, screenLocation.y, bounds.width, bounds.height).contains(cursorPoint);
    }

    public void openKeywordDesc() {
        this.setIsOpeingKeywordDescription(true);
        try {
            try {
                Program.launch((String)this.keywordDescURI);
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                this.openedDesc = true;
                if (this.isVisible()) {
                    this.tip.dispose();
                }
                this.setIsOpeingKeywordDescription(false);
            }
        }
        finally {
            this.openedDesc = true;
            if (this.isVisible()) {
                this.tip.dispose();
            }
            this.setIsOpeingKeywordDescription(false);
        }
    }

    public Rectangle getBounds() {
        return this.tip.getBounds();
    }

    private void formatJavaDoc() {
        this.text = this.text.replaceAll("<h4>", JAVADOC_HEADER).replaceAll("<DT><B>", JAVADOC_SECTION).replaceAll("(<DD>|</p>)\\s*", JAVADOC_SECTION_ITEM).replaceAll("<p>\\s*", JAVADOC_DESCRIPTION).replaceAll("<li>", JAVADOC_SECTION_ITEM_LIST).replaceAll("&nbsp;", " ").replaceAll("\\s{2,}", " ").replaceAll("<[^>]+>", "").replaceAll(System.lineSeparator(), "").trim();
        StringBuilder tipContent = new StringBuilder(this.text);
        Pattern pat = Pattern.compile("\\[JAVADOC_\\w+\\]");
        Matcher mat = pat.matcher(tipContent);
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        boolean descriptionExsist = false;
        while (mat.find()) {
            String item;
            int start = mat.start();
            int i = mat.end();
            int end = mat.find() ? mat.start() : tipContent.length();
            switch (item = tipContent.substring(start, i)) {
                case "[JAVADOC_HEADER]": {
                    tipContent.delete(start, start + item.length());
                    StyleRange sr = new StyleRange(start, end - start - item.length(), null, null);
                    sr.fontStyle = 3;
                    styles.add(sr);
                    break;
                }
                case "[JAVADOC_SECTION]": {
                    tipContent.delete(start, start + item.length()).insert(start, System.lineSeparator());
                    this.javaDocContent.setText(tipContent.toString());
                    StyleRange sr = new StyleRange(start + 1, end - start - item.length() + 1, null, null);
                    sr.fontStyle = 1;
                    styles.add(sr);
                    break;
                }
                case "[JAVADOC_DESCRIPTION]": {
                    if (!descriptionExsist) {
                        tipContent.delete(start, start + item.length()).insert(start, System.lineSeparator());
                        descriptionExsist = true;
                        break;
                    }
                }
                case "[JAVADOC_SECTION_ITEM]": {
                    tipContent.delete(start, start + item.length());
                    String line = this.wrapSelectionItemLongLine(tipContent.substring(start, end - item.length()));
                    tipContent.delete(start, end - item.length());
                    tipContent.insert(start, String.valueOf(System.lineSeparator()) + line);
                    break;
                }
                case "[JAVADOC__SECTION_ITEM_LIST]": {
                    tipContent.delete(start, start + item.length()).insert(start, String.valueOf(System.lineSeparator()) + "\t\t " + Character.toString('\u25cf') + " ");
                }
            }
            mat = pat.matcher(tipContent);
        }
        this.text = tipContent.toString();
        this.javaDocContent.setText(this.text);
        this.javaDocContent.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    private String wrapSelectionItemLongLine(String line) {
        GC graphicContext = new GC((Drawable)this.javaDocContent);
        int limWidth = 600;
        String[] words = line.split("\\s{1,}");
        StringBuilder temp = new StringBuilder("\t\t");
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < words.length) {
            if (!this.appendWord(words[i], temp, graphicContext, limWidth)) {
                if (result.length() < 1) {
                    result.append(temp.toString());
                } else {
                    result.append(String.valueOf(System.lineSeparator()) + temp.toString());
                }
                temp.delete(2, temp.length());
            }
            ++i;
        }
        if (temp.length() > 2) {
            if (result.length() < 1) {
                result.append(temp.toString());
            } else {
                result.append(String.valueOf(System.lineSeparator()) + temp.toString());
            }
        }
        graphicContext.dispose();
        return result.toString();
    }

    private boolean appendWord(String word, StringBuilder line, GC graphicContext, int limWidth) {
        int lineWidth = graphicContext.textExtent((String)line.toString(), (int)4).x;
        if (lineWidth >= limWidth) {
            return false;
        }
        int w = graphicContext.textExtent((String)new StringBuilder((String)" ").append((String)word).toString()).x;
        if (lineWidth + w < limWidth) {
            line.append(" " + word);
            return true;
        }
        w = graphicContext.textExtent((String)word).x;
        if (lineWidth + w < limWidth) {
            line.append(word);
            return true;
        }
        return false;
    }

    public boolean isOpenedKeywordDesc() {
        return this.openedDesc;
    }

    private synchronized void setIsOpeingKeywordDescription(boolean isOpeningKeywordDescription) {
        this.isOpeningKeywordDescription = isOpeningKeywordDescription;
    }

    private synchronized boolean isOpeningKeywordDescription() {
        return this.isOpeningKeywordDescription;
    }
}

