/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.variable.operations;

import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class UpVariableOperation
extends AbstractOperation {
    private TableActionOperator testCaseVariablePart;
    private TableViewer tableViewer;
    protected List<VariableEntity> variableList;
    private int moveIndex = -1;

    public UpVariableOperation(TableActionOperator testCaseVariablePart) {
        this(UpVariableOperation.class.getName(), testCaseVariablePart);
    }

    public UpVariableOperation(String label, TableActionOperator testCaseVariablePart) {
        super(label);
        this.testCaseVariablePart = testCaseVariablePart;
        this.tableViewer = testCaseVariablePart.getTableViewer();
        this.variableList = testCaseVariablePart.getVariablesList();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        VariableEntity variable = (VariableEntity)selection.getFirstElement();
        int index = this.variableList.indexOf(variable);
        if (this.isOutOfBound(index)) {
            return Status.CANCEL_STATUS;
        }
        this.moveIndex = index;
        return this.redo(monitor, info);
    }

    protected boolean isOutOfBound(int index) {
        return index <= 0;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Collections.swap(this.variableList, this.moveIndex, this.moveIndex + this.getOffset());
        this.tableViewer.refresh();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    protected int getOffset() {
        return -1;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Collections.swap(this.variableList, this.moveIndex + this.getOffset(), this.moveIndex);
        this.tableViewer.refresh();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }
}

