/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.variable.operations;

import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class NewVariableOperation
extends AbstractOperation {
    private VariableEntity newVariable;
    private TableActionOperator testCaseVariablePart;
    private TableViewer tableViewer;
    private List<VariableEntity> variableList;

    public NewVariableOperation(TableActionOperator testCaseVariablePart, VariableEntity newVariable) {
        super(NewVariableOperation.class.getName());
        this.testCaseVariablePart = testCaseVariablePart;
        this.tableViewer = testCaseVariablePart.getTableViewer();
        this.variableList = testCaseVariablePart.getVariablesList();
        this.newVariable = newVariable;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.newVariable == null) {
            return Status.CANCEL_STATUS;
        }
        this.variableList.add(this.newVariable);
        this.tableViewer.refresh();
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.newVariable));
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.newVariable == null) {
            return Status.CANCEL_STATUS;
        }
        this.variableList.remove(this.newVariable);
        this.tableViewer.refresh();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }
}

