/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.variable.operations;

import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class DeleteVariableOperation
extends AbstractOperation {
    private TableActionOperator testCaseVariablePart;
    private TableViewer tableViewer;
    private List<VariableEntity> variableList;
    private List<DeletedVariable> deletedVariableList;

    public DeleteVariableOperation(TableActionOperator testCaseVariablePart) {
        super(DeleteVariableOperation.class.getName());
        this.testCaseVariablePart = testCaseVariablePart;
        this.tableViewer = testCaseVariablePart.getTableViewer();
        this.variableList = testCaseVariablePart.getVariablesList();
        this.deletedVariableList = new ArrayList<DeletedVariable>();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.deletedVariableList.clear();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        Object[] selectionElements = selection.toArray();
        if (selectionElements.length == 0) {
            return Status.CANCEL_STATUS;
        }
        Object[] objectArray = selectionElements;
        int n = selectionElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof VariableEntity) {
                VariableEntity variable = (VariableEntity)object;
                int index = this.variableList.indexOf(variable);
                this.variableList.remove(index);
                this.deletedVariableList.add(new DeletedVariable(variable, index));
            }
            ++n2;
        }
        this.tableViewer.refresh();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (DeletedVariable deletedVariable : this.deletedVariableList) {
            this.variableList.remove(deletedVariable.getVariable());
        }
        this.tableViewer.refresh();
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<VariableEntity> undoElement = new ArrayList<VariableEntity>();
        for (DeletedVariable deletedVariable : this.deletedVariableList) {
            VariableEntity variable = deletedVariable.getVariable();
            this.variableList.add(deletedVariable.getOriginalIndex(), variable);
            undoElement.add(variable);
        }
        this.tableViewer.refresh();
        this.tableViewer.setSelection((ISelection)new StructuredSelection(undoElement.toArray()));
        this.testCaseVariablePart.setDirty(true);
        return Status.OK_STATUS;
    }

    public class DeletedVariable {
        private VariableEntity variable;
        private int originalIndex;

        public DeletedVariable(VariableEntity variable, int originalIndex) {
            this.variable = variable;
            this.originalIndex = originalIndex;
        }

        public VariableEntity getVariable() {
            return this.variable;
        }

        public void setVariable(VariableEntity variable) {
            this.variable = variable;
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }

        public void setOriginalIndex(int originalIndex) {
            this.originalIndex = originalIndex;
        }
    }
}

