/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.treetable;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.testcase.ast.editors.KeywordComboBoxCellEditorWithContentProposal;
import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.preferences.StoredKeyword;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.FailureHandling;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class AstCustomKeywordTreeTableNode
extends AstAbstractKeywordTreeTableNode {
    public AstCustomKeywordTreeTableNode(ExpressionStatementWrapper methodCallStatement, AstTreeTableNode parentNode) {
        super(methodCallStatement, parentNode);
    }

    private List<MethodNode> getKeywords() {
        ArrayList<MethodNode> keywordMethods = new ArrayList<MethodNode>();
        for (MethodNode keywordMethodNode : this.getCustomKeywordMethods()) {
            keywordMethods.add(keywordMethodNode);
        }
        return keywordMethods;
    }

    @Override
    public String getInputTooltipText() {
        return super.getInputTooltipText();
    }

    @Override
    public String getItemText() {
        return KeywordController.getInstance().getRawCustomKeywordName(this.methodCall.getMethodAsString());
    }

    @Override
    public CellEditor getCellEditorForItem(Composite parent) {
        List<MethodNode> keywordMethods = this.getKeywords();
        String[] tooltips = new String[keywordMethods.size()];
        int i = 0;
        while (i < keywordMethods.size()) {
            tooltips[i] = keywordMethods.get(i).getName();
            ++i;
        }
        Object[] keywordMethodArray = keywordMethods.toArray(new MethodNode[keywordMethods.size()]);
        return new KeywordComboBoxCellEditorWithContentProposal(parent, this.parentStatement, this.getClassName(), keywordMethodArray, keywordMethodArray, tooltips){

            @Override
            protected MethodCallExpressionWrapper createNewKeywordExpression(String keywordClass, String newMethodName, StatementWrapper parentStatement) {
                ASTNodeWrapper currentInput = parentStatement.getInput();
                ArgumentListExpressionWrapper currentArguments = currentInput instanceof MethodCallExpressionWrapper ? ((MethodCallExpressionWrapper)currentInput).getArguments() : null;
                return AstKeywordsInputUtil.generateCustomKeywordExpression(keywordClass, newMethodName, currentArguments, parentStatement);
            }

            @Override
            protected String getKeywordName(MethodCallExpressionWrapper methodCall) {
                return KeywordController.getInstance().getRawCustomKeywordName(methodCall.getMethodAsString());
            }
        };
    }

    private MethodNode getMethodNode() {
        MethodNode keywordMethodNode = KeywordController.getInstance().getCustomKeywordByName(this.methodCall.getObjectExpressionAsString(), this.getItemText(), ProjectController.getInstance().getCurrentProject());
        return keywordMethodNode;
    }

    @Override
    public boolean canEditInput() {
        MethodNode keywordMethodNode = this.getMethodNode();
        if (keywordMethodNode == null) {
            return false;
        }
        int count = 0;
        int i = 0;
        while (i < keywordMethodNode.getParameters().length) {
            if (!AstEntityInputUtil.isTestObjectClass(keywordMethodNode.getParameters()[i].getType())) {
                ++count;
            }
            ++i;
        }
        return count > 0;
    }

    @Override
    public String getInputText() {
        ArgumentListExpressionWrapper arguments = this.methodCall.getArguments();
        if (arguments == null || arguments.getExpressions() == null || arguments.getExpressions().isEmpty()) {
            return "";
        }
        MethodNode keywordMethodNode = this.getMethodNode();
        if (keywordMethodNode == null) {
            return "";
        }
        return this.buildInputDisplayString(arguments, keywordMethodNode);
    }

    private String buildInputDisplayString(ArgumentListExpressionWrapper arguments, MethodNode keywordMethodNode) {
        StringBuilder displayString = new StringBuilder();
        int count = 0;
        int i = 0;
        while (i < keywordMethodNode.getParameters().length && i < arguments.getExpressions().size()) {
            if (!AstEntityInputUtil.isTestObjectClass(keywordMethodNode.getParameters()[i].getType())) {
                if (count > 0) {
                    displayString.append("; ");
                }
                displayString.append(arguments.getExpression(i).getText());
                ++count;
            }
            ++i;
        }
        return displayString.toString();
    }

    @Override
    protected List<InputParameter> getInputParameters() {
        return AstKeywordsInputUtil.generateCustomKeywordInputParameters(this.getClassName(), this.getKeywordName(), this.methodCall.getArguments().clone());
    }

    @Override
    protected int getObjectArgumentIndex() {
        MethodNode keywordMethodNode = this.getMethodNode();
        if (keywordMethodNode == null) {
            return -1;
        }
        int i = 0;
        while (i < keywordMethodNode.getParameters().length) {
            if (AstEntityInputUtil.isTestObjectClass(keywordMethodNode.getParameters()[i].getType())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean canEditOutput() {
        MethodNode keywordMethodNode = this.getMethodNode();
        return this.isOutputNotVoid(keywordMethodNode);
    }

    private boolean isOutputNotVoid(MethodNode keywordMethodNode) {
        return keywordMethodNode != null && !AstKeywordsInputUtil.isVoidClass(keywordMethodNode.getReturnType());
    }

    private String getClassName() {
        return this.methodCall.getObjectExpressionAsString();
    }

    @Override
    protected Class<?> getOutputReturnType() {
        MethodNode keywordMethodNode = this.getMethodNode();
        if (this.isOutputNotVoid(keywordMethodNode)) {
            return keywordMethodNode.getReturnType().getTypeClass();
        }
        return null;
    }

    private List<MethodNode> getCustomKeywordMethods() {
        return KeywordController.getInstance().getCustomKeywords(ProjectController.getInstance().getCurrentProject());
    }

    @Override
    public boolean setFailureHandlingValue(FailureHandling failureHandling) {
        if (this.getFailureHandlingValue() != null) {
            return super.setFailureHandlingValue(failureHandling);
        }
        return false;
    }

    @Override
    public boolean setItem(Object item) {
        try {
            boolean bl = super.setItem(item);
            return bl;
        }
        finally {
            TestCasePreferenceDefaultValueInitializer.addNewRecentKeywords(new StoredKeyword(this.getClassName(), this.getKeywordName(), true));
            EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/RECENT_KEYWORD_ADDED", null);
        }
    }
}

