/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.treetable;

import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.ast.treetable.AstBuiltInKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.editors.CallTestCaseCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.custom.factory.BuiltInMethodNodeFactory;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AstCallTestCaseKeywordTreeTableNode
extends AstBuiltInKeywordTreeTableNode {
    private String testCasePk = "";

    public AstCallTestCaseKeywordTreeTableNode(ExpressionStatementWrapper methodCallStatement, AstTreeTableNode parentNode) {
        super(methodCallStatement, parentNode);
        this.internallySetTestCasePk();
    }

    @Override
    public boolean canEditItem() {
        return false;
    }

    private void internallySetTestCasePk() {
        String testCaseId = AstEntityInputUtil.findTestCaseIdArgumentFromCallTestCaseMethodCall(this.methodCall);
        if (testCaseId == null) {
            return;
        }
        TestCaseEntity testCase = null;
        try {
            testCase = TestCaseController.getInstance().getTestCaseByDisplayId(TestCaseFactory.getTestCaseId((String)testCaseId));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (testCase == null) {
            return;
        }
        this.testCasePk = testCase.getIdForDisplay();
    }

    private void changeMapExpressionWrapper(MapExpressionWrapper mapExprs) {
        this.methodCall.getArguments().setExpression(mapExprs, 1);
    }

    private void changeTestCasePk(TestCaseEntity testCase) {
        ArgumentListExpressionWrapper arguments = this.methodCall.getArguments();
        MethodCallExpressionWrapper testCaseMethodCallEprs = AstEntityInputUtil.createNewFindTestCaseMethodCall(testCase, arguments);
        arguments.setExpression(testCaseMethodCallEprs, 0);
        this.internallySetTestCasePk();
    }

    @Override
    public String getInputText() {
        ArgumentListExpressionWrapper arguments = this.methodCall.getArguments();
        if (arguments == null || arguments.getExpressions().size() == 0) {
            return "";
        }
        KeywordMethod keywordMethod = BuiltInMethodNodeFactory.findCallTestCaseMethod((String)this.getBuiltInKWClassSimpleName());
        if (keywordMethod == null) {
            return "";
        }
        return this.buildInputDisplayString(arguments, keywordMethod);
    }

    @Override
    protected boolean isIgnoreParamType(Class<?> paramType) {
        return super.isIgnoreParamType(paramType) || AstEntityInputUtil.isTestCaseClass(paramType);
    }

    @Override
    public boolean canEditInput() {
        return true;
    }

    @Override
    protected List<InputParameter> getInputParameters() {
        ArgumentListExpressionWrapper argumentList = this.methodCall.getArguments();
        if (argumentList == null) {
            return null;
        }
        return AstKeywordsInputUtil.generateInputParameters(this.findKeywordMethod(), argumentList);
    }

    @Override
    protected KeywordMethod findKeywordMethod() {
        return BuiltInMethodNodeFactory.findCallTestCaseMethod((String)this.getBuiltInKWClassSimpleName());
    }

    public List<VariableEntity> getCallTestCaseVariables() {
        return AstEntityInputUtil.getCallTestCaseVariables(this.methodCall);
    }

    @Override
    public boolean canEditOutput() {
        return false;
    }

    @Override
    public boolean canEditTestObject() {
        return true;
    }

    @Override
    public String getTestObjectText() {
        TestCaseEntity testCase = this.getTestObject();
        if (testCase != null) {
            return testCase.getName();
        }
        return "";
    }

    public TestCaseEntity getTestObject() {
        try {
            return TestCaseController.getInstance().getTestCaseByDisplayId(this.testCasePk);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public CellEditor getCellEditorForTestObject(Composite parent) {
        return new CallTestCaseCellEditor(parent, this.getTestObjectText(), this.testCasePk);
    }

    @Override
    public boolean setTestObject(Object object) {
        TestCaseEntity newTestCase = null;
        if (object instanceof TestCaseTreeEntity) {
            try {
                newTestCase = ((TestCaseTreeEntity)object).getObject();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return false;
            }
        } else if (object instanceof TestCaseEntity) {
            newTestCase = (TestCaseEntity)object;
        }
        if (newTestCase == null) {
            return false;
        }
        if (!this.verifyCallTestCase(newTestCase)) {
            return false;
        }
        this.changeTestCasePk(newTestCase);
        this.changeMapExpressionWrapper(AstEntityInputUtil.generateTestCaseVariableBindingMapExpression(newTestCase, this.methodCall));
        return true;
    }

    private boolean verifyCallTestCase(TestCaseEntity newTestCase) {
        if (newTestCase == null) {
            return false;
        }
        if (this.statement.getScriptClass() == null || this.statement.getScriptClass().getTestCaseId() == null) {
            return true;
        }
        if (StringUtils.equals((String)newTestCase.getRelativePathForUI(), (String)this.statement.getScriptClass().getTestCaseId())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.PA_ERROR_MSG_TEST_CASE_CANNOT_CALL_ITSELF);
            return false;
        }
        return true;
    }

    @Override
    public Image getIcon() {
        return ImageConstants.IMG_16_CALL_TEST_CASE;
    }
}

