/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.treetable;

import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.testcase.ast.editors.InputCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.TestObjectCellEditor;
import com.kms.katalon.composer.testcase.ast.treetable.AstInputEditableStatementTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstItemEditableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstObjectEditableNode;
import com.kms.katalon.composer.testcase.ast.treetable.IAstOutputEditableNode;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.TokenWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputParameterBuilder;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class AstAbstractKeywordTreeTableNode
extends AstInputEditableStatementTreeTableNode
implements IAstItemEditableNode,
IAstObjectEditableNode,
IAstOutputEditableNode {
    private static final String COMMENT_KW_NAME = "comment";
    protected MethodCallExpressionWrapper methodCall;
    protected ExpressionStatementWrapper parentStatement;
    protected BinaryExpressionWrapper binaryExpression;
    private ITestCasePart testCasePart;

    public AstAbstractKeywordTreeTableNode(ExpressionStatementWrapper methodCallStatement, AstTreeTableNode parentNode) {
        super(methodCallStatement, parentNode);
        if (methodCallStatement.getExpression() instanceof MethodCallExpressionWrapper) {
            this.methodCall = (MethodCallExpressionWrapper)methodCallStatement.getExpression();
        } else if (methodCallStatement.getExpression() instanceof BinaryExpressionWrapper) {
            this.binaryExpression = (BinaryExpressionWrapper)methodCallStatement.getExpression();
            this.methodCall = (MethodCallExpressionWrapper)this.binaryExpression.getRightExpression();
        }
        this.parentStatement = methodCallStatement;
    }

    @Override
    public boolean canEditItem() {
        return true;
    }

    @Override
    public String getItemText() {
        return TreeEntityUtil.getReadableKeywordName((String)this.getKeywordName());
    }

    @Override
    public Object getItem() {
        return this.methodCall;
    }

    @Override
    public boolean setItem(Object item) {
        if (!(item instanceof MethodCallExpressionWrapper)) {
            return false;
        }
        MethodCallExpressionWrapper newMethodCall = (MethodCallExpressionWrapper)item;
        if (StringUtils.equals((String)newMethodCall.getMethodAsString(), (String)this.getKeywordName())) {
            return false;
        }
        this.methodCall.setMethod(newMethodCall.getMethodAsString());
        this.methodCall.setArguments(newMethodCall.getArguments());
        if (!this.canEditOutput()) {
            this.removeOutput();
        }
        return true;
    }

    @Override
    public String getItemTooltipText() {
        return this.getItemText();
    }

    public String getKeywordName() {
        return this.methodCall.getMethodAsString();
    }

    @Override
    public String getInputTooltipText() {
        return this.getInputText();
    }

    protected abstract int getObjectArgumentIndex();

    @Override
    public boolean canEditTestObject() {
        return this.getObjectArgumentIndex() != -1;
    }

    protected ExpressionWrapper getTestObjectExpression() {
        int index = this.getObjectArgumentIndex();
        if (index == -1) {
            return null;
        }
        return this.methodCall.getArguments().getExpression(index);
    }

    @Override
    public Object getTestObject() {
        return this.getTestObjectExpression();
    }

    @Override
    public String getTestObjectText() {
        ExpressionWrapper expression = this.getTestObjectExpression();
        if (expression == null) {
            return "";
        }
        InputValueType inputValueType = AstValueUtil.getTypeValue(expression);
        if (inputValueType != null) {
            return inputValueType.getValueToDisplay(expression);
        }
        return this.getTestObjectExpression().getText();
    }

    @Override
    public String getTestObjectTooltipText() {
        ExpressionWrapper expression = this.getTestObjectExpression();
        if (expression == null) {
            return "";
        }
        InputValueType inputValueType = AstValueUtil.getTypeValue(expression);
        if (inputValueType != null) {
            return this.getTestObjectTooltipText(expression);
        }
        return this.getTestObjectExpression().getText();
    }

    @Override
    public CellEditor getCellEditorForTestObject(Composite parent) {
        TestObjectCellEditor cellEditor = new TestObjectCellEditor(parent, this.getTestObjectText(), true);
        cellEditor.setTestCasePart(this.getTestCasePart());
        return cellEditor;
    }

    @Override
    public boolean setTestObject(Object object) {
        int index = this.getObjectArgumentIndex();
        if (index == -1 || !(object instanceof ExpressionWrapper)) {
            return false;
        }
        this.methodCall.getArguments().setExpression((ExpressionWrapper)object, index);
        return true;
    }

    @Override
    public CellEditor getCellEditorForInput(Composite parent) {
        return new InputCellEditor(parent, this.getInputText(), this.methodCall.getArguments());
    }

    @Override
    public final Object getInput() {
        return InputParameterBuilder.createForMethodCall(this.getInputParameters());
    }

    protected abstract List<InputParameter> getInputParameters();

    @Override
    public final boolean setInput(Object input) {
        if (input instanceof InputParameterBuilder) {
            this.setInputParameters(((InputParameterBuilder)input).getOriginalParameters());
            return true;
        }
        return false;
    }

    protected boolean setInputParameters(List<InputParameter> originalParameters) {
        ArgumentListExpressionWrapper argumentListExpression = new ArgumentListExpressionWrapper((ASTNodeWrapper)this.methodCall);
        for (InputParameter input : originalParameters) {
            argumentListExpression.addExpression(input.getValueAsExpression());
        }
        return this.methodCall.setArguments(argumentListExpression);
    }

    @Override
    public String getOutputText() {
        return this.getOutput();
    }

    @Override
    public String getOutputTooltipText() {
        return this.getOutputText();
    }

    @Override
    public String getOutput() {
        if (this.binaryExpression != null && this.binaryExpression.getLeftExpression() != null) {
            return this.binaryExpression.getLeftExpression().getText();
        }
        return "";
    }

    @Override
    public CellEditor getCellEditorForOutput(Composite parent) {
        return new TextCellEditor(parent);
    }

    protected abstract Class<?> getOutputReturnType();

    @Override
    public boolean setOutput(Object output) {
        if (output == null) {
            return this.removeOutput();
        }
        if (!(output instanceof String)) {
            return false;
        }
        String outputString = (String)output;
        if (outputString.isEmpty()) {
            return this.removeOutput();
        }
        if (this.binaryExpression == null) {
            return this.createNewOuput(outputString);
        }
        return this.changeExistingOutput(outputString);
    }

    @Override
    public void setTestCasePart(ITestCasePart testCasePart) {
        this.testCasePart = testCasePart;
    }

    @Override
    public ITestCasePart getTestCasePart() {
        return this.testCasePart;
    }

    private boolean changeExistingOutput(String outputString) {
        if (this.binaryExpression.getLeftExpression() instanceof VariableExpressionWrapper) {
            VariableExpressionWrapper variableExpressionWrapper = (VariableExpressionWrapper)this.binaryExpression.getLeftExpression();
            if (variableExpressionWrapper.getVariable().equals(outputString)) {
                return false;
            }
            variableExpressionWrapper.setVariable(outputString);
            return true;
        }
        VariableExpressionWrapper newLeftExpression = new VariableExpressionWrapper(outputString, this.getOutputReturnType(), this.binaryExpression);
        if (!newLeftExpression.isEqualsTo(this.binaryExpression.getLeftExpression())) {
            this.binaryExpression.setLeftExpression(newLeftExpression);
            return true;
        }
        return false;
    }

    private boolean createNewOuput(String outputString) {
        this.binaryExpression = new BinaryExpressionWrapper(this.parentStatement);
        VariableExpressionWrapper leftExpression = new VariableExpressionWrapper(outputString, this.getOutputReturnType(), this.binaryExpression);
        this.binaryExpression.setLeftExpression(leftExpression);
        this.binaryExpression.setOperation(new TokenWrapper(GeneralUtils.ASSIGN, (ASTNodeWrapper)this.binaryExpression));
        this.binaryExpression.setRightExpression(this.methodCall);
        this.methodCall.setParent(this.binaryExpression);
        this.parentStatement.setExpression(this.binaryExpression);
        return true;
    }

    protected boolean removeOutput() {
        if (this.binaryExpression == null) {
            return false;
        }
        this.binaryExpression = null;
        this.parentStatement.setExpression(this.methodCall);
        this.methodCall.setParent(this.parentStatement);
        return true;
    }

    protected PropertyExpressionWrapper getFailureHandlingPropertyExpression() {
        for (ExpressionWrapper expression : this.methodCall.getArguments().getExpressions()) {
            if (!(expression instanceof PropertyExpressionWrapper) || !((PropertyExpressionWrapper)expression).isObjectExpressionOfClass(FailureHandling.class)) continue;
            return (PropertyExpressionWrapper)expression;
        }
        return null;
    }

    public FailureHandling getFailureHandlingValue() {
        PropertyExpressionWrapper failureHandlingPropertyExpression = this.getFailureHandlingPropertyExpression();
        if (failureHandlingPropertyExpression != null) {
            return FailureHandling.valueOf((String)failureHandlingPropertyExpression.getPropertyAsString());
        }
        return null;
    }

    public boolean setFailureHandlingValue(FailureHandling failureHandling) {
        PropertyExpressionWrapper failureHandlingPropertyExpression = this.getFailureHandlingPropertyExpression();
        if (failureHandlingPropertyExpression == null) {
            failureHandlingPropertyExpression = new PropertyExpressionWrapper(FailureHandling.class.getSimpleName(), failureHandling.name(), this.methodCall.getArguments());
            this.methodCall.getArguments().addExpression(failureHandlingPropertyExpression);
            return true;
        }
        if (StringUtils.equals((String)failureHandling.toString(), (String)failureHandlingPropertyExpression.getPropertyAsString())) {
            return false;
        }
        failureHandlingPropertyExpression.setProperty(new ConstantExpressionWrapper(failureHandling.toString(), (ASTNodeWrapper)failureHandlingPropertyExpression));
        return true;
    }

    @Override
    public Image getIcon() {
        if (this.isComment()) {
            return ImageConstants.IMG_16_COMMENT;
        }
        FailureHandling failureHandling = this.getFailureHandlingValue();
        if (failureHandling == null) {
            failureHandling = new TestCaseSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation()).getDefaultFailureHandling();
        }
        switch (failureHandling) {
            case OPTIONAL: {
                return ImageConstants.IMG_16_OPTIONAL_RUN;
            }
            case STOP_ON_FAILURE: {
                return ImageConstants.IMG_16_FAILED_STOP;
            }
        }
        return ImageConstants.IMG_16_FAILED_CONTINUE;
    }

    private boolean isComment() {
        return this.methodCall.getMethod() != null && COMMENT_KW_NAME.equals(this.methodCall.getMethodAsString()) && this.methodCall.getObjectExpression() != null && KeywordController.getInstance().getBuiltInKeywordClassByName(this.methodCall.getObjectExpressionAsString()) != null;
    }

    public String getTestObjectTooltipText(ASTNodeWrapper astObject) {
        if (astObject instanceof MethodCallExpressionWrapper) {
            return this.getTooltipForTestObjectArgument((MethodCallExpressionWrapper)astObject);
        }
        return astObject.getText();
    }

    public String getTooltipForTestObjectArgument(MethodCallExpressionWrapper methodCall) {
        return AstEntityInputUtil.getEntityRelativeIdFromMethodCall(methodCall);
    }
}

