/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.editors;

import com.kms.katalon.composer.components.dialogs.ApplyingEditingValue;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class MethodComboBoxCellEditor
extends ComboBoxCellEditor
implements ApplyingEditingValue {
    private List<Method> methods = new ArrayList<Method>();
    private boolean staticOnly;
    private ClassLoader classLoader;

    public MethodComboBoxCellEditor(Composite parent, Class<?> type, boolean staticOnly, ClassLoader classLoader) {
        super(parent, new String[0]);
        this.staticOnly = staticOnly;
        this.classLoader = classLoader;
        if (type != null) {
            this.pupulateMethodListWithTypeMethods(type);
        } else {
            this.populateMethodListWithGroovyDefaultMethods();
        }
        Collections.sort(this.methods, new Comparator<Method>(){

            @Override
            public int compare(Method method_1, Method method_2) {
                if (method_1 == null || method_2 == null) {
                    return 0;
                }
                int methodNameComparison = method_1.getName().compareTo(method_2.getName());
                if (methodNameComparison != 0) {
                    return methodNameComparison;
                }
                return method_1.getParameterTypes().length - method_2.getParameterTypes().length;
            }
        });
        String[] methodSignatures = new String[this.methods.size()];
        int index = 0;
        while (index < this.methods.size()) {
            methodSignatures[index] = MethodComboBoxCellEditor.getMethodSignature(this.methods.get(index));
            ++index;
        }
        this.setItems(methodSignatures);
    }

    private void pupulateMethodListWithTypeMethods(Class<?> type) {
        Method[] methodArray = type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && (!this.staticOnly || Modifier.isStatic(method.getModifiers()))) {
                this.methods.add(method);
            }
            ++n2;
        }
    }

    private void populateMethodListWithGroovyDefaultMethods() {
        this.pupulateMethodListWithTypeMethods(DefaultGroovyMethods.class);
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof MethodCallExpressionWrapper));
        MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)value;
        int bestMatchIndex = 0;
        int index = 0;
        while (index < this.methods.size()) {
            switch (MethodComboBoxCellEditor.compareMethodAndMethodCall(this.methods.get(index), methodCall, this.classLoader)) {
                case EQUAL_NAME_ONLY: {
                    bestMatchIndex = index;
                    break;
                }
                case EQUAL_NAME_AND_PARAM: {
                    super.doSetValue((Object)index);
                    return;
                }
            }
            ++index;
        }
        super.doSetValue((Object)bestMatchIndex);
    }

    public static MethodComparation compareMethodAndMethodCall(Method methodNode, MethodCallExpressionWrapper methodCall, ClassLoader classLoader) {
        if (!methodCall.getMethodAsString().equals(methodNode.getName())) {
            return MethodComparation.NOT_EQUAL_NAME;
        }
        if (MethodComboBoxCellEditor.compareArguments(methodNode.getParameterTypes(), MethodComboBoxCellEditor.getMethodCallParams(methodCall, classLoader), classLoader)) {
            return MethodComparation.EQUAL_NAME_AND_PARAM;
        }
        return MethodComparation.EQUAL_NAME_ONLY;
    }

    protected Method doGetValue() {
        Integer selectionIndex = (Integer)super.doGetValue();
        if (selectionIndex < 0 || selectionIndex >= this.methods.size()) {
            return null;
        }
        return this.methods.get(selectionIndex);
    }

    public static String getMethodSignature(Method method) {
        if (method == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(method.getName()) + "(");
        List<Class<?>> paramClasses = MethodComboBoxCellEditor.getParamClasses(method);
        int j = 0;
        while (j < paramClasses.size()) {
            sb.append(MethodComboBoxCellEditor.getTypeName(paramClasses.get(j)));
            if (j < paramClasses.size() - 1) {
                sb.append(", ");
            }
            ++j;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getTypeName(Class<?> type) {
        if (!type.isArray()) {
            return MethodComboBoxCellEditor.getTypeNameIfPrimitive(type);
        }
        Class<?> cl = type;
        int dimensions = 0;
        while (cl.isArray()) {
            ++dimensions;
            cl = cl.getComponentType();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cl.getName());
        int i = 0;
        while (i < dimensions) {
            sb.append("[]");
            ++i;
        }
        return sb.toString();
    }

    private static String getTypeNameIfPrimitive(Class<?> type) {
        if (type == Boolean.class) {
            return Boolean.TYPE.getName();
        }
        if (type == Byte.class) {
            return Byte.TYPE.getName();
        }
        if (type == Character.class) {
            return Character.TYPE.getName();
        }
        if (type == Short.class) {
            return Short.TYPE.getName();
        }
        if (type == Integer.class) {
            return Integer.TYPE.getName();
        }
        if (type == Long.class) {
            return Long.TYPE.getName();
        }
        if (type == Float.class) {
            return Float.TYPE.getName();
        }
        if (type == Double.class) {
            return Double.TYPE.getName();
        }
        return type.getName();
    }

    public static Class<?>[] getMethodCallParams(MethodCallExpressionWrapper methodCall, ClassLoader classLoader) {
        ArgumentListExpressionWrapper argumentList = methodCall.getArguments();
        Class[] methodCallParam = new Class[argumentList.getExpressions().size()];
        int index = 0;
        while (index < argumentList.getExpressions().size()) {
            methodCallParam[index] = argumentList.getExpression(index).resolveType(classLoader);
            ++index;
        }
        return methodCallParam;
    }

    private static boolean compareArguments(Class<?>[] methodClassParams, Class<?>[] methodCallParams, ClassLoader classLoader) {
        if (methodClassParams.length != methodCallParams.length) {
            return false;
        }
        int i = 0;
        while (i < methodClassParams.length) {
            Class<?> methodCallParam = MethodComboBoxCellEditor.changeToPrimitiveTypeIfPossible(methodCallParams[i], classLoader);
            Class<?> methodClassParam = MethodComboBoxCellEditor.changeToPrimitiveTypeIfPossible(methodClassParams[i], classLoader);
            if (!ClassUtils.isAssignable(methodClassParam, methodCallParam, (boolean)true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Class<?> changeToPrimitiveTypeIfPossible(Class<?> type, ClassLoader classLoader) {
        if (type == null) {
            return null;
        }
        try {
            Class<?> wrapper = ClassUtils.primitiveToWrapper(type);
            Class<?> numberClass = MethodComboBoxCellEditor.getNumberClass(classLoader);
            if (numberClass.isAssignableFrom(wrapper)) {
                wrapper = numberClass;
            }
            return classLoader.loadClass(wrapper.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return type;
        }
    }

    private static Class<?> getNumberClass(ClassLoader classLoader) {
        try {
            return classLoader.loadClass(Number.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Number.class;
        }
    }

    public static List<Class<?>> getParamClasses(Method method) {
        if (method == null) {
            return Collections.emptyList();
        }
        ArrayList parameterClasses = new ArrayList();
        Type[] typeArray = method.getGenericParameterTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type instanceof Class) {
                parameterClasses.add((Class)type);
            } else if (MethodComboBoxCellEditor.isMapType(type)) {
                parameterClasses.add(Map.class);
            }
            ++n2;
        }
        return parameterClasses;
    }

    private static boolean isMapType(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class && ((Class)((ParameterizedType)type).getRawType()).getName().equals(Map.class.getName());
    }

    public void applyEditingValue() {
        this.fireApplyEditorValue();
    }

    public static enum MethodComparation {
        NOT_EQUAL_NAME,
        EQUAL_NAME_ONLY,
        EQUAL_NAME_AND_PARAM;

    }
}

