/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.editors;

import com.kms.katalon.composer.components.dialogs.ApplyingEditingValue;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class BooleanConstantComboBoxCellEditor
extends ComboBoxCellEditor
implements ApplyingEditingValue {
    private ConstantExpressionWrapper constantExpression;
    private static final String[] BOOLEAN_CONSTANTS = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};

    public BooleanConstantComboBoxCellEditor(Composite parent) {
        super(parent, BOOLEAN_CONSTANTS);
    }

    protected ConstantExpressionWrapper doGetValue() {
        Integer selectionIndex = (Integer)super.doGetValue();
        if (selectionIndex < 0 || selectionIndex >= this.getItems().length) {
            return null;
        }
        this.constantExpression.setValue(Boolean.parseBoolean(this.getItems()[selectionIndex]));
        return this.constantExpression;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((value instanceof ConstantExpressionWrapper && ((ConstantExpressionWrapper)value).isBooleanExpression() ? 1 : 0) != 0);
        this.constantExpression = ((ConstantExpressionWrapper)value).clone();
        String propertyEnumValue = this.constantExpression.getValue().toString();
        int index = 0;
        while (index < this.getItems().length) {
            if (this.getItems()[index].equals(propertyEnumValue)) {
                super.doSetValue((Object)index);
                break;
            }
            ++index;
        }
    }

    public void applyEditingValue() {
        this.fireApplyEditorValue();
    }
}

