/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class PropertyInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private final InputValueType[] defaultObjectInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Property);
    private PropertyExpressionWrapper propertyExpression;

    public PropertyInputBuilderDialog(Shell parentShell, PropertyExpressionWrapper propertyExpression) {
        super(parentShell);
        this.propertyExpression = propertyExpression.clone();
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<PropertyExpressionWrapper> expressionList = new ArrayList<PropertyExpressionWrapper>();
        expressionList.add(this.propertyExpression);
        this.tableViewer.setInput(expressionList);
        this.tableViewer.refresh();
    }

    @Override
    public PropertyExpressionWrapper getReturnValue() {
        return this.propertyExpression;
    }

    @Override
    public String getDialogTitle() {
        return StringConstants.DIA_TITLE_PROPERTY_INPUT;
    }

    @Override
    protected void addTableColumns() {
        this.addTableColumnObjectType();
        this.addTableColumnObject();
        this.addTableColumnProperty();
    }

    private void addTableColumnProperty() {
        TableViewerColumn tableViewerColumnProperty = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnProperty = tableViewerColumnProperty.getColumn();
        tblclmnNewColumnProperty.setText(StringConstants.DIA_COL_PROPERTY);
        tblclmnNewColumnProperty.setWidth(152);
        tableViewerColumnProperty.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == PropertyInputBuilderDialog.this.propertyExpression) {
                    return PropertyInputBuilderDialog.this.propertyExpression.getPropertyAsString();
                }
                return "";
            }
        });
        tableViewerColumnProperty.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            Class<?> type;
            String[] fieldNames;

            protected void setValue(Object element, Object value) {
                if (this.type != null && this.fieldNames != null && this.fieldNames.length > 0 && value instanceof Integer && (Integer)value >= 0 && (Integer)value < this.fieldNames.length) {
                    PropertyInputBuilderDialog.this.propertyExpression.setProperty(this.fieldNames[(Integer)value]);
                    this.getViewer().refresh();
                    return;
                }
                if (value instanceof String) {
                    PropertyInputBuilderDialog.this.propertyExpression.setProperty((String)value);
                    this.getViewer().refresh();
                }
            }

            protected Object getValue(Object element) {
                if (this.type == null || this.fieldNames == null || this.fieldNames.length == 0) {
                    return PropertyInputBuilderDialog.this.propertyExpression.getPropertyAsString();
                }
                int i = 0;
                while (i < this.fieldNames.length) {
                    if (PropertyInputBuilderDialog.this.propertyExpression.getPropertyAsString().equals(this.fieldNames[i])) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.type != null && this.fieldNames != null && this.fieldNames.length > 0) {
                    return new ComboBoxCellEditor((Composite)PropertyInputBuilderDialog.this.tableViewer.getTable(), this.fieldNames);
                }
                return new TextCellEditor((Composite)PropertyInputBuilderDialog.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                if (element != PropertyInputBuilderDialog.this.propertyExpression) {
                    return false;
                }
                this.type = AstKeywordsInputUtil.loadType(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpressionAsString(), PropertyInputBuilderDialog.this.propertyExpression.getScriptClass());
                if (this.type != null) {
                    this.fieldNames = new String[this.type.getFields().length];
                    int index = 0;
                    while (index < this.type.getFields().length) {
                        this.fieldNames[index] = this.type.getFields()[index].getName();
                        ++index;
                    }
                }
                return true;
            }
        });
    }

    private void addTableColumnObject() {
        TableViewerColumn tableViewerColumnObject = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnObject = tableViewerColumnObject.getColumn();
        tblclmnNewColumnObject.setWidth(152);
        tblclmnNewColumnObject.setText(StringConstants.DIA_COL_OBJ);
        tableViewerColumnObject.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == PropertyInputBuilderDialog.this.propertyExpression) {
                    return super.getText(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
                }
                return "";
            }
        });
        tableViewerColumnObject.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                return element == PropertyInputBuilderDialog.this.propertyExpression && super.canEdit(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
            }
        });
    }

    private void addTableColumnObjectType() {
        TableViewerColumn tableViewerColumnObjectType = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumnObjectType = tableViewerColumnObjectType.getColumn();
        tableColumnObjectType.setWidth(152);
        tableColumnObjectType.setText(StringConstants.DIA_COL_OBJ_TYPE);
        tableViewerColumnObjectType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == PropertyInputBuilderDialog.this.propertyExpression) {
                    return super.getText(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
                }
                return "";
            }
        });
        tableViewerColumnObjectType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultObjectInputValueTypes){

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                return element == PropertyInputBuilderDialog.this.propertyExpression;
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(PropertyInputBuilderDialog.this.propertyExpression.getObjectExpression());
            }
        });
    }
}

