/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class ListInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.List);
    private ListExpressionWrapper listExpression;

    public ListInputBuilderDialog(Shell parentShell, ListExpressionWrapper listExpression) {
        super(parentShell);
        this.listExpression = listExpression.clone();
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button btnInsert = this.createButton(parent, 100, StringConstants.DIA_BTN_INSERT, true);
        btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ListInputBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                ConstantExpressionWrapper newExpression = new ConstantExpressionWrapper("", (ASTNodeWrapper)ListInputBuilderDialog.this.listExpression);
                if (selectionIndex < 0 || selectionIndex >= ListInputBuilderDialog.this.listExpression.getExpressions().size()) {
                    ListInputBuilderDialog.this.listExpression.addExpression(newExpression);
                    ++selectionIndex;
                } else {
                    ListInputBuilderDialog.this.listExpression.addExpression(newExpression, selectionIndex);
                }
                ListInputBuilderDialog.this.tableViewer.refresh();
                ListInputBuilderDialog.this.tableViewer.getTable().setSelection(selectionIndex);
            }
        });
        Button btnRemove = this.createButton(parent, 200, StringConstants.DIA_BTN_REMOVE, false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ListInputBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                if (selectionIndex < 0 || selectionIndex >= ListInputBuilderDialog.this.listExpression.getExpressions().size()) {
                    return;
                }
                ListInputBuilderDialog.this.listExpression.removeExpression(selectionIndex);
                ListInputBuilderDialog.this.tableViewer.refresh();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    @Override
    public ListExpressionWrapper getReturnValue() {
        return this.listExpression;
    }

    @Override
    public String getDialogTitle() {
        return StringConstants.DIA_TITLE_LIST_INPUT;
    }

    @Override
    protected void addTableColumns() {
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnNo = tableViewerColumnNo.getColumn();
        tblclmnColumnNo.setText(StringConstants.DIA_COL_NO);
        tblclmnColumnNo.setWidth(40);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof ExpressionWrapper) {
                    return String.valueOf(ListInputBuilderDialog.this.listExpression.getExpressions().indexOf(element) + 1);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(StringConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes));
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnValue = tableViewerColumnValue.getColumn();
        tblclmnNewColumnValue.setText(StringConstants.DIA_COL_VALUE);
        tblclmnNewColumnValue.setWidth(170);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.listExpression.getExpressions());
        this.tableViewer.refresh();
    }
}

