/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class KeysInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Keys);
    private MethodCallExpressionWrapper methodCallExpression;
    private ArgumentListExpressionWrapper argumentListExpression;

    public KeysInputBuilderDialog(Shell parentShell, MethodCallExpressionWrapper methodCallExpression) {
        super(parentShell);
        this.methodCallExpression = methodCallExpression.clone();
        this.argumentListExpression = this.methodCallExpression.getArguments();
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createInsertButton(parent);
        this.createRemoveButton(parent);
        super.createButtonsForButtonBar(parent);
    }

    private void createRemoveButton(Composite parent) {
        Button btnRemove = this.createButton(parent, 200, StringConstants.DELETE, false);
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = KeysInputBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                if (index >= 0 && index < KeysInputBuilderDialog.this.argumentListExpression.getExpressions().size()) {
                    KeysInputBuilderDialog.this.argumentListExpression.removeExpression(index);
                    KeysInputBuilderDialog.this.tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createInsertButton(Composite parent) {
        Button btnInsert = this.createButton(parent, 100, StringConstants.INSERT, true);
        btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = KeysInputBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                ExpressionWrapper newExpression = (ExpressionWrapper)InputValueType.Key.getNewValue(KeysInputBuilderDialog.this.argumentListExpression);
                if (selectionIndex < 0 || selectionIndex >= KeysInputBuilderDialog.this.argumentListExpression.getExpressions().size()) {
                    KeysInputBuilderDialog.this.argumentListExpression.addExpression(newExpression);
                    KeysInputBuilderDialog.this.tableViewer.getTable().setSelection(KeysInputBuilderDialog.this.argumentListExpression.getExpressions().size() - 1);
                } else {
                    KeysInputBuilderDialog.this.argumentListExpression.addExpression(newExpression, selectionIndex);
                    KeysInputBuilderDialog.this.tableViewer.getTable().setSelection(selectionIndex + 1);
                }
                KeysInputBuilderDialog.this.tableViewer.refresh();
            }
        });
    }

    @Override
    public MethodCallExpressionWrapper getReturnValue() {
        return this.methodCallExpression;
    }

    @Override
    public String getDialogTitle() {
        return StringConstants.KEYS_BUILDER_DIALOG_TITLE;
    }

    @Override
    protected void addTableColumns() {
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnNo = tableViewerColumnNo.getColumn();
        tblclmnColumnNo.setWidth(40);
        tblclmnColumnNo.setText(StringConstants.NO_);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof ExpressionWrapper) {
                    return String.valueOf(KeysInputBuilderDialog.this.argumentListExpression.getExpressions().indexOf(element) + 1);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnValueType = tableViewerColumnValueType.getColumn();
        tblclmnNewColumnValueType.setWidth(200);
        tblclmnNewColumnValueType.setText(StringConstants.KEYS_BUILDER_TABLE_COLUMN_TYPE_LABEL);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes));
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnValue = tableViewerColumnValue.getColumn();
        tblclmnNewColumnValue.setWidth(200);
        tblclmnNewColumnValue.setText(StringConstants.VALUE);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.argumentListExpression.getExpressions());
        this.tableViewer.refresh();
    }
}

