/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.statements.CatchStatementWrapper;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CatchInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private CatchStatementWrapper catchStatement;

    public CatchInputBuilderDialog(Shell parentShell, CatchStatementWrapper catchStatement) {
        super(parentShell);
        this.catchStatement = catchStatement.clone();
    }

    @Override
    public CatchStatementWrapper getReturnValue() {
        return this.catchStatement;
    }

    @Override
    public String getDialogTitle() {
        return StringConstants.DIA_TITLE_CATCH_INPUT;
    }

    @Override
    protected void addTableColumns() {
        this.addTableColumExceptionType();
        this.addTableColumnVariableName();
    }

    private void addTableColumExceptionType() {
        TableViewerColumn tableViewerColumnExeptionType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnExeptionType.getColumn().setText(StringConstants.DIA_COL_EXCEPTION_TYPE);
        tableViewerColumnExeptionType.getColumn().setWidth(200);
        tableViewerColumnExeptionType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == CatchInputBuilderDialog.this.catchStatement && CatchInputBuilderDialog.this.catchStatement.getExceptionType() != null) {
                    return CatchInputBuilderDialog.this.catchStatement.getExceptionType().getNameWithoutPackage();
                }
                return "";
            }
        });
        tableViewerColumnExeptionType.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected Object getValue(Object element) {
                return super.getValue(CatchInputBuilderDialog.this.catchStatement.getExceptionType());
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(CatchInputBuilderDialog.this.catchStatement.getExceptionType(), value);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element == CatchInputBuilderDialog.this.catchStatement && CatchInputBuilderDialog.this.catchStatement.getExceptionType() != null && super.canEdit(CatchInputBuilderDialog.this.catchStatement.getExceptionType());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(CatchInputBuilderDialog.this.catchStatement.getExceptionType());
            }
        });
    }

    private void addTableColumnVariableName() {
        TableViewerColumn tableViewerVariable = new TableViewerColumn(this.tableViewer, 0);
        tableViewerVariable.getColumn().setText(StringConstants.DIA_COL_VARIABLE_NAME);
        tableViewerVariable.getColumn().setWidth(200);
        tableViewerVariable.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == CatchInputBuilderDialog.this.catchStatement && CatchInputBuilderDialog.this.catchStatement.getVariableName() != null) {
                    return CatchInputBuilderDialog.this.catchStatement.getVariableName();
                }
                return "";
            }
        });
        tableViewerVariable.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (value instanceof String) {
                    CatchInputBuilderDialog.this.catchStatement.setVariableName((String)value);
                    this.getViewer().refresh();
                }
            }

            protected Object getValue(Object element) {
                return CatchInputBuilderDialog.this.catchStatement.getVariableName();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)CatchInputBuilderDialog.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return element == CatchInputBuilderDialog.this.catchStatement && CatchInputBuilderDialog.this.catchStatement.getVariable() != null && CatchInputBuilderDialog.this.catchStatement.getVariableName() != null;
            }
        });
    }

    @Override
    public void setInput() {
        ArrayList<CatchStatementWrapper> expressionList = new ArrayList<CatchStatementWrapper>();
        expressionList.add(this.catchStatement);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(expressionList);
        this.tableViewer.refresh();
    }
}

