/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.ast.editors.OperationComboBoxCellEditor;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.composer.testcase.groovy.ast.TokenWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstContentProviderAdapter;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BinaryBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private static final String OPERATOR_LABEL = "Operator";
    private static final String RIGHT_EXPRESSION_LABEL = "Right Expression";
    private static final String LEFT_EXPRESSION_LABEL = "Left Expression";
    private static final InputValueType[] defaultValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Binary);
    private BinaryExpressionWrapper binaryExpressionWrapper;

    public BinaryBuilderDialog(Shell parentShell, BinaryExpressionWrapper binaryExpressionWrapper) {
        super(parentShell);
        this.binaryExpressionWrapper = binaryExpressionWrapper.clone();
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new AstContentProviderAdapter(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == BinaryBuilderDialog.this.binaryExpressionWrapper) {
                    if (BinaryBuilderDialog.this.binaryExpressionWrapper.getRightExpression() == null) {
                        return new Object[]{BinaryBuilderDialog.this.binaryExpressionWrapper.getLeftExpression()};
                    }
                    return new Object[]{BinaryBuilderDialog.this.binaryExpressionWrapper.getLeftExpression(), BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation(), BinaryBuilderDialog.this.binaryExpressionWrapper.getRightExpression()};
                }
                return new Object[0];
            }
        });
        this.tableViewer.setInput((Object)this.binaryExpressionWrapper);
    }

    @Override
    protected void addTableColumns() {
        TableViewerColumn tableViewerColumnObject = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnObject.getColumn().setWidth(100);
        tableViewerColumnObject.getColumn().setText(StringConstants.DIA_COL_OBJ);
        tableViewerColumnObject.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getLeftExpression()) {
                    return BinaryBuilderDialog.LEFT_EXPRESSION_LABEL;
                }
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getRightExpression()) {
                    return BinaryBuilderDialog.RIGHT_EXPRESSION_LABEL;
                }
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    return BinaryBuilderDialog.OPERATOR_LABEL;
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.getColumn().setText(StringConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, defaultValueTypes){

            @Override
            protected boolean canEdit(Object element) {
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    return false;
                }
                return super.canEdit(element);
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.getColumn().setText(StringConstants.DIA_COL_VALUE);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    return BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation().getText();
                }
                return super.getText(element);
            }
        });
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected CellEditor getCellEditor(Object element) {
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    return new OperationComboBoxCellEditor((Composite)this.getViewer().getControl());
                }
                return super.getCellEditor(element);
            }

            @Override
            protected Object getValue(Object element) {
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    return BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation();
                }
                return super.getValue(element);
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element == BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    return true;
                }
                return super.canEdit(element);
            }

            @Override
            protected void setValue(Object element, Object value) {
                if (element != BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation()) {
                    super.setValue(element, value);
                    return;
                }
                if (value instanceof TokenWrapper && !StringUtils.equals((String)BinaryBuilderDialog.this.binaryExpressionWrapper.getOperation().getText(), (String)((TokenWrapper)value).getText())) {
                    BinaryBuilderDialog.this.binaryExpressionWrapper.setOperation((TokenWrapper)value);
                    this.getViewer().refresh();
                }
            }
        });
    }

    @Override
    public String getDialogTitle() {
        return StringConstants.DIA_TITLE_BINARY_INPUT;
    }

    @Override
    public BinaryExpressionWrapper getReturnValue() {
        return this.binaryExpressionWrapper;
    }
}

