/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.surround.LocalDeclarationAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.CodeAnalyzer;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

public class SurroundWithAnalyzer
extends CodeAnalyzer {
    private VariableDeclaration[] fLocals;
    private boolean fSurroundWithTryCatch;

    public SurroundWithAnalyzer(ICompilationUnit cunit, Selection selection, boolean surroundWithTryCatch) throws CoreException {
        super(cunit, selection, false);
        this.fSurroundWithTryCatch = surroundWithTryCatch;
    }

    public ASTNode[] getValidSelectedNodes() {
        if (this.hasSelectedNodes()) {
            return this.internalGetSelectedNodes().toArray(new ASTNode[this.internalGetSelectedNodes().size()]);
        }
        return new Statement[0];
    }

    public VariableDeclaration[] getAffectedLocals() {
        return this.fLocals;
    }

    public BodyDeclaration getEnclosingBodyDeclaration() {
        ASTNode node = this.getFirstSelectedNode();
        if (node == null) {
            return null;
        }
        return (BodyDeclaration)ASTNodes.getParent(node, BodyDeclaration.class);
    }

    @Override
    protected boolean handleSelectionEndsIn(ASTNode node) {
        return true;
    }

    @Override
    public void endVisit(CompilationUnit node) {
        this.postProcessSelectedNodes(this.internalGetSelectedNodes());
        ASTNode enclosingNode = null;
        if (!this.getStatus().hasFatalError()) {
            if (!this.hasSelectedNodes()) {
                Block block;
                Message[] messages;
                ASTNode coveringNode = this.getLastCoveringNode();
                if (coveringNode instanceof Block && (messages = ASTNodes.getMessages((ASTNode)(block = (Block)coveringNode), 0)).length > 0) {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_compile_errors, JavaStatusContext.create((ITypeRoot)this.getCompilationUnit(), (ASTNode)block));
                } else {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_doesNotCover);
                }
            } else {
                boolean isValidEnclosingNode;
                enclosingNode = SurroundWithAnalyzer.getEnclosingNode(this.getFirstSelectedNode());
                boolean bl = isValidEnclosingNode = enclosingNode instanceof MethodDeclaration || enclosingNode instanceof Initializer;
                if (this.fSurroundWithTryCatch) {
                    boolean bl2 = isValidEnclosingNode = isValidEnclosingNode || enclosingNode instanceof MethodReference || enclosingNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY;
                }
                if (!isValidEnclosingNode) {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_doesNotContain);
                } else {
                    if (!this.validSelectedNodes()) {
                        this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_onlyStatements);
                    }
                    this.fLocals = LocalDeclarationAnalyzer.perform(enclosingNode, this.getSelection());
                }
            }
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(SuperConstructorInvocation node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2) {
            this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_cannotHandleSuper, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(ConstructorInvocation node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2) {
            this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_cannotHandleThis, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
        }
        super.endVisit(node);
    }

    protected void postProcessSelectedNodes(List<ASTNode> selectedNodes) {
        ASTNode node;
        if (selectedNodes == null || selectedNodes.size() == 0) {
            return;
        }
        if (selectedNodes.size() == 1 && (node = selectedNodes.get(0)) instanceof Expression && node.getParent() instanceof ExpressionStatement) {
            selectedNodes.clear();
            selectedNodes.add(node.getParent());
        }
    }

    private boolean validSelectedNodes() {
        ASTNode[] nodes = this.getSelectedNodes();
        int i = 0;
        while (i < nodes.length) {
            ASTNode node = nodes[i];
            boolean isValidNode = node instanceof Statement;
            if (this.fSurroundWithTryCatch) {
                boolean bl = isValidNode = isValidNode || node instanceof MethodReference || node.getLocationInParent() == LambdaExpression.BODY_PROPERTY;
            }
            if (!isValidNode) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ASTNode getEnclosingNode(ASTNode firstSelectedNode) {
        ASTNode enclosingNode;
        enclosingNode = firstSelectedNode instanceof MethodReference ? firstSelectedNode : ((enclosingNode = ASTResolving.findEnclosingLambdaExpression(firstSelectedNode)) != null ? ((LambdaExpression)enclosingNode).getBody() : ASTNodes.getParent(firstSelectedNode, BodyDeclaration.class));
        return enclosingNode;
    }
}

