/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testdata;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testdata.InternalDataColumnEntity;
import com.kms.katalon.entity.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

public class DataFileEntity
extends FileEntity {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_DATA_SOURCE_URL = "";
    private static final String ID_PREFIX = "DF";
    private DataFileDriverType driver;
    private String dataSourceUrl;
    private String sheetName;
    private String dataFileGUID;
    private boolean isInternalPath;
    private List<InternalDataColumnEntity> internalDataColumns;
    private List<List<Object>> data;
    private List<List<Object>> encriptData;
    private boolean containsHeaders;
    private String csvSeperator;
    private boolean usingGlobalDBSetting;
    private boolean secureUserAccount;
    private String user;
    private String password;
    private String query;

    public DataFileDriverType getDriver() {
        if (this.driver == null) {
            this.driver = DataFileDriverType.ExcelFile;
        }
        return this.driver;
    }

    public void setDriver(DataFileDriverType driver) {
        this.driver = driver;
    }

    public String getDataSourceUrl() {
        if (this.dataSourceUrl == null) {
            this.dataSourceUrl = DEFAULT_DATA_SOURCE_URL;
        }
        return this.dataSourceUrl;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    public String getSheetName() {
        if (this.sheetName == null) {
            this.sheetName = DEFAULT_DATA_SOURCE_URL;
        }
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getDataFileGUID() {
        if (this.dataFileGUID == null) {
            this.dataFileGUID = Util.generateGuid();
        }
        return this.dataFileGUID;
    }

    public void setDataFileGUID(String dataFileGUID) {
        this.dataFileGUID = dataFileGUID;
    }

    @Override
    public DataFileEntity clone() {
        DataFileEntity clonedDataFile = (DataFileEntity)super.clone();
        clonedDataFile.setDataFileGUID(this.dataFileGUID);
        return clonedDataFile;
    }

    public List<List<Object>> getData() {
        if (this.data == null) {
            this.data = new ArrayList<List<Object>>();
        }
        return this.data;
    }

    public void setData(List<List<Object>> data) {
        this.data = data;
    }

    public List<InternalDataColumnEntity> getInternalDataColumns() {
        if (this.internalDataColumns == null) {
            this.internalDataColumns = new ArrayList<InternalDataColumnEntity>();
        }
        return this.internalDataColumns;
    }

    public void setInternalDataColumns(List<InternalDataColumnEntity> internalDataColumns) {
        this.internalDataColumns = internalDataColumns;
    }

    public String getTableDataName() {
        return ID_PREFIX + this.getId();
    }

    public String buildDataFileEntityId() {
        return ID_PREFIX + String.format("%010d", this.getId());
    }

    public String buildDataFileEntityId(long id) {
        return ID_PREFIX + String.format("%010d", id);
    }

    public boolean getIsInternalPath() {
        return this.isInternalPath;
    }

    public void setIsInternalPath(boolean isInternalPath) {
        this.isInternalPath = isInternalPath;
    }

    public static String getTestDataFileExtension() {
        return ".dat";
    }

    @Override
    public String getFileExtension() {
        return DataFileEntity.getTestDataFileExtension();
    }

    public List<List<Object>> getEncriptData() {
        return this.encriptData;
    }

    public void setEncriptData(List<List<Object>> data) {
        this.encriptData = data;
    }

    public String getCsvSeperator() {
        if (this.csvSeperator == null) {
            this.csvSeperator = DEFAULT_DATA_SOURCE_URL;
        }
        return this.csvSeperator;
    }

    public void setCsvSeperator(String csvSeperator) {
        this.csvSeperator = csvSeperator;
    }

    public boolean isContainsHeaders() {
        return this.containsHeaders;
    }

    public void setContainsHeaders(boolean containsHeaders) {
        this.containsHeaders = containsHeaders;
    }

    public boolean isUsingGlobalDBSetting() {
        return this.usingGlobalDBSetting;
    }

    public void setUsingGlobalDBSetting(boolean usingGlobalDBSetting) {
        this.usingGlobalDBSetting = usingGlobalDBSetting;
    }

    public boolean isSecureUserAccount() {
        return this.secureUserAccount;
    }

    public void setSecureUserAccount(boolean secureUserAccount) {
        this.secureUserAccount = secureUserAccount;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuery() {
        if (this.query == null) {
            this.query = DEFAULT_DATA_SOURCE_URL;
        }
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEquals = super.equals(obj);
        if (!(obj instanceof DataFileEntity)) {
            return false;
        }
        DataFileEntity that = (DataFileEntity)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.getDataFileGUID(), (Object)that.getDataFileGUID()).append((Object)this.getDriver(), (Object)that.getDriver()).append((Object)this.getDateCreated(), (Object)that.getDateCreated()).append((Object)this.getDateModified(), (Object)that.getDateModified()).append((Object)this.getDescription(), (Object)that.getDescription()).append(this.isContainsHeaders(), that.isContainsHeaders()).append((Object)this.getDataSourceUrl(), (Object)that.getDataSourceUrl()).append((Object)this.getSheetName(), (Object)that.getSheetName()).append((Object)this.getCsvSeperator(), (Object)that.getCsvSeperator()).append(this.getIsInternalPath(), that.getIsInternalPath());
        if (this.getIsInternalPath() && equalsBuilder.isEquals()) {
            equalsBuilder.append(this.getData(), that.getData());
        }
        equalsBuilder.append(this.isUsingGlobalDBSetting(), that.isUsingGlobalDBSetting()).append(this.isSecureUserAccount(), that.isSecureUserAccount()).append((Object)this.getUser(), (Object)that.getUser()).append((Object)this.getPassword(), (Object)that.getPassword()).append((Object)this.getQuery(), (Object)that.getQuery());
        return isEquals && equalsBuilder.isEquals();
    }

    public static enum DataFileDriverType {
        ExcelFile("Excel File"),
        CSV("CSV File"),
        DBData("Database Data"),
        InternalData("Internal Data");

        private String text;

        private DataFileDriverType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public String value() {
            return this.name();
        }

        public static DataFileDriverType fromValue(String v) {
            int i = 0;
            while (i < DataFileDriverType.values().length) {
                if (DataFileDriverType.values()[i].toString().equals(v)) {
                    return DataFileDriverType.values()[i];
                }
                ++i;
            }
            return DataFileDriverType.valueOf(v);
        }

        public static String[] stringValues() {
            String[] stringValues = new String[DataFileDriverType.values().length];
            int i = 0;
            while (i < DataFileDriverType.values().length) {
                stringValues[i] = DataFileDriverType.values()[i].toString();
                ++i;
            }
            return stringValues;
        }
    }
}

