/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testcase;

import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.List;

public class TestCaseEntity
extends IntegratedFileEntity {
    private static final long serialVersionUID = 1L;
    private String comment = "";
    private List<DataFileEntity> dataFiles;
    private List<String> dataFileLocations;
    private List<VariableEntity> variables = new ArrayList<VariableEntity>();
    private String testCaseGuid;
    private byte[] scriptContents;

    public TestCaseEntity() {
        this.dataFiles = new ArrayList<DataFileEntity>();
        this.dataFileLocations = new ArrayList<String>();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTestCaseGuid() {
        return this.testCaseGuid;
    }

    public void setTestCaseGuid(String testCaseGuid) {
        this.testCaseGuid = testCaseGuid;
    }

    @Override
    public TestCaseEntity clone() {
        TestCaseEntity newTestCase = new TestCaseEntity();
        newTestCase.setParentFolder(this.getParentFolder());
        newTestCase.setProject(this.getProject());
        newTestCase.setName(this.getName());
        newTestCase.setComment(this.getComment());
        newTestCase.setTag(this.getTag());
        newTestCase.setDescription(this.getDescription());
        newTestCase.getDataFileLocations().clear();
        newTestCase.getDataFiles().clear();
        for (DataFileEntity dataFile : this.getDataFiles()) {
            newTestCase.getDataFiles().add(dataFile);
            newTestCase.getDataFileLocations().add(dataFile.getRelativePath());
        }
        newTestCase.getVariables().clear();
        for (VariableEntity variable : this.getVariables()) {
            newTestCase.getVariables().add(variable.clone());
        }
        newTestCase.getIntegratedEntities().clear();
        for (IntegratedEntity integratedEntity : this.getIntegratedEntities()) {
            newTestCase.getIntegratedEntities().add(integratedEntity);
        }
        newTestCase.setScriptContents(this.getScriptContents());
        newTestCase.setTestCaseGuid(Util.generateGuid());
        return newTestCase;
    }

    public List<String> getDataFileLocations() {
        return this.dataFileLocations;
    }

    public void setDataFileLocations(List<String> dataFileLocations) {
        this.dataFileLocations = dataFileLocations;
    }

    @Override
    public String getFileExtension() {
        return TestCaseEntity.getTestCaseFileExtension();
    }

    public static String getTestCaseFileExtension() {
        return ".tc";
    }

    public List<DataFileEntity> getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(List<DataFileEntity> dataFiles) {
        this.dataFiles = dataFiles;
    }

    public byte[] getScriptContents() {
        return this.scriptContents;
    }

    public void setScriptContents(byte[] scriptContents) {
        this.scriptContents = scriptContents;
    }

    public List<VariableEntity> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableEntity> variables) {
        this.variables = variables;
    }

    public void addVariables(List<VariableEntity> variablesToAdd) {
        this.variables.addAll(variablesToAdd);
    }
}

