/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.repository;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;

public class WebElementEntity
extends FileEntity {
    private static final long serialVersionUID = 1L;
    public static final String ref_element = "ref_element";
    public static final String defaultElementGUID = "00000000-0000-0000-0000-000000000000";
    public static final String DEFAULT_EMPTY_STRING = "";
    public static final String REF_ELEMENT_IS_SHADOW_ROOT = "ref_element_is_shadow_root";
    private String elementGuidId;
    private List<WebElementPropertyEntity> webElementProperties;
    private List<WebElementXpathEntity> webElementXpaths;
    private String imagePath;
    private boolean useRalativeImagePath;
    private WebElementSelectorMethod selectorMethod = WebElementSelectorMethod.BASIC;
    private Map<WebElementSelectorMethod, String> selectorCollection;

    public WebElementEntity() {
        this.webElementProperties = new ArrayList<WebElementPropertyEntity>(0);
        this.webElementXpaths = new ArrayList<WebElementXpathEntity>(0);
        this.setSelectorCollection(new HashMap<WebElementSelectorMethod, String>());
        this.elementGuidId = defaultElementGUID;
        this.name = DEFAULT_EMPTY_STRING;
        this.description = DEFAULT_EMPTY_STRING;
        this.selectorCollection = new HashMap<WebElementSelectorMethod, String>();
    }

    public String getElementGuidId() {
        return this.elementGuidId;
    }

    public void setElementGuidId(String elementGuidId) {
        this.elementGuidId = elementGuidId;
    }

    public List<WebElementPropertyEntity> getWebElementProperties() {
        return this.webElementProperties;
    }

    public void setWebElementProperties(List<WebElementPropertyEntity> webElementProperties) {
        this.webElementProperties = webElementProperties;
    }

    public List<WebElementXpathEntity> getWebElementXpaths() {
        return this.webElementXpaths;
    }

    public void setWebElementXpaths(List<WebElementXpathEntity> webElementXpaths) {
        this.webElementXpaths = webElementXpaths;
    }

    @Override
    public WebElementEntity clone() {
        WebElementEntity newWebElement = (WebElementEntity)super.clone();
        newWebElement.setElementGuidId(UUID.randomUUID().toString());
        newWebElement.setName(this.getName());
        newWebElement.setParentFolder(this.getParentFolder());
        newWebElement.setProject(this.getProject());
        newWebElement.setDescription(this.getDescription());
        newWebElement.getWebElementProperties().clear();
        for (WebElementPropertyEntity webElementProperty : this.getWebElementProperties()) {
            newWebElement.getWebElementProperties().add(webElementProperty.clone());
        }
        newWebElement.getWebElementXpaths().clear();
        for (WebElementXpathEntity webElementXpath : this.getWebElementXpaths()) {
            newWebElement.getWebElementXpaths().add(webElementXpath.clone());
        }
        newWebElement.setImagePath(this.getImagePath());
        newWebElement.setUseRalativeImagePath(this.getUseRalativeImagePath());
        newWebElement.setSelectorMethod(this.getSelectorMethod());
        newWebElement.setSelectorCollection(new HashMap<WebElementSelectorMethod, String>(this.getSelectorCollection()));
        return newWebElement;
    }

    public static String getWebElementFileExtension() {
        return ".rs";
    }

    @Override
    public String getFileExtension() {
        return WebElementEntity.getWebElementFileExtension();
    }

    @Override
    public String getRelativePathForUI() {
        if (this.parentFolder != null) {
            return String.valueOf(this.parentFolder.getRelativePath()) + File.separator + this.name;
        }
        return DEFAULT_EMPTY_STRING;
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEquals = super.equals(obj);
        if (!(obj instanceof WebElementEntity)) {
            return false;
        }
        WebElementEntity that = (WebElementEntity)obj;
        isEquals = isEquals && new EqualsBuilder().append(this.getWebElementProperties(), that.getWebElementProperties()).isEquals() && new EqualsBuilder().append(this.getWebElementXpaths(), that.getWebElementXpaths()).isEquals();
        return isEquals;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public boolean getUseRalativeImagePath() {
        return this.useRalativeImagePath;
    }

    public void setUseRalativeImagePath(boolean useRalativeImagePath) {
        this.useRalativeImagePath = useRalativeImagePath;
    }

    public WebElementPropertyEntity getProperty(String propertyName) {
        Optional<WebElementPropertyEntity> optResult = this.getWebElementProperties().stream().filter(p -> p.getName().equals(propertyName) && WebElementPropertyEntity.MATCH_CONDITION.EQUAL.toString().equals(p.getMatchCondition())).findFirst();
        return optResult.isPresent() ? optResult.get() : null;
    }

    public String getPropertyValue(String propertyName) {
        WebElementPropertyEntity prop = this.getProperty(propertyName);
        return prop != null ? prop.getValue() : DEFAULT_EMPTY_STRING;
    }

    public WebElementXpathEntity getXpath(String xpathName) {
        Optional<WebElementXpathEntity> optResult = this.getWebElementXpaths().stream().filter(p -> p.getName().equals(xpathName) && WebElementPropertyEntity.MATCH_CONDITION.EQUAL.toString().equals(p.getMatchCondition())).findFirst();
        return optResult.isPresent() ? optResult.get() : null;
    }

    public String getXpathValue(String xpathName) {
        WebElementXpathEntity prop = this.getXpath(xpathName);
        return prop != null ? prop.getValue() : DEFAULT_EMPTY_STRING;
    }

    public WebElementSelectorMethod getSelectorMethod() {
        return this.selectorMethod;
    }

    public void setSelectorMethod(WebElementSelectorMethod selectorMethod) {
        this.selectorMethod = selectorMethod;
    }

    public Map<WebElementSelectorMethod, String> getSelectorCollection() {
        return this.selectorCollection;
    }

    public void setSelectorCollection(Map<WebElementSelectorMethod, String> selectorCollection) {
        this.selectorCollection = selectorCollection;
    }

    public void setSelectorValue(WebElementSelectorMethod selectorMethod, String selectorValue) {
        this.selectorCollection.put(selectorMethod, selectorValue);
    }
}

