/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.file;

import com.kms.katalon.entity.file.FileEntity;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class SystemFileEntity
extends FileEntity {
    private static final long serialVersionUID = 6098402482835020979L;
    private File file;

    public SystemFileEntity(File file) {
        this.setFile(file);
    }

    @Override
    public String getFileExtension() {
        return "." + FilenameUtils.getExtension((String)this.file.getName());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File newFile) {
        this.file = newFile;
        this.name = FilenameUtils.getName((String)newFile.getName());
    }

    @Override
    public String getLocation() {
        if (this.parentFolder != null) {
            return String.valueOf(this.parentFolder.getLocation()) + File.separator + this.name;
        }
        if (this.project != null) {
            return String.valueOf(this.project.getFolderLocation()) + File.separator + this.name;
        }
        return String.valueOf(this.name) + this.getFileExtension();
    }

    @Override
    public String getRelativePath() {
        if (this.parentFolder != null) {
            return String.valueOf(this.parentFolder.getRelativePath()) + File.separator + this.name;
        }
        return this.name;
    }

    @Override
    public String getRelativePathForUI() {
        if (this.parentFolder != null) {
            return String.valueOf(this.parentFolder.getRelativePath()) + File.separator + this.name;
        }
        return this.name;
    }

    @Override
    public String getIdForDisplay() {
        return this.getRelativePathForUI().replace(File.separator, "/");
    }
}

