/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.process.AbstractProcess;
import org.zeroturnaround.process.SystemProcess;

public abstract class CompositeProcess
extends AbstractProcess {
    protected final List<? extends SystemProcess> children;

    public CompositeProcess(List<? extends SystemProcess> children) {
        this.children = children;
    }

    @Override
    public String getDescription() {
        ArrayList<String> result = new ArrayList<String>();
        for (SystemProcess systemProcess : this.children) {
            result.add(systemProcess.toString());
        }
        return ((Object)result).toString();
    }

    @Override
    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        for (SystemProcess systemProcess : this.children) {
            result.add(systemProcess.toString());
        }
        return this.getClass().getSimpleName() + ((Object)result).toString();
    }

    protected static void invokeDestroy(SystemProcess killer, boolean forceful) throws UnsupportedOperationException, IOException, InterruptedException {
        if (forceful) {
            killer.destroyForcefully();
        } else {
            killer.destroyGracefully();
        }
    }
}

