/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.eclipse.jdt.groovy.search.VariableScope;

public class TypeLookupResult {
    public final TypeConfidence confidence;
    public final ClassNode declaringType;
    public final ClassNode type;
    public final ASTNode declaration;
    public final VariableScope scope;
    public final String extraDoc;
    public boolean isGroovy;
    public AnnotationNode enclosingAnnotation;
    public BinaryExpression enclosingAssignment;

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope) {
        this(type, declaringType, declaration, confidence, scope, null);
    }

    public TypeLookupResult(ClassNode type, ClassNode declaringType, ASTNode declaration, TypeConfidence confidence, VariableScope scope, String extraDoc) {
        this.confidence = confidence;
        this.type = type;
        this.declaringType = declaringType;
        this.declaration = declaration;
        this.scope = scope;
        this.extraDoc = extraDoc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeConfidence {
        EXACT(0),
        POTENTIAL(1),
        INFERRED(2),
        LOOSELY_INFERRED(3),
        UNKNOWN(4);

        private final int val;

        private TypeConfidence(int val) {
            this.val = val;
        }

        public static TypeConfidence findLessPrecise(TypeConfidence left, TypeConfidence right) {
            return left.val > right.val ? left : right;
        }

        public boolean isLessPreciseThan(TypeConfidence other) {
            return this.val > other.val;
        }
    }
}

