/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AssignmentStorer;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferencingVisitorWithRequestor
extends ClassCodeVisitorSupport {
    public boolean DEBUG = false;
    private static final String[] NO_PARAMS = new String[0];
    private static final Parameter[] NO_PARAMETERS = Parameter.EMPTY_ARRAY;
    private static final Set<String> dgmClosureMethods = new HashSet<String>();
    private static final Set<String> dgmClosureIdentityMethods;
    private static final Set<String> dgmClosureMaybeMap;
    private static final Map<String, ClassNode> dgmClosureMethodsMap;
    private final GroovyCompilationUnit unit;
    private final Stack<VariableScope> scopes;
    private final ITypeLookup[] lookups;
    private ITypeRequestor requestor;
    private IJavaElement enclosingElement;
    private ASTNode enclosingDeclarationNode;
    private BinaryExpression enclosingAssignment;
    private ConstructorCallExpression enclosingConstructorCall;
    private Stack<ASTNode> completeExpressionStack;
    private Stack<ClassNode> primaryTypeStack;
    private Stack<Tuple> dependentDeclarationStack;
    private Stack<ClassNode> dependentTypeStack;
    private LinkedList<Map<ClosureExpression, ClassNode>> closureTypes = new LinkedList();
    private final JDTResolver resolver;
    private final AssignmentStorer assignmentStorer = new AssignmentStorer();
    private ClassNode inferredStaticMethodType;
    private boolean needToFixStaticMethodType;
    private Map<Variable, Map<String, ClassNode>> localMapProperties = new HashMap<Variable, Map<String, ClassNode>>();
    private Variable currentMapVariable;
    private static final String SANITY_CHECK_MESSAGE = "Inferencing engine in invalid state after visitor completed.  %s stack should be empty after visit completed.";

    static {
        dgmClosureMethods.add("find");
        dgmClosureMethods.add("each");
        dgmClosureMethods.add("reverseEach");
        dgmClosureMethods.add("eachWithIndex");
        dgmClosureMethods.add("unique");
        dgmClosureMethods.add("every");
        dgmClosureMethods.add("collect");
        dgmClosureMethods.add("collectEntries");
        dgmClosureMethods.add("collectNested");
        dgmClosureMethods.add("collectMany");
        dgmClosureMethods.add("findAll");
        dgmClosureMethods.add("groupBy");
        dgmClosureMethods.add("groupEntriesBy");
        dgmClosureMethods.add("inject");
        dgmClosureMethods.add("count");
        dgmClosureMethods.add("countBy");
        dgmClosureMethods.add("findResult");
        dgmClosureMethods.add("findResults");
        dgmClosureMethods.add("grep");
        dgmClosureMethods.add("split");
        dgmClosureMethods.add("sum");
        dgmClosureMethods.add("any");
        dgmClosureMethods.add("flatten");
        dgmClosureMethods.add("findIndexOf");
        dgmClosureMethods.add("findIndexValues");
        dgmClosureMethods.add("findLastIndexOf");
        dgmClosureMethods.add("collectAll");
        dgmClosureMethods.add("min");
        dgmClosureMethods.add("max");
        dgmClosureMethods.add("eachPermutation");
        dgmClosureMethods.add("sort");
        dgmClosureMethods.add("withDefault");
        dgmClosureMethods.add("identity");
        dgmClosureMethods.add("times");
        dgmClosureMethods.add("upto");
        dgmClosureMethods.add("downto");
        dgmClosureMethods.add("step");
        dgmClosureMethods.add("eachFile");
        dgmClosureMethods.add("eachDir");
        dgmClosureMethods.add("eachFileRecurse");
        dgmClosureMethods.add("eachDirRecurse");
        dgmClosureMethods.add("traverse");
        dgmClosureIdentityMethods = new HashSet<String>();
        dgmClosureIdentityMethods.add("with");
        dgmClosureIdentityMethods.add("addShutdownHook");
        dgmClosureMaybeMap = new HashSet<String>();
        dgmClosureMaybeMap.add("any");
        dgmClosureMaybeMap.add("every");
        dgmClosureMaybeMap.add("each");
        dgmClosureMaybeMap.add("collect");
        dgmClosureMaybeMap.add("collectEntries");
        dgmClosureMaybeMap.add("findResult");
        dgmClosureMaybeMap.add("findResults");
        dgmClosureMaybeMap.add("findAll");
        dgmClosureMaybeMap.add("groupBy");
        dgmClosureMaybeMap.add("groupEntriesBy");
        dgmClosureMaybeMap.add("inject");
        dgmClosureMaybeMap.add("withDefault");
        dgmClosureMethodsMap = new HashMap<String, ClassNode>();
        dgmClosureMethodsMap.put("eachLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("splitEachLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("withObjectOutputStream", VariableScope.OBJECT_OUTPUT_STREAM);
        dgmClosureMethodsMap.put("withObjectInputStream", VariableScope.OBJECT_INPUT_STREAM);
        dgmClosureMethodsMap.put("withDataOutputStream", VariableScope.DATA_OUTPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withDataInputStream", VariableScope.DATA_INPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withOutputStream", VariableScope.OUTPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withInputStream", VariableScope.INPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withStream", VariableScope.OUTPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("metaClass", ClassHelper.METACLASS_TYPE);
        dgmClosureMethodsMap.put("eachFileMatch", VariableScope.FILE_CLASS_NODE);
        dgmClosureMethodsMap.put("eachDirMatch", VariableScope.FILE_CLASS_NODE);
        dgmClosureMethodsMap.put("withReader", VariableScope.BUFFERED_READER_CLASS_NODE);
        dgmClosureMethodsMap.put("withWriter", VariableScope.BUFFERED_WRITER_CLASS_NODE);
        dgmClosureMethodsMap.put("withWriterAppend", VariableScope.BUFFERED_WRITER_CLASS_NODE);
        dgmClosureMethodsMap.put("withPrintWriter", VariableScope.PRINT_WRITER_CLASS_NODE);
        dgmClosureMethodsMap.put("transformChar", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("transformLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("filterLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("eachMatch", VariableScope.STRING_CLASS_NODE);
    }

    TypeInferencingVisitorWithRequestor(GroovyCompilationUnit unit, ITypeLookup[] lookups) {
        this.unit = unit;
        ModuleNodeMapper.ModuleNodeInfo info = this.createModuleNode(unit);
        this.enclosingDeclarationNode = info != null ? info.module : null;
        this.resolver = info != null ? info.resolver : null;
        this.lookups = lookups;
        this.scopes = new Stack();
        this.completeExpressionStack = new Stack();
        this.primaryTypeStack = new Stack();
        this.dependentTypeStack = new Stack();
        this.dependentDeclarationStack = new Stack();
    }

    public void visitCompilationUnit(ITypeRequestor requestor) {
        block10: {
            if (this.enclosingDeclarationNode == null) {
                return;
            }
            this.requestor = requestor;
            this.enclosingElement = this.unit;
            VariableScope topLevelScope = new VariableScope(null, this.enclosingDeclarationNode, false);
            this.scopes.push(topLevelScope);
            ITypeLookup[] iTypeLookupArray = this.lookups;
            int n = this.lookups.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeLookup lookup = iTypeLookupArray[n2];
                if (lookup instanceof ITypeResolver) {
                    ((ITypeResolver)((Object)lookup)).setResolverInformation((ModuleNode)this.enclosingDeclarationNode, this.resolver);
                }
                lookup.initialize(this.unit, topLevelScope);
                ++n2;
            }
            try {
                this.visitPackage(((ModuleNode)this.enclosingDeclarationNode).getPackage());
                this.visitImports((ModuleNode)this.enclosingDeclarationNode);
                try {
                    IType[] types;
                    IType[] iTypeArray = types = this.unit.getTypes();
                    int n3 = types.length;
                    n = 0;
                    while (n < n3) {
                        IType type = iTypeArray[n];
                        this.visitJDT(type, requestor);
                        ++n;
                    }
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)e, (String)("Error getting types for " + this.unit.getElementName()));
                }
                this.scopes.pop();
            }
            catch (VisitCompleted visitCompleted) {
            }
            catch (Exception e) {
                Util.log((Throwable)e, (String)("Error in inferencing engine for " + this.unit.getElementName()));
                if (!this.DEBUG) break block10;
                System.err.println("Excpetion thrown from inferencing engine");
                e.printStackTrace();
            }
        }
        if (this.DEBUG) {
            this.postVisitSanityCheck();
        }
    }

    public void visitJDT(IType type, ITypeRequestor requestor) {
        IJavaElement oldEnclosing = this.enclosingElement;
        ASTNode oldEnclosingNode = this.enclosingDeclarationNode;
        this.enclosingElement = type;
        ClassNode node = this.findClassWithName(this.createName(type));
        if (node == null) {
            return;
        }
        try {
            try {
                this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)node, false));
                this.enclosingDeclarationNode = node;
                this.visitClassInternal(node);
                try {
                    IJavaElement[] iJavaElementArray = type.getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement child = iJavaElementArray[n2];
                        if (!type.isEnum() || !this.shouldFilterEnumMember(child)) {
                            switch (child.getElementType()) {
                                case 9: {
                                    this.visitJDT((IMethod)child, requestor);
                                    break;
                                }
                                case 8: {
                                    this.visitJDT((IField)child, requestor);
                                    break;
                                }
                                case 7: {
                                    this.visitJDT((IType)child, requestor);
                                    break;
                                }
                            }
                        }
                        ++n2;
                    }
                    if (!type.isEnum()) {
                        ConstructorNode defConstructor;
                        if (node.isScript()) {
                            for (FieldNode field : node.getFields()) {
                                if (field.getEnd() <= 0) continue;
                                if (field.getNameEnd() <= 0) {
                                    this.setNameLocation(field);
                                }
                                this.visitField(field);
                            }
                        }
                        if (!type.getMethod(type.getElementName(), NO_PARAMS).exists() && (defConstructor = this.findDefaultConstructor(node)) != null) {
                            this.visitConstructorOrMethod((MethodNode)defConstructor, true);
                        }
                    }
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)e, (String)("Error visiting children of " + type.getFullyQualifiedName()));
                }
            }
            catch (VisitCompleted vc) {
                if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                    throw vc;
                }
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
        finally {
            this.enclosingElement = oldEnclosing;
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.scopes.pop();
        }
    }

    private ConstructorNode findDefaultConstructor(ClassNode node) {
        List constructors = node.getDeclaredConstructors();
        for (ConstructorNode constructor : constructors) {
            if (constructor.getParameters() != null && constructor.getParameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private boolean shouldFilterEnumMember(IJavaElement child) {
        int type = child.getElementType();
        String name = child.getElementName();
        if (name.indexOf(36) >= 0) {
            return true;
        }
        return type == 9 ? (name.equals("next") || name.equals("previous")) && ((IMethod)child).getNumberOfParameters() == 0 : type == 9 && (name.equals("MIN_VALUE") || name.equals("MAX_VALUE"));
    }

    private String createName(IType type) {
        StringBuilder sb = new StringBuilder();
        while (type != null) {
            if (sb.length() > 0) {
                sb.insert(0, '$');
            }
            if (type instanceof SourceType && type.getElementName().length() < 1) {
                int count;
                try {
                    count = (Integer)ReflectionUtils.throwableGetPrivateField(SourceType.class, "localOccurrenceCount", (SourceType)type);
                }
                catch (Exception exception) {
                    count = type.getOccurrenceCount();
                }
                sb.insert(0, count);
            } else {
                sb.insert(0, type.getElementName());
            }
            type = (IType)type.getParent().getAncestor(7);
        }
        return sb.toString();
    }

    public void visitJDT(IField field, ITypeRequestor requestor) {
        MethodNode lazyMethod;
        FieldNode fieldNode;
        ASTNode oldEnclosingNode;
        IJavaElement oldEnclosing;
        block14: {
            oldEnclosing = this.enclosingElement;
            oldEnclosingNode = this.enclosingDeclarationNode;
            this.enclosingElement = field;
            this.requestor = requestor;
            fieldNode = this.findFieldNode(field);
            if (fieldNode == null) {
                return;
            }
            this.enclosingDeclarationNode = fieldNode;
            this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)fieldNode, fieldNode.isStatic()));
            try {
                try {
                    this.visitField(fieldNode);
                }
                catch (VisitCompleted vc) {
                    if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                        throw vc;
                    }
                    this.enclosingDeclarationNode = oldEnclosingNode;
                    this.enclosingElement = oldEnclosing;
                    this.scopes.pop();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.enclosingElement = oldEnclosing;
                this.scopes.pop();
                throw throwable;
            }
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.enclosingElement = oldEnclosing;
            this.scopes.pop();
        }
        if (this.isLazy(fieldNode) && (lazyMethod = this.getLazyMethod(field.getElementName())) != null) {
            this.enclosingDeclarationNode = lazyMethod;
            this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)lazyMethod, lazyMethod.isStatic()));
            try {
                try {
                    this.visitConstructorOrMethod(lazyMethod, lazyMethod instanceof ConstructorNode);
                }
                catch (VisitCompleted vc) {
                    if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                        throw vc;
                    }
                    this.scopes.pop();
                    this.enclosingElement = oldEnclosing;
                    this.enclosingDeclarationNode = oldEnclosingNode;
                }
            }
            finally {
                this.scopes.pop();
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void visitJDT(IMethod method, ITypeRequestor requestor) {
        IJavaElement oldEnclosing = this.enclosingElement;
        ASTNode oldEnclosingNode = this.enclosingDeclarationNode;
        this.enclosingElement = method;
        MethodNode methodNode = this.findMethodNode(method);
        if (methodNode == null) {
            return;
        }
        this.enclosingDeclarationNode = methodNode;
        this.requestor = requestor;
        this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)methodNode, methodNode.isStatic()));
        try {
            try {
                IJavaElement[] children;
                this.visitConstructorOrMethod(methodNode, method.isConstructor());
                IJavaElement[] iJavaElementArray = children = method.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    if (child.getElementType() == 7) {
                        this.visitJDT((IType)child, requestor);
                    }
                    ++n2;
                }
            }
            catch (VisitCompleted vc) {
                if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                    throw vc;
                }
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e, (String)("Exception visiting method " + method.getElementName() + " in class " + method.getParent().getElementName()));
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
            catch (Exception e) {
                Util.log((Throwable)e);
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.enclosingElement = oldEnclosing;
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.scopes.pop();
        }
    }

    private void visitClassInternal(ClassNode node) {
        if (this.resolver != null) {
            this.resolver.currentClass = node;
        }
        VariableScope scope = this.scopes.peek();
        scope.addVariable("this", node, node);
        this.visitAnnotations((AnnotatedNode)node);
        TypeLookupResult result = new TypeLookupResult(node, node, (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope);
        ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                break;
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
        if (!node.isEnum()) {
            this.visitGenerics(node);
            this.visitClassReference(node.getUnresolvedSuperClass());
        }
        ClassNode[] classNodeArray = node.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode intr = classNodeArray[n2];
            this.visitClassReference(intr);
            ++n2;
        }
        for (MethodNode method : node.getMethods()) {
            if (!method.getName().startsWith("memoizedMethodPriv$")) continue;
            this.visitClassCodeContainer(method.getCode());
        }
        MethodNode clinit = node.getMethod("<clinit>", NO_PARAMETERS);
        if (clinit != null && clinit.getCode() instanceof BlockStatement) {
            for (Statement element : ((BlockStatement)clinit.getCode()).getStatements()) {
                FieldNode f;
                BinaryExpression bexpr;
                if (!(element instanceof ExpressionStatement) || !(((ExpressionStatement)element).getExpression() instanceof BinaryExpression) || !((bexpr = (BinaryExpression)((ExpressionStatement)element).getExpression()).getLeftExpression() instanceof FieldExpression) || (f = ((FieldExpression)bexpr.getLeftExpression()).getField()) == null || !f.isStatic() || bexpr.getRightExpression() == null) continue;
                VariableScope fieldScope = new VariableScope(scope, (ASTNode)f, true);
                this.scopes.push(fieldScope);
                try {
                    bexpr.getRightExpression().visit((GroovyCodeVisitor)this);
                }
                finally {
                    this.scopes.pop();
                }
            }
        }
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit((GroovyCodeVisitor)this);
        }
        for (ConstructorNode constructor : node.getDeclaredConstructors()) {
            if (!constructor.isSynthetic() || constructor.getParameters() != null && constructor.getParameters().length != 0) continue;
            this.visitConstructor(constructor);
        }
    }

    public void visitField(FieldNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        this.assignmentStorer.storeField(node, scope);
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        scope.setPrimaryNode(false);
        ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                ClassNode fieldType = node.getType();
                if (fieldType != node.getDeclaringClass()) {
                    this.visitClassReference(fieldType);
                }
                this.visitAnnotations((AnnotatedNode)node);
                Expression init = node.getInitialExpression();
                if (init != null) {
                    init.visit((GroovyCodeVisitor)this);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private void visitClassReference(ClassNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        scope.setPrimaryNode(false);
        ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                if (!node.isEnum()) {
                    this.visitGenerics(node);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private void visitGenerics(ClassNode node) {
        if (node.isUsingGenerics() && node.getGenericsTypes() != null) {
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gen = genericsTypeArray[n2];
                if (gen.getType() != null && gen.getName().charAt(0) != '?') {
                    this.visitClassReference(gen.getType());
                }
                if (gen.getLowerBound() != null) {
                    this.visitClassReference(gen.getLowerBound());
                } else if (gen.getUpperBounds() != null) {
                    ClassNode[] classNodeArray = gen.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upper = classNodeArray[n4];
                        if (!upper.getName().equals(node.getName())) {
                            this.visitClassReference(upper);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        scope.setPrimaryNode(false);
        ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                GenericsType[] genericsTypeArray;
                GenericsType[] gens = node.getGenericsTypes();
                if (gens != null) {
                    genericsTypeArray = gens;
                    int n3 = gens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GenericsType gen = genericsTypeArray[n4];
                        if (gen.getLowerBound() != null) {
                            this.visitClassReference(gen.getLowerBound());
                        }
                        if (gen.getUpperBounds() != null) {
                            ClassNode[] classNodeArray = gen.getUpperBounds();
                            int n5 = classNodeArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ClassNode upper = classNodeArray[n6];
                                this.visitClassReference(upper);
                                ++n6;
                            }
                        }
                        if (gen.getType() != null && gen.getType().getName().charAt(0) != '?') {
                            this.visitClassReference(gen.getType());
                        }
                        ++n4;
                    }
                }
                this.visitClassReference(node.getReturnType());
                if (node.getExceptions() != null) {
                    genericsTypeArray = node.getExceptions();
                    int n7 = genericsTypeArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        GenericsType e = genericsTypeArray[n8];
                        this.visitClassReference((ClassNode)e);
                        ++n8;
                    }
                }
                if (this.handleParameterList(node.getParameters())) {
                    super.visitConstructorOrMethod(node, isConstructor);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    public void visitPackage(PackageNode node) {
        if (node != null) {
            this.visitAnnotations((AnnotatedNode)node);
            TypeLookupResult result = new TypeLookupResult(null, null, (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, null);
            ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, result);
            if (status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                throw new VisitCompleted(status);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void visitImports(ModuleNode node) {
        block12: for (ImportNode imp : new ImportNodeCompatibilityWrapper(node).getAllImportNodes()) {
            result = null;
            oldEnclosingElement = this.enclosingElement;
            this.visitAnnotations((AnnotatedNode)imp);
            type = imp.getType();
            if (type != null) {
                importName = String.valueOf(imp.getClassName().replace('$', '.')) + (imp.getFieldName() != null ? "." + imp.getFieldName() : "");
                this.enclosingElement = this.unit.getImport(importName);
                if (!this.enclosingElement.exists()) {
                    this.enclosingElement = oldEnclosingElement;
                }
            }
            try {
                scope = this.scopes.peek();
                scope.setPrimaryNode(false);
                this.assignmentStorer.storeImport(imp, scope);
                var11_12 = this.lookups;
                var10_11 = this.lookups.length;
                var9_9 = 0;
                while (var9_9 < var10_11) {
                    lookup = var11_12[var9_9];
                    candidate = lookup.lookupType(imp, scope);
                    if (candidate != null) {
                        if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                            result = candidate;
                        }
                        if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
                    }
                    ++var9_9;
                }
                status = this.notifyRequestor((ASTNode)imp, this.requestor, result);
                switch (TypeInferencingVisitorWithRequestor.$SWITCH_TABLE$org$eclipse$jdt$groovy$search$ITypeRequestor$VisitStatus()[status.ordinal()]) {
                    case 1: {
                        try {
                            if (type != null) {
                                this.visitClassReference(type);
                                this.completeExpressionStack.push((ASTNode)imp);
                                if (imp.getFieldNameExpr() != null) {
                                    this.primaryTypeStack.push(type);
                                    imp.getFieldNameExpr().visit((GroovyCodeVisitor)this);
                                    this.dependentDeclarationStack.pop();
                                    this.dependentTypeStack.pop();
                                }
                                this.completeExpressionStack.pop();
                            }
                        }
                        catch (VisitCompleted e) {
                            if (e.status != ITypeRequestor.VisitStatus.STOP_VISIT) ** GOTO lbl49
                            throw e;
                        }
                    }
lbl49:
                    // 3 sources

                    ** case 3:
lbl50:
                    // 1 sources

                    continue block12;
                    case 2: {
                        return;
                    }
                    case 4: {
                        throw new VisitCompleted(status);
                    }
                }
            }
            finally {
                this.enclosingElement = oldEnclosingElement;
            }
        }
    }

    public void visitVariableExpression(VariableExpression node) {
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.visitAnnotations((AnnotatedNode)node);
        if (node.getAccessedVariable() == node) {
            this.visitClassReference(node.getOriginType());
        }
        this.handleSimpleExpression((Expression)node);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitArgumentlistExpression(ArgumentListExpression node) {
        VariableScope.CallAndType callAndType = this.scopes.peek().getEnclosingMethodCallExpression();
        boolean closureFound = false;
        if (callAndType != null && callAndType.declaration instanceof MethodNode) {
            HashMap<ClosureExpression, ClassNode> map = new HashMap<ClosureExpression, ClassNode>();
            MethodNode methodNode = (MethodNode)callAndType.declaration;
            if (node.getExpressions().size() == methodNode.getParameters().length) {
                int i = 0;
                while (i < node.getExpressions().size()) {
                    if (node.getExpression(i) instanceof ClosureExpression) {
                        map.put((ClosureExpression)node.getExpression(i), methodNode.getParameters()[i].getType());
                        closureFound = true;
                    }
                    ++i;
                }
            }
            if (closureFound) {
                this.closureTypes.addLast(map);
            }
        }
        this.visitTupleExpression((TupleExpression)node);
        if (closureFound) {
            this.closureTypes.removeLast();
        }
    }

    public void visitArrayExpression(ArrayExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitArrayExpression(node);
        }
    }

    public void visitAttributeExpression(AttributeExpression node) {
        this.visitPropertyExpression((PropertyExpression)node);
    }

    public void visitBinaryExpression(BinaryExpression node) {
        Expression toVisitDependent;
        Expression toVisitPrimary;
        if (node.getOperation().getType() == 544 && node.getLeftExpression() instanceof VariableExpression) {
            VariableExpression variable = (VariableExpression)node.getLeftExpression();
            this.scopes.peek().addVariable(variable.getName(), node.getRightExpression().getType(), variable.getDeclaringClass());
        }
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        if (node instanceof DeclarationExpression && node.getEnd() == 0) {
            return;
        }
        this.visitAnnotations((AnnotatedNode)node);
        boolean isAssignment = node.getOperation().getType() == 100;
        BinaryExpression oldEnclosingAssignment = this.enclosingAssignment;
        if (isAssignment) {
            this.enclosingAssignment = node;
        }
        this.completeExpressionStack.push((ASTNode)node);
        if (isAssignment) {
            toVisitPrimary = node.getRightExpression();
            toVisitDependent = node.getLeftExpression();
        } else {
            toVisitPrimary = node.getLeftExpression();
            toVisitDependent = node.getRightExpression();
        }
        toVisitPrimary.visit((GroovyCodeVisitor)this);
        ClassNode primaryExprType = this.primaryTypeStack.pop();
        if (isAssignment) {
            this.assignmentStorer.storeAssignment(node, this.scopes.peek(), primaryExprType);
        }
        toVisitDependent.visit((GroovyCodeVisitor)this);
        this.completeExpressionStack.pop();
        ClassNode completeExprType = primaryExprType;
        ClassNode dependentExprType = this.primaryTypeStack.pop();
        assert (primaryExprType != null && dependentExprType != null);
        if (!isAssignment && primaryExprType != null && dependentExprType != null) {
            String associatedMethod = this.findBinaryOperatorName(node.getOperation().getText());
            if (this.isArithmeticOperationOnNumberOrStringOrList(node.getOperation().getText(), primaryExprType, dependentExprType)) {
                completeExprType = dependentExprType.equals((Object)VariableScope.STRING_CLASS_NODE) ? VariableScope.STRING_CLASS_NODE : primaryExprType;
            } else if (associatedMethod != null) {
                TypeLookupResult result = this.lookupExpressionType((Expression)new ConstantExpression((Object)associatedMethod), primaryExprType, false, this.scopes.peek());
                completeExprType = result.type;
                if (associatedMethod.equals("getAt") && result.declaringType.equals((Object)VariableScope.DGM_CLASS_NODE)) {
                    if (primaryExprType.getName().equals("java.util.BitSet")) {
                        completeExprType = VariableScope.BOOLEAN_CLASS_NODE;
                    } else {
                        GenericsType[] lhsGenericsTypes = primaryExprType.getGenericsTypes();
                        ClassNode elementType = VariableScope.MAP_CLASS_NODE.equals((Object)primaryExprType) && lhsGenericsTypes != null && lhsGenericsTypes.length == 2 ? lhsGenericsTypes[1].getType() : VariableScope.extractElementType(primaryExprType);
                        completeExprType = dependentExprType.isArray() || dependentExprType.getName().equals(VariableScope.LIST_CLASS_NODE.getName()) || dependentExprType.implementsInterface(VariableScope.LIST_CLASS_NODE) ? this.createParameterizedList(elementType) : elementType;
                    }
                }
            } else {
                completeExprType = this.findTypeOfBinaryExpression(node.getOperation().getText(), primaryExprType, dependentExprType);
            }
        }
        this.handleCompleteExpression((Expression)node, completeExprType, null);
        this.enclosingAssignment = oldEnclosingAssignment;
    }

    private boolean isArithmeticOperationOnNumberOrStringOrList(String text, ClassNode lhs, ClassNode rhs) {
        if (text.length() != 1) {
            return false;
        }
        lhs = ClassHelper.getWrapper((ClassNode)lhs);
        switch (text.charAt(0)) {
            case '+': 
            case '-': {
                return VariableScope.STRING_CLASS_NODE.equals((Object)lhs) || lhs.isDerivedFrom(VariableScope.NUMBER_CLASS_NODE) || VariableScope.NUMBER_CLASS_NODE.equals((Object)lhs) || VariableScope.LIST_CLASS_NODE.equals((Object)lhs) || lhs.implementsInterface(VariableScope.LIST_CLASS_NODE);
            }
            case '%': 
            case '*': 
            case '/': {
                return VariableScope.STRING_CLASS_NODE.equals((Object)lhs) || lhs.isDerivedFrom(VariableScope.NUMBER_CLASS_NODE) || VariableScope.NUMBER_CLASS_NODE.equals((Object)lhs);
            }
        }
        return false;
    }

    private String findBinaryOperatorName(String text) {
        char op = text.charAt(0);
        switch (op) {
            case '+': {
                return "plus";
            }
            case '-': {
                return "minus";
            }
            case '*': {
                if (text.length() > 1 && text.equals("**")) {
                    return "power";
                }
                return "multiply";
            }
            case '/': {
                return "div";
            }
            case '%': {
                return "mod";
            }
            case '&': {
                return "and";
            }
            case '|': {
                return "or";
            }
            case '^': {
                return "xor";
            }
            case '>': {
                if (text.length() <= 1 || !text.equals(">>")) break;
                return "rightShift";
            }
            case '<': {
                if (text.length() <= 1 || !text.equals("<<")) break;
                return "leftShift";
            }
            case '[': {
                return "getAt";
            }
        }
        return null;
    }

    private String findUnaryOperatorName(String text) {
        char op = text.charAt(0);
        switch (op) {
            case '+': {
                if (text.length() > 1 && text.equals("++")) {
                    return "next";
                }
                return "positive";
            }
            case '-': {
                if (text.length() > 1 && text.equals("--")) {
                    return "previous";
                }
                return "negative";
            }
            case ']': {
                return "putAt";
            }
            case '~': {
                return "bitwiseNegate";
            }
        }
        return null;
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression node) {
        this.visitUnaryExpression((Expression)node, node.getExpression(), "~");
    }

    public void visitBooleanExpression(BooleanExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitBooleanExpression(node);
        }
    }

    public void visitEmptyExpression(EmptyExpression node) {
        this.handleSimpleExpression((Expression)node);
    }

    public void visitBytecodeExpression(BytecodeExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitBytecodeExpression(node);
        }
    }

    public void visitCastExpression(CastExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            this.visitClassReference(node.getType());
            super.visitCastExpression(node);
        }
    }

    public void visitClassExpression(ClassExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            this.visitClassReference(node.getType());
            super.visitClassExpression(node);
        }
    }

    public void visitClosureExpression(ClosureExpression node) {
        VariableScope parent = this.scopes.peek();
        VariableScope scope = new VariableScope(parent, (ASTNode)node, false);
        this.scopes.push(scope);
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            ClassNode thisType;
            VariableScope.CallAndType cat;
            ClassNode[] implicitParamType = this.findImplicitParamType(scope, node);
            if (node.getParameters() != null && node.getParameters().length > 0) {
                this.handleParameterList(node.getParameters());
                int i = 0;
                while (i < node.getParameters().length) {
                    Parameter parameter = node.getParameters()[i];
                    if (implicitParamType[i] != VariableScope.OBJECT_CLASS_NODE && parameter.getType().equals((Object)VariableScope.OBJECT_CLASS_NODE)) {
                        parameter.setType(implicitParamType[i]);
                        scope.addVariable((Variable)parameter);
                    }
                    ++i;
                }
            } else if (implicitParamType[0] != VariableScope.OBJECT_CLASS_NODE && !scope.containsInThisScope("it")) {
                scope.addVariable("it", implicitParamType[0], VariableScope.OBJECT_CLASS_NODE);
            }
            if (scope.lookupNameInCurrentScope("it") == null) {
                this.inferItType(node, scope);
            }
            if ((cat = scope.getEnclosingMethodCallExpression()) != null) {
                ClassNode declaringType = cat.declaringType;
                if (cat.delegatesToClosures.containsKey(node)) {
                    declaringType = cat.delegatesToClosures.get(node);
                }
                scope.addVariable("delegate", declaringType, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getDelegate", declaringType, VariableScope.CLOSURE_CLASS);
            } else {
                thisType = scope.getThis();
                if (scope.lookupName("delegate") == null) {
                    scope.addVariable("delegate", thisType, VariableScope.CLOSURE_CLASS);
                }
                scope.addVariable("getDelegate", thisType, VariableScope.CLOSURE_CLASS);
            }
            if (parent.getEnclosingClosure() != null) {
                scope.addVariable("getOwner", VariableScope.CLOSURE_CLASS, VariableScope.CLOSURE_CLASS);
                scope.addVariable("owner", VariableScope.CLOSURE_CLASS, VariableScope.CLOSURE_CLASS);
            } else {
                thisType = scope.getThis();
                if (scope.lookupName("owner") == null) {
                    scope.addVariable("owner", thisType, VariableScope.CLOSURE_CLASS);
                }
                scope.addVariable("getOwner", thisType, VariableScope.CLOSURE_CLASS);
                scope.addVariable("thisObject", VariableScope.OBJECT_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getThisObject", VariableScope.OBJECT_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("resolveStategy", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getResolveStategy", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("directive", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getDirective", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("maximumNumberOfParameters", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getMaximumNumberOfParameters", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("parameterTypes", VariableScope.CLASS_ARRAY_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getParameterTypes", VariableScope.CLASS_ARRAY_CLASS_NODE, VariableScope.CLOSURE_CLASS);
            }
            super.visitClosureExpression(node);
        }
        this.scopes.pop();
    }

    private ClassNode[] findImplicitParamType(VariableScope scope, ClosureExpression closure) {
        int numParams;
        int n = numParams = closure.getParameters() == null ? 0 : closure.getParameters().length;
        if (numParams == 0) {
            ++numParams;
        }
        Object[] allInferred = new ClassNode[numParams];
        VariableScope.CallAndType call = scope.getEnclosingMethodCallExpression();
        if (call != null) {
            String methodName = call.call.getMethodAsString();
            ClassNode delegateType = call.declaringType;
            ClassNode inferredType = dgmClosureMethods.contains(methodName) ? VariableScope.extractElementType(delegateType) : (dgmClosureIdentityMethods.contains(methodName) ? VariableScope.clone(delegateType) : dgmClosureMethodsMap.get(methodName));
            if (inferredType != null) {
                GenericsType[] typeParams;
                Arrays.fill(allInferred, inferredType);
                if (methodName.equals("eachWithIndex") && allInferred.length > 1) {
                    allInferred[allInferred.length - 1] = VariableScope.INTEGER_CLASS_NODE;
                }
                if (delegateType.getName().equals(VariableScope.MAP_CLASS_NODE.getName()) && (dgmClosureMaybeMap.contains(methodName) && numParams == 2 || methodName.equals("eachWithIndex") && numParams == 3) && (typeParams = inferredType.getGenericsTypes()) != null && typeParams.length == 2) {
                    allInferred[0] = typeParams[0].getType();
                    allInferred[1] = typeParams[1].getType();
                }
                return allInferred;
            }
        }
        Arrays.fill(allInferred, VariableScope.OBJECT_CLASS_NODE);
        return allInferred;
    }

    private void inferItType(ClosureExpression node, VariableScope scope) {
        if (this.closureTypes.isEmpty()) {
            return;
        }
        ClassNode closureType = this.closureTypes.peek().get(node);
        if (closureType != null) {
            MethodNode method = null;
            for (MethodNode methodNode : closureType.getMethods()) {
                if (!methodNode.isAbstract() || methodNode.getParameters().length != 1) continue;
                if (method != null) {
                    return;
                }
                method = methodNode;
            }
            if (method != null) {
                ClassNode inferredType = method.getParameters()[0].getType();
                scope.addVariable("it", inferredType, VariableScope.OBJECT_CLASS_NODE);
            }
        }
    }

    public void visitBlockStatement(BlockStatement block) {
        this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)block, false));
        boolean shouldContinue = this.handleStatement((Statement)block);
        if (shouldContinue) {
            super.visitBlockStatement(block);
        }
        this.scopes.pop();
    }

    public void visitReturnStatement(ReturnStatement ret) {
        boolean shouldContinue = this.handleStatement((Statement)ret);
        if (shouldContinue) {
            super.visitReturnStatement(ret);
        }
    }

    public void visitForLoop(ForStatement node) {
        this.completeExpressionStack.push((ASTNode)node);
        node.getCollectionExpression().visit((GroovyCodeVisitor)this);
        this.completeExpressionStack.pop();
        ClassNode collectionType = this.primaryTypeStack.pop();
        this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)node, false));
        Parameter param = node.getVariable();
        if (param != null) {
            this.handleParameterList(new Parameter[]{param});
            if (param.getType().equals((Object)VariableScope.OBJECT_CLASS_NODE)) {
                ClassNode extractedElementType = VariableScope.extractElementType(collectionType);
                this.scopes.peek().addVariable(param.getName(), extractedElementType, null);
            }
        }
        node.getLoopBlock().visit((GroovyCodeVisitor)this);
        this.scopes.pop();
    }

    public void visitCatchStatement(CatchStatement node) {
        this.scopes.push(new VariableScope(this.scopes.peek(), (ASTNode)node, false));
        Parameter param = node.getVariable();
        if (param != null) {
            this.handleParameterList(new Parameter[]{param});
        }
        super.visitCatchStatement(node);
        this.scopes.pop();
    }

    public void visitClosureListExpression(ClosureListExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitClosureListExpression(node);
        }
    }

    public void visitConstantExpression(ConstantExpression node) {
        if (node instanceof AnnotationConstantExpression) {
            this.visitClassReference(node.getType());
        }
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.handleSimpleExpression((Expression)node);
        this.scopes.peek().forgetCurrentNode();
        super.visitConstantExpression(node);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            Expression arg;
            this.visitClassReference(node.getType());
            if (node.getArguments() instanceof TupleExpression && ((TupleExpression)node.getArguments()).getExpressions().size() == 1 && (arg = (Expression)((TupleExpression)node.getArguments()).getExpressions().get(0)) instanceof MapExpression) {
                this.enclosingConstructorCall = node;
            }
            super.visitConstructorCallExpression(node);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression node) {
        this.visitBinaryExpression((BinaryExpression)node);
    }

    public void visitFieldExpression(FieldExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitFieldExpression(node);
        }
    }

    public void visitGStringExpression(GStringExpression node) {
        this.scopes.peek().setCurrentNode((ASTNode)node);
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitGStringExpression(node);
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitListExpression(ListExpression node) {
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.completeExpressionStack.push((ASTNode)node);
        super.visitListExpression(node);
        ClassNode eltType = node.getExpressions().size() > 0 ? this.primaryTypeStack.pop() : VariableScope.OBJECT_CLASS_NODE;
        this.completeExpressionStack.pop();
        ClassNode exprType = this.createParameterizedList(eltType);
        this.handleCompleteExpression((Expression)node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMapEntryExpression(MapEntryExpression node) {
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.completeExpressionStack.push((ASTNode)node);
        node.getKeyExpression().visit((GroovyCodeVisitor)this);
        ClassNode k = this.primaryTypeStack.pop();
        node.getValueExpression().visit((GroovyCodeVisitor)this);
        ClassNode v = this.primaryTypeStack.pop();
        this.completeExpressionStack.pop();
        ClassNode exprType = this.isPrimaryExpression((Expression)node) ? this.createParameterizedMap(k, v) : VariableScope.OBJECT_CLASS_NODE;
        this.handleCompleteExpression((Expression)node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMapExpression(MapExpression node) {
        ClassNode newType;
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        if (this.enclosingConstructorCall != null) {
            newType = this.enclosingConstructorCall.getType();
            this.enclosingConstructorCall = null;
        } else {
            newType = null;
        }
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.completeExpressionStack.push((ASTNode)node);
        if (newType == null) {
            for (MapEntryExpression entry : node.getMapEntryExpressions()) {
                entry.visit((GroovyCodeVisitor)this);
            }
        } else {
            for (MapEntryExpression entry : node.getMapEntryExpressions()) {
                Expression key = entry.getKeyExpression();
                if (key instanceof ConstantExpression) {
                    String fieldName = key.getText();
                    FieldNode field = newType.getField(fieldName);
                    if (field == null) {
                        PropertyNode property = newType.getProperty(fieldName);
                        if (property == null) {
                            this.handleSimpleExpression(key);
                        } else {
                            TypeLookupResult result = new TypeLookupResult(property.getType(), property.getDeclaringClass(), (ASTNode)property, TypeLookupResult.TypeConfidence.EXACT, this.scopes.peek());
                            this.handleRequestor(key, newType, result);
                        }
                    } else {
                        TypeLookupResult result = new TypeLookupResult(field.getType(), field.getDeclaringClass(), (ASTNode)field, TypeLookupResult.TypeConfidence.EXACT, this.scopes.peek());
                        this.handleRequestor(key, newType, result);
                    }
                } else {
                    this.handleSimpleExpression(key);
                }
                entry.getValueExpression().visit((GroovyCodeVisitor)this);
            }
        }
        this.completeExpressionStack.pop();
        ClassNode exprType = node.getMapEntryExpressions().size() > 0 && newType == null ? this.primaryTypeStack.pop() : this.createParameterizedMap(VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE);
        this.handleCompleteExpression((Expression)node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMethodCallExpression(MethodCallExpression node) {
        this.scopes.peek().setCurrentNode((ASTNode)node);
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        this.completeExpressionStack.push((ASTNode)node);
        node.getObjectExpression().visit((GroovyCodeVisitor)this);
        if (node.isSpreadSafe()) {
            ClassNode objType = this.primaryTypeStack.pop();
            this.primaryTypeStack.push(VariableScope.extractElementType(objType));
        }
        node.getMethod().visit((GroovyCodeVisitor)this);
        ClassNode exprType = this.dependentTypeStack.pop();
        Tuple t = this.dependentDeclarationStack.pop();
        VariableScope.CallAndType call = new VariableScope.CallAndType(node, t.declaringType, t.declaration);
        this.completeExpressionStack.pop();
        ClassNode catNode = this.isCategoryDeclaration(node);
        if (catNode != null) {
            this.addCategoryToBeDeclared(catNode);
        }
        VariableScope scope = this.scopes.peek();
        scope.addEnclosingMethodCall(call);
        node.getArguments().visit((GroovyCodeVisitor)this);
        scope.forgetEnclosingMethodCall();
        if (node.isSpreadSafe()) {
            exprType = this.createParameterizedList(exprType);
        }
        if (t.declaration instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)t.declaration;
            boolean generic = methodNode.getReturnType().isGenericsPlaceHolder();
            GenericsType[] genericsTypes = methodNode.getGenericsTypes();
            if (generic && genericsTypes != null && genericsTypes.length > 0) {
                exprType = this.inferGenericMethodType(methodNode, node.getArguments());
                if (this.needToFixStaticMethodType) {
                    this.inferredStaticMethodType = exprType;
                }
            }
        }
        this.handleCompleteExpression((Expression)node, exprType, t.declaringType);
        this.scopes.peek().forgetCurrentNode();
    }

    private ClassNode inferGenericMethodType(MethodNode methodNode, Expression arguments) {
        class Helper
        extends StaticTypeCheckingVisitor {
            public Helper(MethodNode methodNode) {
                super(new SourceUnit(new File("."), new CompilerConfiguration(), null, null), methodNode.getDeclaringClass());
            }

            public ClassNode inferMethodType(ClassNode receiver, MethodNode method, Expression arguments) {
                return this.inferReturnTypeGenerics(receiver, method, arguments);
            }
        }
        return new Helper(methodNode).inferMethodType(methodNode.getDeclaringClass(), methodNode, arguments);
    }

    public void visitMethodPointerExpression(MethodPointerExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            this.completeExpressionStack.push((ASTNode)node);
            this.primaryTypeStack.push(node.getExpression().getType());
            super.visitMethodPointerExpression(node);
            this.completeExpressionStack.pop();
            ClassNode returnType = this.dependentTypeStack.pop();
            Tuple callParamTypes = this.dependentDeclarationStack.pop();
            if (!this.primaryTypeStack.isEmpty() && callParamTypes.declaration != null) {
                GroovyUtils.updateClosureWithInferredTypes(this.primaryTypeStack.peek(), returnType, ((MethodNode)callParamTypes.declaration).getParameters());
            }
        }
    }

    public void visitNotExpression(NotExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitNotExpression(node);
        }
    }

    public void visitPostfixExpression(PostfixExpression node) {
        this.visitUnaryExpression((Expression)node, node.getExpression(), node.getOperation().getText());
    }

    public void visitPrefixExpression(PrefixExpression node) {
        this.visitUnaryExpression((Expression)node, node.getExpression(), node.getOperation().getText());
    }

    private void visitUnaryExpression(Expression node, Expression expression, String operation) {
        ClassNode completeExprType;
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.completeExpressionStack.push((ASTNode)node);
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        expression.visit((GroovyCodeVisitor)this);
        ClassNode primaryType = this.primaryTypeStack.pop();
        String associatedMethod = this.findUnaryOperatorName(operation);
        if (associatedMethod == null && primaryType.equals((Object)VariableScope.NUMBER_CLASS_NODE) || ClassHelper.getWrapper((ClassNode)primaryType).isDerivedFrom(VariableScope.NUMBER_CLASS_NODE)) {
            completeExprType = primaryType;
        } else {
            TypeLookupResult result = this.lookupExpressionType((Expression)new ConstantExpression((Object)associatedMethod), primaryType, false, this.scopes.peek());
            completeExprType = result.type;
        }
        this.completeExpressionStack.pop();
        this.handleCompleteExpression(node, completeExprType, null);
    }

    public void visitPropertyExpression(PropertyExpression node) {
        ClassNode objType;
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.completeExpressionStack.push((ASTNode)node);
        node.getObjectExpression().visit((GroovyCodeVisitor)this);
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        if (node.isSpreadSafe()) {
            objType = this.primaryTypeStack.pop();
            objType = VariableScope.extractElementType(objType);
            this.primaryTypeStack.push(objType);
        } else {
            objType = this.primaryTypeStack.peek();
        }
        if (VariableScope.MAP_CLASS_NODE.equals((Object)objType) && node.getObjectExpression() instanceof VariableExpression && node.getProperty() instanceof ConstantExpression) {
            this.currentMapVariable = ((VariableExpression)node.getObjectExpression()).getAccessedVariable();
            Map<String, ClassNode> map = this.localMapProperties.get(this.currentMapVariable);
            if (map == null) {
                map = new HashMap<String, ClassNode>();
                this.localMapProperties.put(this.currentMapVariable, map);
            }
            if (this.enclosingAssignment != null) {
                map.put(((ConstantExpression)node.getProperty()).getConstantName(), this.enclosingAssignment.getRightExpression().getType());
            }
        }
        node.getProperty().visit((GroovyCodeVisitor)this);
        this.currentMapVariable = null;
        ClassNode exprType = this.dependentTypeStack.pop();
        this.dependentDeclarationStack.pop();
        this.completeExpressionStack.pop();
        if (node.isSpreadSafe()) {
            if (objType.equals((Object)VariableScope.MAP_CLASS_NODE) && objType.getGenericsTypes() != null && objType.getGenericsTypes().length == 2) {
                exprType = objType.getGenericsTypes()[1].getType();
            }
            exprType = this.createParameterizedList(exprType);
        }
        this.handleCompleteExpression((Expression)node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitRangeExpression(RangeExpression node) {
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        this.scopes.peek().setCurrentNode((ASTNode)node);
        this.completeExpressionStack.push((ASTNode)node);
        super.visitRangeExpression(node);
        ClassNode eltType = this.primaryTypeStack.pop();
        this.completeExpressionStack.pop();
        ClassNode rangeType = this.createParameterizedRange(eltType);
        this.handleCompleteExpression((Expression)node, rangeType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression node) {
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        this.completeExpressionStack.push((ASTNode)node);
        node.getTrueExpression().visit((GroovyCodeVisitor)this);
        ClassNode exprType = this.primaryTypeStack.pop();
        this.completeExpressionStack.pop();
        node.getFalseExpression().visit((GroovyCodeVisitor)this);
        this.handleCompleteExpression((Expression)node, exprType, null);
    }

    public void visitSpreadExpression(SpreadExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitSpreadExpression(node);
        }
    }

    public void visitSpreadMapExpression(SpreadMapExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitSpreadMapExpression(node);
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression node) {
        if (this.isPrimaryExpression((Expression)node)) {
            this.needToFixStaticMethodType = true;
            this.visitMethodCallExpression(new MethodCallExpression((Expression)new ClassExpression(node.getOwnerType()), node.getMethod(), node.getArguments()));
            this.needToFixStaticMethodType = false;
        }
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (this.inferredStaticMethodType != null) {
            if (!this.primaryTypeStack.isEmpty()) {
                this.primaryTypeStack.pop();
            }
            this.primaryTypeStack.push(this.inferredStaticMethodType);
            this.inferredStaticMethodType = null;
        }
        if (shouldContinue) {
            boolean isPresentInSource;
            boolean bl = isPresentInSource = node.getEnd() > 0;
            if (isPresentInSource) {
                this.visitClassReference(node.getOwnerType());
            }
            if (isPresentInSource || this.isEnumInit(node)) {
                super.visitStaticMethodCallExpression(node);
            }
        }
    }

    public void visitTernaryExpression(TernaryExpression node) {
        if (this.isDependentExpression((Expression)node)) {
            this.primaryTypeStack.pop();
        }
        this.completeExpressionStack.push((ASTNode)node);
        node.getBooleanExpression().visit((GroovyCodeVisitor)this);
        node.getTrueExpression().visit((GroovyCodeVisitor)this);
        ClassNode exprType = this.primaryTypeStack.pop();
        node.getFalseExpression().visit((GroovyCodeVisitor)this);
        this.completeExpressionStack.pop();
        this.handleCompleteExpression((Expression)node, exprType, null);
    }

    public void visitTupleExpression(TupleExpression node) {
        boolean shouldContinue = this.handleSimpleExpression((Expression)node);
        if (shouldContinue) {
            super.visitTupleExpression(node);
        }
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression node) {
        this.visitUnaryExpression((Expression)node, node.getExpression(), "-");
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression node) {
        this.visitUnaryExpression((Expression)node, node.getExpression(), "+");
    }

    protected void visitAnnotation(AnnotationNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, result);
        block0 : switch (status) {
            case CONTINUE: {
                this.visitClassReference(node.getClassNode());
                super.visitAnnotation(node);
                for (String name : node.getMembers().keySet()) {
                    TypeLookupResult noLookup;
                    MethodNode attr;
                    MethodNode meth = node.getClassNode().getMethod(name, Parameter.EMPTY_ARRAY);
                    if (meth != null) {
                        attr = meth;
                        noLookup = new TypeLookupResult(meth.getReturnType(), node.getClassNode().redirect(), (ASTNode)meth, TypeLookupResult.TypeConfidence.EXACT, scope);
                    } else {
                        attr = new ConstantExpression((Object)name);
                        attr.setStart(node.getEnd() + 2);
                        attr.setEnd(attr.getStart() + name.length());
                        noLookup = new TypeLookupResult(ClassHelper.VOID_TYPE, node.getClassNode().redirect(), null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
                    }
                    noLookup.enclosingAnnotation = node;
                    status = this.notifyRequestor((ASTNode)attr, this.requestor, noLookup);
                    if (status != ITypeRequestor.VisitStatus.CONTINUE) break block0;
                }
                break;
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private boolean handleStatement(Statement node) {
        VariableScope scope = this.scopes.peek();
        ClassNode declaring = scope.getDelegateOrThis();
        scope.setPrimaryNode(false);
        if (node instanceof BlockStatement) {
            ITypeLookup[] iTypeLookupArray = this.lookups;
            int n = this.lookups.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeLookup lookup = iTypeLookupArray[n2];
                if (lookup instanceof ITypeLookupExtension) {
                    ((ITypeLookupExtension)lookup).lookupInBlock((BlockStatement)node, scope);
                }
                ++n2;
            }
        }
        TypeLookupResult noLookup = new TypeLookupResult(declaring, declaring, (ASTNode)declaring, TypeLookupResult.TypeConfidence.EXACT, scope);
        ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, noLookup);
        switch (status) {
            case CONTINUE: {
                return true;
            }
            case CANCEL_BRANCH: {
                return false;
            }
        }
        throw new VisitCompleted(status);
    }

    private boolean handleSimpleExpression(Expression node) {
        boolean isStatic;
        ClassNode primaryType;
        VariableScope scope = this.scopes.peek();
        if (this.isDependentExpression(node)) {
            primaryType = this.primaryTypeStack.pop();
            if (this.isImplicitThis()) {
                primaryType = null;
            }
            isStatic = this.hasStaticObjectExpression(node);
            scope.setMethodCallArgumentTypes(this.getMethodCallArgs());
        } else {
            primaryType = null;
            isStatic = false;
        }
        scope.setPrimaryNode(primaryType == null);
        TypeLookupResult result = this.lookupExpressionType(node, primaryType, isStatic, scope);
        return this.handleRequestor(node, primaryType, result);
    }

    protected boolean isImplicitThis() {
        return this.completeExpressionStack.peek() instanceof MethodCallExpression && ((MethodCallExpression)this.completeExpressionStack.peek()).isImplicitThis();
    }

    private void handleCompleteExpression(Expression node, ClassNode exprType, ClassNode exprDeclaringType) {
        VariableScope scope = this.scopes.peek();
        scope.setPrimaryNode(false);
        this.handleRequestor(node, exprDeclaringType, new TypeLookupResult(exprType, exprDeclaringType, (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope));
    }

    private void postVisit(Expression node, ClassNode type, ClassNode declaringType, ASTNode declaration) {
        if (this.isPrimaryExpression(node)) {
            assert (type != null);
            this.primaryTypeStack.push(type);
        } else if (this.isDependentExpression(node)) {
            this.dependentTypeStack.push(type);
            this.dependentDeclarationStack.push(new Tuple(declaringType, declaration));
        }
    }

    private TypeLookupResult lookupExpressionType(Expression node, ClassNode objectExprType, boolean isStatic, VariableScope scope) {
        TypeLookupResult result = null;
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup instanceof ITypeLookupExtension ? ((ITypeLookupExtension)lookup).lookupType(node, scope, objectExprType, isStatic) : lookup.lookupType(node, scope, objectExprType);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        if (result.confidence == TypeLookupResult.TypeConfidence.UNKNOWN && VariableScope.MAP_CLASS_NODE.equals((Object)result.declaringType)) {
            ClassNode inferredType = VariableScope.OBJECT_CLASS_NODE;
            if (this.currentMapVariable != null && node instanceof ConstantExpression) {
                inferredType = this.localMapProperties.get(this.currentMapVariable).get(((ConstantExpression)node).getConstantName());
            }
            result = new TypeLookupResult(inferredType, result.declaringType, result.declaration, TypeLookupResult.TypeConfidence.INFERRED, result.scope);
        }
        return result;
    }

    private List<ClassNode> getMethodCallArgs() {
        ASTNode peek = this.completeExpressionStack.peek();
        if (peek instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)peek;
            Expression arguments = call.getArguments();
            if (arguments instanceof ArgumentListExpression) {
                ArgumentListExpression list = (ArgumentListExpression)arguments;
                List expressions = list.getExpressions();
                ArrayList<ClassNode> types = new ArrayList<ClassNode>();
                for (Expression expression : expressions) {
                    types.add(expression.getType());
                }
                return types;
            }
            return new ArrayList<ClassNode>();
        }
        return null;
    }

    private boolean handleParameterList(Parameter[] params) {
        if (params != null) {
            VariableScope scope = this.scopes.peek();
            Parameter[] parameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter node = parameterArray[n2];
                this.assignmentStorer.storeParameterType(node, scope);
                TypeLookupResult result = null;
                ITypeLookup[] iTypeLookupArray = this.lookups;
                int n3 = this.lookups.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeLookup lookup = iTypeLookupArray[n4];
                    lookup.lookupType(node, scope);
                    result = lookup.lookupType(node.getType(), scope);
                    TypeLookupResult candidate = lookup.lookupType(node.getType(), scope);
                    if (candidate != null) {
                        if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                            result = candidate;
                        }
                        if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
                    }
                    ++n4;
                }
                TypeLookupResult parameterResult = new TypeLookupResult(result.type, result.declaringType, (ASTNode)node, TypeLookupResult.TypeConfidence.EXACT, scope);
                scope.setPrimaryNode(false);
                ITypeRequestor.VisitStatus status = this.notifyRequestor((ASTNode)node, this.requestor, parameterResult);
                switch (status) {
                    case CONTINUE: {
                        break;
                    }
                    case CANCEL_BRANCH: {
                        return false;
                    }
                    case CANCEL_MEMBER: 
                    case STOP_VISIT: {
                        throw new VisitCompleted(status);
                    }
                }
                this.visitClassReference(node.getType());
                this.visitAnnotations((AnnotatedNode)node);
                Expression init = node.getInitialExpression();
                if (init != null) {
                    init.visit((GroovyCodeVisitor)this);
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean handleRequestor(Expression node, ClassNode primaryType, TypeLookupResult result) {
        result.enclosingAssignment = this.enclosingAssignment;
        ITypeRequestor.VisitStatus status = this.requestor.acceptASTNode((ASTNode)node, result, this.enclosingElement);
        VariableScope scope = this.scopes.peek();
        scope.setMethodCallArgumentTypes(null);
        ClassNode rememberedDeclaringType = result.declaringType;
        if (scope.getCategoryNames().contains(rememberedDeclaringType)) {
            ClassNode classNode = rememberedDeclaringType = primaryType != null ? primaryType : scope.getDelegateOrThis();
        }
        if (rememberedDeclaringType == null) {
            rememberedDeclaringType = VariableScope.OBJECT_CLASS_NODE;
        }
        switch (status) {
            case CONTINUE: {
                this.postVisit(node, result.type, rememberedDeclaringType, result.declaration);
                return true;
            }
            case CANCEL_BRANCH: {
                this.postVisit(node, result.type, rememberedDeclaringType, result.declaration);
                return false;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
        return false;
    }

    private ITypeRequestor.VisitStatus notifyRequestor(ASTNode node, ITypeRequestor requestor, TypeLookupResult result) {
        return requestor.acceptASTNode(node, result, this.enclosingElement);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private MethodNode findMethodNode(IMethod method) {
        ClassNode clazz = this.findClassWithName(this.createName(method.getDeclaringType()));
        try {
            if (method.isConstructor()) {
                List constructors = clazz.getDeclaredConstructors();
                if (constructors == null || constructors.isEmpty()) {
                    return null;
                }
                Object[] jdtParamTypes = method.getParameterTypes() == null ? NO_PARAMS : method.getParameterTypes();
                block2: for (ConstructorNode constructorNode : constructors) {
                    Parameter[] groovyParams;
                    Parameter[] parameterArray = groovyParams = constructorNode.getParameters() == null ? NO_PARAMETERS : constructorNode.getParameters();
                    if (groovyParams != null && groovyParams.length > 0) {
                        int implicitParamCount = 0;
                        if (method.getDeclaringType().isEnum()) {
                            implicitParamCount = 2;
                        }
                        if (groovyParams[0].getName().startsWith("$")) {
                            implicitParamCount = 1;
                        }
                        if (implicitParamCount > 0) {
                            Parameter[] newGroovyParams = new Parameter[groovyParams.length - implicitParamCount];
                            System.arraycopy(groovyParams, implicitParamCount, newGroovyParams, 0, newGroovyParams.length);
                            groovyParams = newGroovyParams;
                        }
                    }
                    if (groovyParams.length != jdtParamTypes.length) continue;
                    int i = 0;
                    int n = groovyParams.length;
                    while (i < n) {
                        String groovyClassType;
                        String simpleGroovyClassType = GroovyUtils.getTypeSignature(groovyParams[i].getType(), false);
                        if (!simpleGroovyClassType.equals(jdtParamTypes[i]) && !(groovyClassType = GroovyUtils.getTypeSignature(groovyParams[i].getType(), true)).equals(jdtParamTypes[i])) continue block2;
                        ++i;
                    }
                    return constructorNode;
                }
                String params = "";
                if (jdtParamTypes.length > 0) {
                    params = Arrays.toString(jdtParamTypes);
                    params = params.substring(1, params.length() - 1);
                }
                System.err.printf("%s.findMethodNode: no match found for %s(%s)%n", ((Object)((Object)this)).getClass().getSimpleName(), clazz.getName(), params);
                return (MethodNode)constructors.get(0);
            }
            List methods = clazz.getMethods(method.getElementName());
            if (methods.size() == 0) {
                return null;
            }
            Object[] jdtParamTypes = method.getParameterTypes() == null ? NO_PARAMS : method.getParameterTypes();
            block4: for (MethodNode methodNode : methods) {
                Parameter[] groovyParams;
                Parameter[] parameterArray = groovyParams = methodNode.getParameters() == null ? NO_PARAMETERS : methodNode.getParameters();
                if (groovyParams.length != jdtParamTypes.length) continue;
                int i = 0;
                int n = groovyParams.length;
                while (i < n) {
                    String groovyClassType;
                    String simpleGroovyClassType = GroovyUtils.getTypeSignature(groovyParams[i].getType(), false);
                    if (!simpleGroovyClassType.equals(jdtParamTypes[i]) && !(groovyClassType = GroovyUtils.getTypeSignature(groovyParams[i].getType(), true)).equals(jdtParamTypes[i])) continue block4;
                    ++i;
                }
                return methodNode;
            }
            String params = "";
            if (jdtParamTypes.length > 0) {
                params = Arrays.toString(jdtParamTypes);
                params = params.substring(1, params.length() - 1);
            }
            System.err.printf("%s.findMethodNode: no match found for %s.%s(%s)%n", ((Object)((Object)this)).getClass().getSimpleName(), clazz.getName(), method.getElementName(), params);
            return (MethodNode)methods.get(0);
        }
        catch (JavaModelException e) {
            Util.log((Throwable)e, (String)("Exception finding method " + method.getElementName() + " in class " + clazz.getName()));
            return null;
        }
    }

    private FieldNode findFieldNode(IField field) {
        ClassNode clazz = this.findClassWithName(this.createName(field.getDeclaringType()));
        FieldNode fieldNode = clazz.getField(field.getElementName());
        if (fieldNode == null) {
            fieldNode = clazz.getField("$" + field.getElementName());
        }
        return fieldNode;
    }

    private ClassNode createParameterizedList(ClassNode propType) {
        ClassNode list = VariableScope.clonedList();
        list.getGenericsTypes()[0].setType(propType);
        list.getGenericsTypes()[0].setName(propType.getName());
        return list;
    }

    private ClassNode createParameterizedRange(ClassNode propType) {
        ClassNode range = VariableScope.clonedRange();
        range.getGenericsTypes()[0].setType(propType);
        range.getGenericsTypes()[0].setName(propType.getName());
        return range;
    }

    private ClassNode createParameterizedMap(ClassNode k, ClassNode v) {
        ClassNode map = VariableScope.clonedMap();
        map.getGenericsTypes()[0].setType(k);
        map.getGenericsTypes()[0].setName(k.getName());
        map.getGenericsTypes()[1].setType(v);
        map.getGenericsTypes()[1].setName(v.getName());
        return map;
    }

    protected boolean isEnumInit(StaticMethodCallExpression node) {
        int typeModifiers = node.getOwnerType().getModifiers();
        return (typeModifiers & 0x4000) > 0 && node.getMethod().equals("$INIT");
    }

    private boolean isLazy(FieldNode fieldNode) {
        List annotations = fieldNode.getAnnotations();
        for (AnnotationNode annotation : annotations) {
            if (!annotation.getClassNode().getName().equals("groovy.lang.Lazy")) continue;
            return true;
        }
        return false;
    }

    private MethodNode getLazyMethod(String fieldName) {
        ClassNode classNode = (ClassNode)this.enclosingDeclarationNode;
        return classNode.getDeclaredMethod("get" + MetaClassHelper.capitalize((String)fieldName), NO_PARAMETERS);
    }

    private void setNameLocation(FieldNode fieldNode) throws JavaModelException {
        fieldNode.setNameEnd(fieldNode.getEnd());
        int nameLength = fieldNode.getName().length();
        Expression init = fieldNode.getInitialExpression();
        if (init != null && !(init instanceof EmptyExpression)) {
            String fieldText = this.unit.getSource().substring(fieldNode.getStart(), init.getStart());
            int nameStart = fieldNode.getStart() + fieldText.lastIndexOf(fieldNode.getName());
            if (nameStart < fieldNode.getStart()) {
                throw new JavaModelException(null, 980);
            }
            fieldNode.setNameEnd(nameStart + nameLength);
        }
        fieldNode.setNameStart(fieldNode.getNameEnd() - nameLength);
        fieldNode.setNameEnd(fieldNode.getNameEnd() - 1);
    }

    private ClassNode findClassWithName(String simpleName) {
        for (ClassNode clazz : this.getModuleNode().getClasses()) {
            if (!clazz.getNameWithoutPackage().equals(simpleName)) continue;
            return clazz;
        }
        return null;
    }

    private ModuleNodeMapper.ModuleNodeInfo createModuleNode(GroovyCompilationUnit unit) {
        if (unit.getOwner() == null || unit.owner == DefaultWorkingCopyOwner.PRIMARY) {
            return unit.getModuleInfo(true);
        }
        return unit.getNewModuleInfo();
    }

    private ModuleNode getModuleNode() {
        if (this.enclosingDeclarationNode instanceof ModuleNode) {
            return (ModuleNode)this.enclosingDeclarationNode;
        }
        if (this.enclosingDeclarationNode instanceof ClassNode) {
            return ((ClassNode)this.enclosingDeclarationNode).getModule();
        }
        if (this.enclosingDeclarationNode instanceof MethodNode) {
            return ((MethodNode)this.enclosingDeclarationNode).getDeclaringClass().getModule();
        }
        if (this.enclosingDeclarationNode instanceof FieldNode) {
            return ((FieldNode)this.enclosingDeclarationNode).getDeclaringClass().getModule();
        }
        throw new IllegalArgumentException("Invalid enclosing declaration node: " + this.enclosingDeclarationNode);
    }

    private boolean isPrimaryExpression(Expression node) {
        if (!this.completeExpressionStack.isEmpty()) {
            ASTNode complete = this.completeExpressionStack.peek();
            if (complete instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)complete;
                return prop.getObjectExpression() == node;
            }
            if (complete instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)complete;
                return prop.getObjectExpression() == node;
            }
            if (complete instanceof BinaryExpression) {
                BinaryExpression prop = (BinaryExpression)complete;
                return prop.getRightExpression() == node || prop.getLeftExpression() == node;
            }
            if (complete instanceof AttributeExpression) {
                AttributeExpression prop = (AttributeExpression)complete;
                return prop.getObjectExpression() == node;
            }
            if (complete instanceof TernaryExpression) {
                TernaryExpression prop = (TernaryExpression)complete;
                return prop.getTrueExpression() == node;
            }
            if (complete instanceof ForStatement) {
                ForStatement prop = (ForStatement)complete;
                return prop.getCollectionExpression() == node;
            }
            if (complete instanceof ListExpression) {
                return ((ListExpression)complete).getExpressions().size() > 0 && ((ListExpression)complete).getExpression(0) == node;
            }
            if (complete instanceof RangeExpression) {
                return ((RangeExpression)complete).getFrom() == node;
            }
            if (complete instanceof MapEntryExpression) {
                return ((MapEntryExpression)complete).getKeyExpression() == node || ((MapEntryExpression)complete).getValueExpression() == node;
            }
            if (complete instanceof MapExpression) {
                return ((MapExpression)complete).getMapEntryExpressions().size() > 0 && ((MapExpression)complete).getMapEntryExpressions().get(0) == node;
            }
            if (complete instanceof PrefixExpression) {
                return ((PrefixExpression)complete).getExpression() == node;
            }
            if (complete instanceof PostfixExpression) {
                return ((PostfixExpression)complete).getExpression() == node;
            }
            if (complete instanceof UnaryPlusExpression) {
                return ((UnaryPlusExpression)complete).getExpression() == node;
            }
            if (complete instanceof UnaryMinusExpression) {
                return ((UnaryMinusExpression)complete).getExpression() == node;
            }
            if (complete instanceof BitwiseNegationExpression) {
                return ((BitwiseNegationExpression)complete).getExpression() == node;
            }
            return false;
        }
        return false;
    }

    private boolean isDependentExpression(Expression node) {
        if (!this.completeExpressionStack.isEmpty()) {
            ASTNode complete = this.completeExpressionStack.peek();
            if (complete instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)complete;
                return prop.getProperty() == node;
            }
            if (complete instanceof MethodCallExpression) {
                MethodCallExpression call = (MethodCallExpression)complete;
                return call.getMethod() == node;
            }
            if (complete instanceof MethodPointerExpression) {
                MethodPointerExpression ref = (MethodPointerExpression)complete;
                return ref.getMethodName() == node;
            }
            if (complete instanceof ImportNode) {
                ImportNode imp = (ImportNode)complete;
                return node == imp.getAliasExpr() || node == imp.getFieldNameExpr();
            }
            return false;
        }
        return false;
    }

    private boolean hasStaticObjectExpression(Expression node) {
        if (!this.completeExpressionStack.isEmpty()) {
            ASTNode maybeProperty = this.completeExpressionStack.peek();
            if (maybeProperty instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)maybeProperty;
                return prop.getObjectExpression() instanceof ClassExpression || prop.isImplicitThis() && this.scopes.peek().isStatic();
            }
            if (maybeProperty instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)maybeProperty;
                return prop.getObjectExpression() instanceof ClassExpression || prop.isImplicitThis() && this.scopes.peek().isStatic();
            }
            if (maybeProperty instanceof AttributeExpression) {
                AttributeExpression prop = (AttributeExpression)maybeProperty;
                return prop.getObjectExpression() instanceof ClassExpression || prop.isImplicitThis() && this.scopes.peek().isStatic();
            }
        }
        return false;
    }

    private ClassNode findTypeOfBinaryExpression(String operation, ClassNode lhs, ClassNode rhs) {
        char op = operation.charAt(0);
        switch (op) {
            case '*': {
                if (operation.equals("*.") || operation.equals("*.@")) {
                    return VariableScope.clonedList();
                }
            }
            case '~': {
                return VariableScope.STRING_CLASS_NODE;
            }
            case '!': 
            case '<': 
            case '>': {
                if (operation.length() > 1 && operation.equals("<=>")) {
                    return VariableScope.INTEGER_CLASS_NODE;
                }
                return VariableScope.BOOLEAN_CLASS_NODE;
            }
            case 'i': {
                if (operation.equals("is") || operation.equals("in")) {
                    return VariableScope.BOOLEAN_CLASS_NODE;
                }
                return rhs;
            }
            case '.': {
                if (operation.equals(".&")) {
                    return ClassHelper.CLOSURE_TYPE;
                }
                return rhs;
            }
            case '=': {
                if (operation.length() <= 1) break;
                if (operation.charAt(1) == '=') {
                    return VariableScope.BOOLEAN_CLASS_NODE;
                }
                if (operation.charAt(1) != '~') break;
                return VariableScope.MATCHER_CLASS_NODE;
            }
        }
        return rhs;
    }

    private void addCategoryToBeDeclared(ClassNode catNode) {
        this.scopes.peek().setCategoryBeingDeclared(catNode);
    }

    private ClassNode isCategoryDeclaration(MethodCallExpression node) {
        ArgumentListExpression args;
        Expression exprs;
        String methodAsString = node.getMethodAsString();
        if (methodAsString != null && methodAsString.equals("use") && (exprs = node.getArguments()) instanceof ArgumentListExpression && (args = (ArgumentListExpression)exprs).getExpressions().size() >= 2 && args.getExpressions().get(1) instanceof ClosureExpression) {
            VariableScope.VariableInfo info;
            Expression expr = (Expression)args.getExpressions().get(0);
            if (expr instanceof ClassExpression) {
                return expr.getType();
            }
            if (expr instanceof VariableExpression && expr.getText() != null && (info = this.scopes.peek().lookupName(expr.getText())) != null) {
                return info.type;
            }
        }
        return null;
    }

    private void postVisitSanityCheck() {
        Assert.isTrue((boolean)this.completeExpressionStack.isEmpty(), (String)String.format(SANITY_CHECK_MESSAGE, "Expression"));
        Assert.isTrue((boolean)this.primaryTypeStack.isEmpty(), (String)String.format(SANITY_CHECK_MESSAGE, "Primary type"));
        Assert.isTrue((boolean)this.dependentDeclarationStack.isEmpty(), (String)String.format(SANITY_CHECK_MESSAGE, "Declaration"));
        Assert.isTrue((boolean)this.dependentTypeStack.isEmpty(), (String)String.format(SANITY_CHECK_MESSAGE, "Dependent type"));
        Assert.isTrue((boolean)this.scopes.isEmpty(), (String)String.format(SANITY_CHECK_MESSAGE, "Variable scope"));
    }

    static class Tuple {
        ClassNode declaringType;
        ASTNode declaration;

        Tuple(ClassNode declaringType, ASTNode declaration) {
            this.declaringType = declaringType;
            this.declaration = declaration;
        }
    }

    public static class VisitCompleted
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final ITypeRequestor.VisitStatus status;

        public VisitCompleted(ITypeRequestor.VisitStatus status) {
            this.status = status;
        }
    }
}

