/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableReferenceRequestor
implements ITypeRequestor {
    private List<IRegion> references = new ArrayList<IRegion>();
    private SearchRequestor requestor;
    private IJavaElement enclosingElement = null;
    private boolean foundEnclosingElement = false;
    private String variableName;
    private int declStart;
    private SearchParticipant participant;

    public LocalVariableReferenceRequestor(Variable variable, IJavaElement enclosingElement) {
        this(variable.getName(), enclosingElement, null, null, -1);
    }

    public LocalVariableReferenceRequestor(String name, IJavaElement enclosingElement, SearchRequestor requestor, SearchParticipant participant, int declStart) {
        this.enclosingElement = enclosingElement;
        this.variableName = name;
        this.declStart = declStart;
        this.requestor = requestor;
        this.participant = participant;
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (enclosingElement.equals(this.enclosingElement)) {
            this.foundEnclosingElement = true;
            if (node instanceof Variable && ((Variable)node).getName().equals(this.variableName)) {
                IRegion realSourceLocation = this.getRealSourceLocation(node);
                this.references.add(realSourceLocation);
                if (this.requestor != null && realSourceLocation.getOffset() >= this.declStart) {
                    try {
                        this.requestor.acceptSearchMatch((SearchMatch)new LocalVariableReferenceMatch(enclosingElement, 0, realSourceLocation.getOffset(), realSourceLocation.getLength(), true, true, false, this.participant, enclosingElement.getResource()));
                    }
                    catch (CoreException e) {
                        Util.log((Throwable)e);
                    }
                }
            }
        } else if (this.foundEnclosingElement) {
            return ITypeRequestor.VisitStatus.STOP_VISIT;
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private IRegion getRealSourceLocation(ASTNode node) {
        if (node instanceof Parameter) {
            Parameter parameter = (Parameter)node;
            return new Region(parameter.getNameStart(), parameter.getNameEnd() - parameter.getNameStart());
        }
        return new Region(node.getStart(), this.variableName.length());
    }

    public List<IRegion> getReferences() {
        return this.references;
    }
}

