/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.EqualityVisitor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class FieldReferenceSearchRequestor
implements ITypeRequestor {
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final char[] name;
    private final String declaringQualifiedName;
    private final boolean readAccess;
    private final boolean writeAccess;
    private final boolean findDeclarations;
    private final boolean findReferences;
    private final Set<Position> acceptedPositions = new HashSet<Position>();

    public FieldReferenceSearchRequestor(FieldPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.name = (char[])ReflectionUtils.getPrivateField(VariablePattern.class, "name", pattern);
        char[] arr = (char[])ReflectionUtils.getPrivateField(FieldPattern.class, "declaringSimpleName", pattern);
        String declaringSimpleName = arr == null ? "" : new String(arr);
        arr = (char[])ReflectionUtils.getPrivateField(FieldPattern.class, "declaringQualification", pattern);
        String declaringQualification = arr == null || arr.length == 0 ? "" : String.valueOf(new String(arr)) + ".";
        this.declaringQualifiedName = String.valueOf(declaringQualification) + declaringSimpleName;
        this.readAccess = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "readAccess", pattern);
        this.writeAccess = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "writeAccess", pattern);
        this.findDeclarations = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findDeclarations", pattern);
        this.findReferences = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findReferences", pattern);
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        boolean isCompleteMatch;
        Position position;
        VariableExpression vnode;
        boolean doCheck = false;
        boolean isAssignment = false;
        boolean isDeclaration = false;
        int start = 0;
        int end = 0;
        if (node instanceof ConstantExpression) {
            String cName = ((ConstantExpression)node).getText();
            if (cName != null && CharOperation.equals((char[])this.name, (char[])cName.toCharArray())) {
                doCheck = true;
                if (EqualityVisitor.checkForAssignment(node, result.enclosingAssignment)) {
                    isAssignment = true;
                }
                start = node.getStart();
                end = node.getEnd();
            }
        } else if (node instanceof FieldExpression) {
            if (CharOperation.equals((char[])this.name, (char[])((FieldExpression)node).getFieldName().toCharArray())) {
                doCheck = true;
                if (EqualityVisitor.checkForAssignment(node, result.enclosingAssignment)) {
                    isAssignment = true;
                }
                end = node.getEnd();
                start = end - this.name.length;
            }
        } else if (node instanceof FieldNode) {
            FieldNode fnode = (FieldNode)node;
            if (CharOperation.equals((char[])this.name, (char[])fnode.getName().toCharArray())) {
                doCheck = true;
                isDeclaration = true;
                isAssignment = true;
                start = fnode.getNameStart();
                end = fnode.getNameEnd() + 1;
            }
        } else if (node instanceof VariableExpression && CharOperation.equals((char[])this.name, (char[])(vnode = (VariableExpression)node).getName().toCharArray())) {
            doCheck = true;
            if (EqualityVisitor.checkForAssignment(node, result.enclosingAssignment)) {
                isAssignment = true;
            }
            start = vnode.getStart();
            end = start + vnode.getName().length();
        }
        if (doCheck && end > 0 && !this.acceptedPositions.contains(position = new Position(start, end - start)) && (isCompleteMatch = this.qualifiedNameMatches(this.removeArray(result.declaringType))) && (isAssignment && this.writeAccess || !isAssignment && this.readAccess || isDeclaration && this.findDeclarations)) {
            IJavaElement realElement;
            FieldDeclarationMatch match = null;
            IJavaElement iJavaElement = realElement = enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement) : enclosingElement;
            if (isDeclaration && this.findDeclarations) {
                match = new FieldDeclarationMatch(realElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, this.participant, realElement.getResource());
            } else if (!isDeclaration && this.findReferences) {
                match = new FieldReferenceMatch(realElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, !isAssignment, isAssignment, false, this.participant, realElement.getResource());
            }
            if (match != null) {
                try {
                    this.requestor.acceptSearchMatch(match);
                    this.acceptedPositions.add(position);
                }
                catch (CoreException e) {
                    Util.log((Throwable)e, (String)("Error reporting search match inside of " + realElement + " in resource " + realElement.getResource()));
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean qualifiedNameMatches(ClassNode declaringType) {
        if (declaringType == null) {
            return false;
        }
        if (this.declaringQualifiedName == null || this.declaringQualifiedName.equals("")) {
            return true;
        }
        return declaringType.getName().equals(this.declaringQualifiedName);
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence, boolean isCompleteMatch) {
        if (this.shouldAlwaysBeAccurate()) {
            return 0;
        }
        if (!isCompleteMatch) {
            return 1;
        }
        switch (confidence) {
            case EXACT: {
                return 0;
            }
        }
        return 1;
    }

    private boolean shouldAlwaysBeAccurate() {
        return this.requestor.getClass().getPackage().getName().indexOf("refactoring") != -1;
    }

    private ClassNode removeArray(ClassNode declaration) {
        return declaration != null && declaration.getComponentType() != null ? this.removeArray(declaration.getComponentType()) : declaration;
    }
}

