/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTypeLookup
implements ITypeLookup {
    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (node instanceof ConstantExpression || node instanceof VariableExpression) {
            Set<ClassNode> categories = scope.getCategoryNames();
            ClassNode currentType = objectExpressionType != null ? objectExpressionType : scope.getDelegateOrThis();
            ArrayList<MethodNode> possibleMethods = new ArrayList<MethodNode>();
            String text = node.getText();
            if (text.startsWith("${") && text.endsWith("}")) {
                text = text.substring(2, text.length() - 1);
            } else if (text.startsWith("$")) {
                text = text.substring(1);
            }
            String getterName = AccessorSupport.GETTER.createAccessorName(text);
            String setterName = AccessorSupport.SETTER.createAccessorName(text);
            for (ClassNode category : categories) {
                List methods = category.getMethods(text);
                possibleMethods.addAll(methods);
                if (getterName != null) {
                    methods = category.getMethods(getterName);
                    for (MethodNode method : methods) {
                        if (!method.isStatic() || AccessorSupport.findAccessorKind(method, true) != AccessorSupport.GETTER) continue;
                        possibleMethods.add(method);
                    }
                }
                if (setterName == null) continue;
                methods = category.getMethods(setterName);
                for (MethodNode method : methods) {
                    if (!method.isStatic() || AccessorSupport.findAccessorKind(method, true) != AccessorSupport.SETTER) continue;
                    possibleMethods.add(method);
                }
            }
            ClassNode normalizedType = GroovyUtils.getWrapperTypeIfPrimitive(currentType);
            for (MethodNode methodNode : possibleMethods) {
                Parameter[] params = methodNode.getParameters();
                if (params == null || params.length <= 0 || !this.isAssignableFrom(normalizedType, params[0].getType())) continue;
                ClassNode declaringClass = methodNode.getDeclaringClass();
                ClassNode returnType = SimpleTypeLookup.typeFromDeclaration((ASTNode)methodNode, currentType);
                TypeLookupResult.TypeConfidence confidence = this.getConfidence(declaringClass);
                if (confidence == TypeLookupResult.TypeConfidence.LOOSELY_INFERRED) {
                    confidence = this.checkParameters(params, scope.getMethodCallArgumentTypes());
                }
                TypeLookupResult result = new TypeLookupResult(returnType, declaringClass, (ASTNode)methodNode, confidence, scope);
                result.isGroovy = true;
                return result;
            }
        }
        return null;
    }

    private TypeLookupResult.TypeConfidence getConfidence(ClassNode declaringClass) {
        boolean contains = VariableScope.ALL_DEFAULT_CATEGORIES.contains(declaringClass);
        return contains ? TypeLookupResult.TypeConfidence.LOOSELY_INFERRED : TypeLookupResult.TypeConfidence.INFERRED;
    }

    private TypeLookupResult.TypeConfidence checkParameters(Parameter[] params, List<ClassNode> arguments) {
        if (arguments == null || arguments.size() == 0) {
            return TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
        }
        if (params.length != arguments.size() + 1) {
            return TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
        }
        int i = 0;
        while (i < arguments.size()) {
            if (!arguments.get(i).equals((Object)params[i + 1].getOriginType())) {
                return TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
            }
            ++i;
        }
        return TypeLookupResult.TypeConfidence.EXACT;
    }

    private void findAllSupers(ClassNode clazz, Set<String> allSupers) {
        String name = clazz.getName();
        if (!allSupers.contains(name)) {
            allSupers.add(name);
            if (clazz.getSuperClass() != null) {
                this.findAllSupers(clazz.getSuperClass(), allSupers);
            }
            if (clazz.getInterfaces() != null) {
                ClassNode[] classNodeArray = clazz.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode superInterface = classNodeArray[n2];
                    this.findAllSupers(superInterface, allSupers);
                    ++n2;
                }
            }
        }
    }

    private boolean isAssignableFrom(ClassNode source, ClassNode target) {
        if (source == null || target == null) {
            return false;
        }
        String sourceName = source.getName();
        String targetName = target.getName();
        HashSet<String> allSupers = new HashSet<String>();
        allSupers.add("java.lang.Object");
        if (sourceName.startsWith("[")) {
            allSupers.add("[Ljava.lang.Object;");
        }
        this.findAllSupers(source, allSupers);
        for (String superName : allSupers) {
            if (!targetName.equals(superName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        return null;
    }

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
    }
}

