/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.jdt.groovy.search.VariableScope;

public class AssignmentStorer {
    public void storeAssignment(BinaryExpression assign, VariableScope scope, ClassNode rhsType) {
        if (assign instanceof DeclarationExpression) {
            DeclarationExpression declExpr = (DeclarationExpression)assign;
            if (declExpr.isMultipleAssignmentDeclaration()) {
                TupleExpression tuple = (TupleExpression)declExpr.getLeftExpression();
                this.handleMultiAssignment(scope, rhsType, (BinaryExpression)declExpr, tuple);
            } else {
                VariableExpression variableExpression = declExpr.getVariableExpression();
                ClassNode varType = variableExpression.getOriginType() != null ? variableExpression.getOriginType() : variableExpression.getType();
                ClassNode typeToStore = !VariableScope.isVoidOrObject(varType) && !varType.equals((Object)VariableScope.OBJECT_CLASS_NODE) ? varType : (rhsType != null ? rhsType : VariableScope.OBJECT_CLASS_NODE);
                scope.addVariable(variableExpression.getName(), typeToStore, null);
            }
        } else if (this.isInterestingOperation(assign) && !VariableScope.isVoidOrObject(rhsType)) {
            if (assign.getLeftExpression() instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)assign.getLeftExpression();
                ClassNode declaringType = this.findDeclaringType(var);
                if (scope.inScriptRunMethod()) {
                    scope.updateOrAddVariable(var.getName(), rhsType, declaringType);
                } else {
                    scope.updateVariable(var.getName(), rhsType, declaringType);
                }
            } else if (assign.getLeftExpression() instanceof TupleExpression) {
                TupleExpression tuple = (TupleExpression)assign.getLeftExpression();
                this.handleMultiAssignment(scope, rhsType, assign, tuple);
            }
        }
    }

    public void storeField(FieldNode node, VariableScope scope) {
        Expression init = node.getInitialExpression();
        if (!this.isObjectType(init)) {
            scope.addVariable(node.getName(), init.getType(), node.getDeclaringClass());
        }
    }

    public void storeImport(ImportNode node, VariableScope scope) {
        block6: {
            List methods;
            ClassNode type;
            block5: {
                type = node.getType();
                if (!node.isStar() || type == null) break block5;
                List fields = type.getFields();
                for (FieldNode field : fields) {
                    if (!field.isStatic()) continue;
                    scope.addVariable(field.getName(), field.getType(), type);
                }
                List methods2 = node.getType().getMethods();
                for (MethodNode method : methods2) {
                    if (!method.isStatic()) continue;
                    scope.addVariable(method.getName(), method.getReturnType(), type);
                }
                break block6;
            }
            String fieldName = node.getFieldName();
            if (!node.isStatic() || type == null || fieldName == null) break block6;
            String alias = node.getAlias() != null ? node.getAlias() : fieldName;
            FieldNode field = type.getField(fieldName);
            if (field != null) {
                scope.addVariable(alias, field.getType(), type);
            }
            if ((methods = type.getDeclaredMethods(fieldName)) != null) {
                for (MethodNode method : methods) {
                    scope.addVariable(alias, method.getReturnType(), type);
                }
            }
        }
    }

    public void storeParameterType(Parameter node, VariableScope scope) {
        scope.addVariable((Variable)node);
    }

    private void handleMultiAssignment(VariableScope scope, ClassNode objectExpressionType, BinaryExpression binaryExpr, TupleExpression tuple) {
        ClassNode maybeType = this.findComponentType(objectExpressionType);
        ListExpression rhs = binaryExpr.getRightExpression() instanceof ListExpression ? (ListExpression)binaryExpr.getRightExpression() : null;
        List lhsExprs = tuple == null ? Collections.emptyList() : tuple.getExpressions();
        List rhsExprs = rhs == null ? Collections.emptyList() : rhs.getExpressions();
        int i = 0;
        int lhsSize = lhsExprs.size();
        int rhsSize = rhsExprs.size();
        while (i < lhsSize) {
            ClassNode rhsType;
            Expression lhsExpr = (Expression)lhsExprs.get(i);
            ClassNode classNode = rhsType = i < rhsSize ? ((Expression)rhsExprs.get(i)).getType() : maybeType;
            if (lhsExpr instanceof VariableExpression) {
                scope.addVariable(((Variable)lhsExpr).getName(), rhsType, null);
            }
            ++i;
        }
    }

    private ClassNode findComponentType(ClassNode objectExpressionType) {
        if (objectExpressionType == null) {
            return VariableScope.OBJECT_CLASS_NODE;
        }
        return VariableScope.extractElementType(objectExpressionType);
    }

    private boolean isInterestingOperation(BinaryExpression assign) {
        switch (assign.getOperation().getType()) {
            case 100: {
                return true;
            }
        }
        return false;
    }

    private ClassNode findDeclaringType(VariableExpression var) {
        return var.getAccessedVariable() instanceof AnnotatedNode ? ((AnnotatedNode)var.getAccessedVariable()).getDeclaringClass() : null;
    }

    private boolean isObjectType(Expression init) {
        return init == null || ClassHelper.OBJECT_TYPE.equals((Object)init.getType());
    }
}

