/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFolderSelector {
    private char[][] scriptPatterns;
    private boolean[] doCopy;
    private final boolean enabled;
    private IEclipsePreferences preferences;

    public static boolean isEnabled(IProject project) {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            IEclipsePreferences preferences = activator.getProjectOrWorkspacePreferences(project);
            return activator.getBooleanPreference(preferences, "groovy.script.filters.enabled", false);
        }
        return false;
    }

    public ScriptFolderSelector(IProject project) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            this.enabled = false;
        } else {
            this.preferences = activator.getProjectOrWorkspacePreferences(project);
            boolean isEnabled = activator.getBooleanPreference(this.preferences, "groovy.script.filters.enabled", false);
            if (!isEnabled) {
                this.enabled = false;
                this.scriptPatterns = null;
            } else {
                this.init(activator.getListStringPreference(this.preferences, "groovy.script.filters", "**/*.dsld,y,scripts/**/*.groovy,y,src/main/resources/**/*.groovy,y,src/test/resources/**/*.groovy,y"));
                this.enabled = true;
            }
        }
    }

    protected ScriptFolderSelector(List<String> preferences, boolean isEnabled) {
        this.enabled = isEnabled;
        this.init(preferences);
    }

    private void init(List<String> listStringPreference) {
        int size;
        if (listStringPreference == null) {
            this.scriptPatterns = CharOperation.NO_CHAR_CHAR;
            this.doCopy = new boolean[0];
        }
        if ((size = listStringPreference.size()) % 2 == 0) {
            this.scriptPatterns = new char[size / 2][];
            this.doCopy = new boolean[size / 2];
        } else {
            this.scriptPatterns = new char[1 + size / 2][];
            this.doCopy = new boolean[1 + size / 2];
        }
        int count = 0;
        int index = 0;
        for (String patternStr : listStringPreference) {
            if (count++ % 2 == 0) {
                this.scriptPatterns[index] = patternStr.toCharArray();
                continue;
            }
            char[] pattern = patternStr.toCharArray();
            boolean bl = this.doCopy[index++] = pattern.length > 0 && pattern[0] == 'y';
        }
    }

    public FileKind getFileKind(char[] filepath) {
        if (this.enabled && filepath != null) {
            int i = 0;
            while (i < this.scriptPatterns.length) {
                char[] pattern = this.scriptPatterns[i];
                if (CharOperation.pathMatch((char[])pattern, (char[])filepath, (boolean)true, (char)'/')) {
                    return this.doCopy[i] ? FileKind.SCRIPT : FileKind.SCRIPT_NO_COPY;
                }
                ++i;
            }
        }
        return FileKind.SOURCE;
    }

    public FileKind getFileKind(IResource file) {
        if (file == null || !this.enabled) {
            return FileKind.SOURCE;
        }
        return this.getFileKind(file.getProjectRelativePath().toPortableString().toCharArray());
    }

    public boolean isScript(char[] filepath) {
        if (filepath == null || !this.enabled) {
            return false;
        }
        FileKind kind = this.getFileKind(filepath);
        return kind == FileKind.SCRIPT || kind == FileKind.SCRIPT_NO_COPY;
    }

    public boolean isScript(IResource file) {
        if (file == null || !this.enabled) {
            return false;
        }
        return this.isScript(file.getProjectRelativePath().toPortableString().toCharArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileKind {
        SOURCE,
        SCRIPT,
        SCRIPT_NO_COPY;

    }
}

